/*
    ANSI C Runtime library

    Copyright 1983,1984,1985,1986,1987,1988 by Green Hills Software Inc.

    This program is the property of Green Hills Software, Inc,
    its contents are proprietary information and no part of it
    is to be disclosed to anyone except employees of Green Hills
    Software, Inc., or as agreed in writing signed by the President
    of Green Hills Software, Inc.
*/

#ifndef _SIGNAL_H
#define _SIGNAL_H

typedef int sig_atomic_t;

#define SIG_DFL         ((void (*)(int)) 0)
#define SIG_IGN         ((void (*)(int)) 1)
#define SIG_ERR         ((void (*)(int)) (-1))

#define SIGINT          2
#define SIGILL          4
#define SIGABRT         6
#define SIGFPE          8
#define SIGSEGV         11
#define SIGTERM         15

/* standard bsd signals in addition to these */
#define SIGHUP          1
/* SIGINT */
#define SIGQUIT         3
/* SIGILL */
#define SIGTRAP         5
#define SIGIOT          SIGABRT
#define SIGEMT          7
/* SIGFPE */
#define SIGKILL         9
#define SIGBUS          10
/* SIGSEGV */
#define SIGSYS          12
#define SIGPIPE         13
#define SIGALRM         14
/* SIGTERM */
#define SIGURG          17
#define SIGSTOP         18
#define SIGTSTP         19
#define SIGCONT         20
#define SIGCHLD         21
#define SIGCLD          SIGCHLD
#define SIGTTIN         22
#define SIGTTOU         23
#define SIGIO           24
#define SIGXCPU         25
#define SIGXTIM         26
#define SIGXFSZ         27
#define SIGVTALRM       28
#define SIGPROF         29
#define SIGWINCH        30
#define SIGUSR1         31
#define SIGUSR2         32

#define _SIGMAX         SIGUSR2

void (*signal(int sig, void (*func)(int)))(int);
int raise(int sig);
#endif  /* _SIGNAL_H */
