/*
    ANSI C Runtime library

    Copyright 1983,1984,1985,1986,1987,1988 by Green Hills Software Inc.

    This program is the property of Green Hills Software, Inc,
    its contents are proprietary information and no part of it
    is to be disclosed to anyone except employees of Green Hills
    Software, Inc., or as agreed in writing signed by the President
    of Green Hills Software, Inc.
*/

#ifndef _MATH_H
#define _MATH_H

#include <errno.h>              /* define EDOM,ERANGE */
#define HUGE_VAL    1.7976931348623167e+307     /* Max IEEE double, or nearly */

double acos(double x);
double asin(double x);
double atan(double x);
double atan2(double y, double x);
double cos(double x);
double sin(double x);
double tan(double x);

double cosh(double x);
double sinh(double x);
double tanh(double x);

double exp(double x);
double frexp(double value, int *exp);
double ldexp(double x, int exp);
double log(double x);
double log10(double x);
double modf(double value, double *iptr);

double pow(double x, double y);
double sqrt(double x);

double ceil(double x);
double fabs(double x);
double floor(double x);
double fmod(double x, double y);

#ifdef _MATH_EXTENSIONS
double erf(double);
double erfc(double);
double j0(double);
double j1(double);
double jn(int,double);
double y0(double);
double y1(double);
double yn(int,double);
double gamma(double);
double hypot(double,double);
#endif  /* _MATH_EXTENSIONS */

#ifdef _FLOAT_EXTENSIONS
double acosf(double x);
double asinf(double x);
double atanf(double x);
double atan2f(double y, double x);
double cosf(double x);
double sinf(double x);
double tanf(double x);

double coshf(double x);
double sinhf(double x);
double tanhf(double x);

double expf(double x);
double frexpf(double value, int *exp);
double ldexpf(double x, int exp);
double logf(double x);
double log10f(double x);
double modff(double value, double *iptr);

/*double pow(double x, double y);*/
double sqrtf(double x);

/*double ceil(double x);*/
/*double fabs(double x);*/
/*double floor(double x);*/
/*double fmod(double x, double y);*/
#endif  /* _FLOAT_EXTENSIONS */
#endif  /* _MATH_H */
