/*
    ANSI C Runtime library

    Copyright 1983,1984,1985,1986,1987,1988 by Green Hills Software Inc.

    This program is the property of Green Hills Software, Inc,
    its contents are proprietary information and no part of it
    is to be disclosed to anyone except employees of Green Hills
    Software, Inc., or as agreed in writing signed by the President
    of Green Hills Software, Inc.
*/

#ifndef _LOCAL_H
#define _LOCAL_H
struct lconv {
    char *decimal_point;        /* "." */
    char *thousands_sep;        /* "" */
    char *int_curr_symbol;      /* "" */
    char *currency_symbol;      /* "" */
    char *mon_decimal_point;    /* "" */
    char *mon_thousands_sep;    /* "" */
    char *negative_sign;        /* "" */
    char frac_digits;           /* CHAR_MAX */
    char p_cs_precedes;         /* CHAR_MAX */
    char p_sep_by_space;        /* CHAR_MAX */
    char n_sc_precedes;         /* CHAR_MAX */
    char n_sep_by_space;        /* CHAR_MAX */
    char n_sign_point;          /* CHAR_MAX */
};

#define LC_ALL              (LC_COLLATE|LC_CTYPE|LC_MONETARY|LC_NUMERIC|LC_TIME)
#define LC_COLLATE          (1<<0)
#define LC_CTYPE            (1<<1)
#define LC_MONETARY         (1<<2)
#define LC_NUMERIC          (1<<3)
#define LC_TIME             (1<<4)

char *setlocale(int category, const char *locale);
struct lconv *localeconv(void);
#endif /* _LOCAL_H */
