#include <sys/types.h>
#include <sys/param.h>
#include <machine/pte.h>
#include <stdio.h>
#include <nlist.h>
#include <errno.h>
#include <wipc/wipc_minfo.h>

#define	NMINFO		128
struct iface iface[NIFACE], *ifaddr;
struct minfo  mftab[NMINFO], *minfo, *xminfo;

struct nlist nl[] = {
#define	X_IFACE		0
	{ "_iface" },
#define	X_MINFO		1
	{ "_minfo" },
#define	X_XMINFO	2
	{ "_xminfo" },
#define	X_WIPC_IP_RECV	3
	{ "_wipc_ip_xmit" },
#define	X_WIPC_IP_RELSE	4
	{ "_wipc_ip_relse" },
#define	X_EX_RECV	5
	{ "_ex_xmit" },
#define	X_EX_RELSE	6
	{ "_ex_relse" },
#define	X_NW_RECV	7
	{ "_nw_xmit" },
#define	X_NW_RELSE	8
	{ "_nw_relse" },
#define	X_VB_RECV	9
	{ "_vb_xmit" },
#define	X_VB_RELSE	10
	{ "_vb_relse" },
#define	X_ENP_RECV	11
	{ "_enp_xmit" },
#define	X_ENP_RELSE	12
	{ "_enp_relse" },
#define	X_IL_RECV	13
	{ "_il_xmit" },
#define	X_IL_RELSE	14
	{ "_il_relse" },
#define	X_WLOOP_RECV	15
	{ "_wloop_xmit" },
#define	X_WLOOP_RELSE	16
	{ "_wloop_relse" },
#define	X_TR_RECV	17
	{ "_tr_xmit" },
#define	X_TR_RELSE	18
	{ "_tr_relse" },
#define	X_ETHERBROADCASTADDR	19
	{ "_etherbroadcastaddr" },
#define	SYSMAP	20
	{ "_Sysmap" },
	{ "" },
};

#ifdef	vax
#define	clear(x) ((int)x&0x7fffffff)
#endif	vax
#ifdef	is68k
#define	clear(x) ((int)x&0x0fffffff)
#endif	is68k

int	mem;

main(argc, argv)
	int argc;
	char *argv[];
{
	if (argc > 1) {
		nlist(argv[1], nl);
		argc--;
		argv++;
	} else
		nlist("/vmunix", nl);
	if (nl[0].n_type==0)
		done("Can't get kernel namelist\n");
	if (argc > 1) {
		mem = open(argv[1], 0);
		argc--;
		argv++;
	} else
		mem = open("/dev/mem", 0);
	if (mem < 0)
		done("Can't read kernel memory\n");
	get_iface();
	get_minfo();
	pr_iface();
	pr_minfo();
}

get_iface()
{
	if ((ifaddr = (struct iface *)mkphys(nl[X_IFACE].n_value))  &&
	    lseek(mem, (long)ifaddr, 0) == (long)ifaddr  &&
	    read(mem, iface, sizeof iface) == sizeof iface)
		return 0;
	return -1;
}

get_minfo()
{
	register struct minfo *mp, *next;

	if ((next = (struct minfo *)mkphys(nl[X_MINFO].n_value))  &&
	    lseek(mem, (long)next, 0) == (long)next  &&
	    read(mem, &minfo, sizeof minfo) == sizeof minfo  &&
	    (next = (struct minfo *)mkphys(nl[X_XMINFO].n_value))  &&
	    lseek(mem, (long)next, 0) == (long)next  &&
	    read(mem, &xminfo, sizeof xminfo) == sizeof xminfo) {
		for (next = (struct minfo *)mkphys(xminfo), mp = mftab;
		     next  &&  mp < &mftab[NMINFO];
		     next = (struct minfo *)mkphys(mp->xnext), mp += 1)
			if (lseek(mem, (long)next, 0) != (long)next  ||
			    read(mem, mp, sizeof *mp) != sizeof *mp)
				return -1;
		return 0;
	}
	return -1;
}

pr_iface()
{
	register struct iface *ip;
	char xsym[14], rsym[15], bsym[17];
	register int i;

	printf("Interfaces:\n");
	printf("\
  IF FLAGS UNIT NALEN BURST PKLEN XMIT          RELSE          BROADCAST_ADDR\n");
	for (ip = iface, i = 0;  ip < &iface[NIFACE];  ip += 1, i++) 
            if (ip->xmit) {
		sym(ip->xmit, xsym, sizeof xsym);
		sym(ip->relse, rsym, sizeof rsym);
		sym(ip->bcst, bsym, sizeof bsym);
		printf("  %2d %5d %4d %5d %5d %5d %-13s %-14s %-16s\n",
			i, ip->flags, ip->unit, ip->nalen, ip->pkburst,
			ip->pklen, xsym, rsym, bsym);
	    }
	printf("\n");
}

sym(addr, p, n)
	register unsigned long addr;
	char *p;
	int n;
{
	register struct nlist *np;

	if (addr == 0) {
		strcpy(p, "0");
		return;
	}
	for (np = nl;  np->n_name  &&  np->n_name[0];  np += 1) {
		if (np->n_value == addr) {
			strncpy(p, &np->n_name[1], n);
			p[n-1] = 0;
			return;
		}
	}
	sprintf(p, "0x%X", addr);
}

pr_minfo()
{
	register struct minfo *mp = mftab;
	register int i;
	char *np;

	if (mp->ifp == (struct iface *)0)
		return;
	printf("Connections:\n");
	printf("\
  RMID RRMID FLAGS REF  PGRP IF PKLEN PKBURST ADDRESS          NAME\n");
	do {
		mp->ifp = (struct minfo *)mkphys(mp->ifp);
		printf("  %4X %5X %5X %3d %5d %2d %5d %7d ",
			mp->rmid >> 16, mp->rrmid >> 16,
			mp->flags, mp->ref,
			mp->pgrp, mp->ifp - ifaddr,
			mp->pklen, mp->pkburst);
		for (i = 0 ; i < sizeof(mp->naddr); i++)
			printf("%02x", mp->naddr[i] & 0xFF);
		for (np = mp->names; *np; np++) {
			printf(" %s",np);
			while (*np)
				np++;
		}
		printf("\n");
		if (mp->xnext == (struct minfo *)0)
			break;
	} while (++mp < &mftab[NMINFO]);
}


/* taken from pstat.c
 * "addr"  is a kern virt addr and does not correspond
 * To a phys addr after zipping out the high bit..
 * since it was valloc'd in the kernel.
 *
 * We return the phys addr by simulating kernel vm (/dev/mem)
 * when we are reading a crash dump.
 */
mkphys(addr)
	int addr;
{
	register int o, *p;
	struct pte pte;

	o = addr & PGOFSET;
	addr >>= PGSHIFT;
	addr &= PG_PFNUM;
	addr *=  NBPW;
	p = (int *)&pte;
	*p = getw(nl[SYSMAP].n_value + addr);
	addr = (pte.pg_pfnum << PGSHIFT) | o;
	return(addr);
}

getl(loc)
	off_t loc;
{
	int word;

	loc = clear(loc);
	lseek(mem, loc, 0);
	read(mem, &word, sizeof (word));
	return (word);
}

done(s)
char *s;
{
	if (s) {
		pdate();
		printf(s);
		exit(1);
	} else
		exit(0);
}

pdate()
{
	extern char *ctime();
	static firstime;
	time_t tbuf;

	if (firstime==0) {
		firstime++;
		time(&tbuf);
		printf("\n%.12s\n", ctime(&tbuf)+4);
	}
}
