%start	SP_CONFIG
%token	DIGIT ZERO

%%

SP_CONFIG	:	/* empty */
		|	CONFIG
		|	SP_CONFIG CONFIG
		;

CONFIG		:	SP NUM 'c' '(' LIST ')'
				{
					do_config( $2 );
					init_config();
				}
		;

LIST		:	SEG
		|	LIST ',' SEG
		;

SEG		:	'(' NUM ',' NUM ')'
				{ do_seg( $2, $4 ); }
		;

SP		:	's' 'p'
		;

NUM		:	DIGIT
				{ $$ = yylval; }
		|	NUM DIGIT
				{ $$ = (10 * $1) + $2; }
		;
%%

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/spaninfo.h>
#define streq(a,b)	(!strcmp((a),(b)))

struct spaninfo spinfo;
int		nextseg;
FILE		*infp = NULL;
int		loadflag=0, forceflag=0;
char		*spname[] = { "sp0c", "sp1c", "sp2c", "sp3c", 0 };

main( ac, av )
int	ac;
char	*av[];
{
	int	i;

	for ( i = 1 ;  i < ac ;  ++i ) {
		if ( streq(av[i], "-a") )
			loadflag = 1;
		else if ( streq(av[i], "-f") )
			forceflag = 1;
		else {
			fprintf(stderr, "%s: illegal arg: %s\n", av[0], av[i]);
			exit( 4 );
		}
	}
	
	if ( loadflag ) {
		infp = fopen( "/etc/sptab", "r" ) ;
		if ( ! infp ) {
			fprintf(stderr, "%s: can't open /etc/sptab\n", av[0]);
			exit( 1 ) ;
		}
	}

	if ( loadflag ) {
		init_config();
		return( yyparse() );
	}
	else
		return( report() ) ;
}

init_config()
{
	for ( nextseg=0 ; nextseg < Nsp_segs; nextseg++ )
		spinfo.sp_dev[nextseg] = 0;

	nextseg = 0;
	
}

do_seg( maj, mnr )
{
	if ( nextseg < Nsp_segs ) {
		spinfo.sp_dev[nextseg] = makedev( maj, mnr );
		nextseg++;
	}
}

do_config( unit )
{
	if ( nextseg > Nsp_segs )
		fprintf( stderr, "too many segments for %s\n", spname[unit] );
	else
		do_load( unit );
}

do_load( unit )
{
	int	i, x, fd;
	char	name[100];
	struct spaninfo *psp, *getinfo();

#ifdef showload
	printf( "%s:\n", spname[unit] );
	for ( i = 0 ;  spinfo.sp_dev[i] ;  i++ )
		printf( "\t( %d, %d )\n",
		    major(spinfo.sp_dev[i]), minor(spinfo.sp_dev[i]));
#endif

	psp = getinfo (unit);
	if ( psp == (struct spaninfo *)NULL ) {
		fprintf( stderr, "spconfig: can't open /dev/r%s\n", spname[unit]);
		return;
	}
	if ( psp->sp_dev[0] && (! forceflag) ) {
		fprintf( stderr, "spconfig: sp%dc already configured\n", unit );
		return;
	}
	sprintf (name, "/dev/r%s", spname[unit]);
	fd = open( name, 0 ) ;
	if ( fd < 0 ) {
		fprintf( stderr, "spconfig: can't open %s (wtf!)\n", name );
		exit( 1 );
	}
	if ( (x=ioctl(fd, SSPANINFO, &spinfo)) < 0 ) {
		fprintf( stderr, "spconig: ioctl failed (err=%d)\n", x );
		perror("spconfig");
		exit( 1 );
	}
}

yylex()
{
	int	c;

again:
	c = getc(infp);
	if ( c < 0 )
		return( 0 ) ;
	while ( c == ' ' || c == '\t' || c == '\n' )
		c = getc(infp);
	if ( isdigit(c) ) {
		yylval = c - '0';
		return( DIGIT );
	}
	else if ( c == '#' ) {
		/*
		 * Comment - throw away up to end of line.
		 */
		c = getc(infp);
		while ( (c != '\n') && (c >= 0) )
			c = getc(infp);
		goto again;
	}
	else
		return( c==0 ? ZERO : c );
}

yyerror(s)
char	*s;
{
	fprintf( stderr, "%s\n", s );
}

report()
{
	int	i;

	for (i=0; i<4; ++i)
		do_report (i);
}

do_report( unit )
{
	struct spaninfo *psp, *getinfo();
	int		i;

	psp = getinfo (unit);
	if ( psp == (struct spaninfo *)NULL )
		return;
	printf( "%s: (", spname[unit] );
	for ( i = 0 ;  psp->sp_dev[i] ;  i++ ) {
		printf( "(%d,%d)",
		    major(psp->sp_dev[i]), minor(psp->sp_dev[i]));
		if ( psp->sp_dev[i+1] )
			printf (",");
	}
	if ( i == 0 )
		printf ("**not configured**)\n");
	else
		printf (")\n");
}

/*
 * getinfo(unit)
 *
 * for given sp device, get current config info in a local struct
 * spinfo and return a pointer to same.
 */

struct spaninfo * getinfo(unit)
{
	static struct spaninfo spinfo;
	int	fd;
	char	name[100];

	sprintf (name, "/dev/r%s", spname[unit]);
	fd = open( name, 0 ) ;
	if ( fd < 0 )
		return( (struct spaninfo *)NULL );

	if ( ioctl(fd, GSPANINFO, &spinfo) < 0 ) {
		perror("spconfig");
		exit( 1 );
	}
	close (fd);
	return (&spinfo);
}
