/* software reset of clusters */
#include <sys/file.h>
#include <sys/mman.h>
#include <errno.h>
#include <stdio.h>
#include <signal.h>
#include <machine/board.V25.h>

/* from /usr/src/sys/is68kif/if_vbreg.h */
#define	VBRESETADDR(i)	(0xC010 + (i << 1))

int cluster, bus_error();

main(argc, argv)
int argc;
char **argv;
{
	int fd, ipi, ps = getpagesize();
	char *vme_short;

	if ((fd = open("/dev/vme_short", O_RDWR)) < 0) {
		perror("resetclu: open /dev/vme_short");
		exit(1);
	}
	if ((vme_short = (char *)malloc (0x10000 + ps-1)) == 0) {
		perror("resetclu: malloc");
		exit(1);
	}
	vme_short = (char *)(((int)vme_short + ps) & ~(ps - 1));
	if (mmap(vme_short, 0x10000, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0)) {
		perror("resetclu: mmap");
		exit(1);
	}
	signal(SIGBUS, bus_error);
	while (--argc) {
		cluster = atoi(*(++argv));
		if (cluster < 0 || cluster > 7) {
			printf("resetclu: invalid cluster number\n");
			exit(1);
		}
		ipi = VBRESETADDR(cluster);
/*		printf("   ipi @%x\n", ipi); /**/

		/* reference reset as argument */
		printf("Reseting cluster %d\n", cluster, vme_short[ipi]);
	}
}

bus_error()
{
	printf("resetclu: cluster %d not responding\n", cluster);
	exit(1);
}
