#include <sys/param.h>
#include <stdio.h>
#include <sys/time.h>
#include <sys/file.h>
#include <strings.h>
#include <a.out.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <is68kif/if_ring.h>
#define	NW_STATS
#include <is68kif/if_nwreg.h>

char *device = "/dev/nwr0";
#define	NW_DEVINDX	8

char *filename;
int nw;
FILE *fw, *fopen();

usage() {
	printf("usage:	nwstat [dev]	 	print statistics\n");
	printf("	nwstat -z [dev]	 	zero statistics\n");
	printf("	nwstat -g [dev]		issue go command\n");
	printf("	nwstat -l file [dev]	download file\n");
	printf("	nwstat -r [dev]		reset board\n");
	printf("	nwstat -d [file] [dev]	dump dual ported memory\n");
	printf("	nwstat -D [dev]		nw debug mode\n");
	exit(1);
}

main(argc, argv)
	int argc;
	char *argv[];
{
	argc--; argv++;

	if (*argv[0] == '-') {
		argc--; argv++;
more:
		argv[-1]++;
		switch (*argv[-1]) {
		    case '0':
		    case '1':
		    case '2':
		    case '3':
			device[NW_DEVINDX] = *argv[-1];
			goto more;

		    case 'g':
			nwgo(argc, argv);
			break;
			
		    case 'l':
			nwload(argc, argv);
			break;

		    case 'r':
			nwreset(argc, argv);
			break;

		    case 'z':
			nwstat(argc, argv, 1);
			break;

		    case 'd':
			nwdump(argc, argv);
			break;

		    case 'D':
			nwdebug(argc, argv);
			break;

		    case 0:
		    case 's':
			nwstat(argc, argv, 0);
			break;

		    default:
			usage();
			break;
		}
	} else
		nwstat(argc, argv, 0);
}

nwstat(argc, argv, zero) 
	int argc;
	char *argv[];
{
	register int *ip;
	register int i, j;
	int stats [NUMBER_OF_STATS];

	if (argc == 1)
		device = *argv;
	else if (argc > 1) 
		usage();

	if ((nw = open(device, O_RDWR)) < 0) {
		perror("nwstat: open");
		exit(1);
	}

	lseek(nw, &(((struct nwdevice *)0)->nw_stat[0]), L_SET);
	bzero(stats, sizeof(stats));
	if (zero) {
		if (write(nw, stats, sizeof(stats)) != sizeof(stats)) {
			perror("nwstat: write");
			exit(1);
		}
	} else {
		if (read(nw, stats, sizeof(stats)) != sizeof(stats)) {
			perror("nwstat: read");
			exit(1);
		}
		for (i=j=0, ip=(int *)stats; i*4 < sizeof(stats); i++, ip++)
			if (*ip) {
				j++;
				printf("  %20s	%d\n", nw_stat_names[i], *ip);
			}
		if (j == 0)
			printf("  no stats\n");
	}
        close(nw);
}

nwload(argc, argv)
	int argc;
	char *argv[];
{
	int total, i;
	u_short ctl_stat = 0xffff;
	char *p, *malloc();
        struct exec exec;

	if (argc != 0) 
		filename = *argv;
	else 
		usage();
	argc--; argv++;
	if (argc == 1) 
		device = *argv;
	else if (argc > 1) 
		usage();

	if ((nw = open(device, O_RDWR)) < 0) {
		perror("nwstat: open");
		exit(1);
	}
	if (ioctl(nw, NWIORESET) != 0) {
		perror("nwstat: reset");
		exit(1);
	}
	lseek(nw, &(((struct nwdevice *)0)->nw_ctl_stat), L_SET);
	if (write(nw, &ctl_stat, sizeof(ctl_stat)) != sizeof(ctl_stat)) {
		perror("nwstat: write");
		exit(1);
	}
	if (ioctl(nw, NWIOUNRESET) != 0) {
		perror("nwstat: unreset");
		exit(1);
	}
	for(i=0;((i<10) && (ctl_stat != CTL_STAT_READY));++i) {
		sleep(1);
		lseek(nw, &(((struct nwdevice *)0)->nw_ctl_stat), L_SET);
		if (read(nw, &ctl_stat, sizeof(ctl_stat)) != sizeof(ctl_stat)) {
			perror("nwstat: read");
			exit(1);
		}
	}
	if (ctl_stat != CTL_STAT_READY) {
		printf("nwstat: Card did not go ready.\n\r");
		exit(1);
	}
	if ((fw = fopen(filename, "r")) == NULL) {
		perror("nwstat: open");
		exit(1);
	}
        fread((char *) &exec, sizeof(exec), 1, fw);

        /* Do sanity checking on file */
        switch (exec.a_magic & 0xffff) {
            case 0407:
                break;

            default:
                fclose(fw);
                printf("nwstat: Bad magic number in %s.\n\r",filename);
                exit(1);
        }

        /* Allocate enough memory for text and initialized data */
        total = exec.a_text + exec.a_data;
        if ((p = malloc(total)) == NULL) {
                fclose(fw);
                printf("nwstat: Couldn't malloc %d bytes.", total);
                exit(1);
        }

        /* Read in text and initialized data */
        fread(p, total, 1, fw);
        fclose(fw);     /* Do not need file anymore */

        /* Write text and initialized data out to the device */
	lseek(nw, exec.a_entry - 0xe00000, L_SET);
	if (write(nw, p, total) != total) {
		perror("nwstat: write");
		exit(1);
	}

        /* Write entry address */
	lseek(nw, &(((struct nwdevice *)0)->nw_fw_address), L_SET);
	if (write(nw, &(exec.a_entry), 4) != 4) {
		perror("nwstat: write");
		exit(1);
	}

	if (ioctl(nw, NWIOGO) != 0) {
		perror("nwstat: nwgo");
		exit(1);
	}

        free(p);
        close(nw);     /* Do not need device anymore */
}

nwreset(argc, argv)
	int argc;
	char *argv[];
{
	if (argc == 1) 
		device = *argv;
	else if (argc > 1) 
		usage();
	if ((nw = open(device, O_RDWR)) < 0) {
		perror("nwstat: open");
		exit(1);
	}
	if (ioctl(nw, NWIORESET) != 0) {
		perror("nwstat: reset");
		exit(1);
	}
	if (ioctl(nw, NWIOUNRESET) != 0) {
		perror("nwstat: unreset");
		exit(1);
	}
        close(nw);
}

nwgo(argc, argv)
	int argc;
	char *argv[];
{
	register int i;
	u_short ctl_stat = 0xffff;

	if (argc == 1) 
		device = *argv;
	else if (argc > 1) 
		usage();
	if ((nw = open(device, O_RDWR)) < 0) {
		perror("nwstat: open");
		exit(1);
	}
	if (ioctl(nw, NWIORESET) != 0) {
		perror("nwstat: reset");
		exit(1);
	}
	lseek(nw, &(((struct nwdevice *)0)->nw_ctl_stat), L_SET);
	if (write(nw, &ctl_stat, sizeof(ctl_stat)) != sizeof(ctl_stat)) {
		perror("nwstat: write");
		exit(1);
	}
	if (ioctl(nw, NWIOUNRESET) != 0) {
		perror("nwstat: unreset");
		exit(1);
	}
	for(i=0; ((i<20) && (ctl_stat != CTL_STAT_READY)); i++) {
		sleep(1);
		lseek(nw, &(((struct nwdevice *)0)->nw_ctl_stat), L_SET);
		if (read(nw, &ctl_stat, sizeof(ctl_stat)) != sizeof(ctl_stat)) {
			perror("nwstat: read");
			exit(1);
		}
	}
	if (ctl_stat != CTL_STAT_READY) {
		printf("nwstat: Card did not go ready.\n\r");
		exit(1);
	}
	if (ioctl(nw, NWIOGO) != 0) {
		perror("nwstat: go");
		exit(1);
	}
        close(nw);
}

nwdump(argc, argv) 
	int argc;
	char *argv[];
{
	register int i, f;
	char buf[512];

	if (argc != 0) {
		filename = *argv;
		if ((f = open(filename, O_WRONLY|O_CREAT|O_TRUNC, 0664)) < 0) {
			perror("nwdump: openfile");
			exit(1);
		}
		argc--; argv++;
	} else 
		f = 1;
	if (argc == 1) 
		device = *argv;
	else if (argc > 1) 
		usage();
	if ((nw = open(device, O_RDONLY)) < 0) {
		perror("nwdump: opendevice");
		exit(1);
	}

	lseek(nw, 0, L_SET);
	while (read(nw, buf, sizeof(buf)) == sizeof(buf))
		if (write(f,buf,sizeof(buf)) != sizeof(buf)) {
			perror("nwdump: write error");
			exit(1);
		}
        close(nw);
        close(f);
}

nwdebug(argc, argv) 
	int argc;
	char *argv[];
{
	struct sgttyb	t;
	if (argc == 1) 
		device = *argv;
	else if (argc > 1) 
		usage();
	if ((nw = open(device, O_RDWR)) < 0) {
		perror("nwdebug: open");
		exit(1);
	}
	if (!isatty(0)) {
		perror("nwdebug: standard input must be a tty");
		exit(1);
	}

	gtty(0,&t);
	t.sg_flags |= CBREAK;
	stty(0,&t);

	while (1) {
		char tohost, fromhost;
#ifdef	4_2
		int	ready;
#else	4_2
		fd_set	ready;
#endif	4_2
		int found;
		struct timeval tout;

		if (tohost = nwgetchar())	/**/
			printf("%c",tohost);	/**/

		tout.tv_sec = 0;
		tout.tv_usec = 1000;
#ifdef	4_2
		ready = 1;
		found = select(1, &ready, (int *)0, (int *)0, &tout);
#else	4_2
		FD_ZERO(&ready);
		FD_SET(0, &ready);
		found = select(1, &ready, (fd_set *)0, (fd_set *)0, &tout);
#endif	4_2
		if (found < 0) {
			perror("nwdebug: select");
			exit(1);
		} else if (found > 0) {
			if (read(0, &fromhost, sizeof(fromhost)) != 
				sizeof(fromhost)) {
				perror("nwdebug: read stdin");
				exit(1);
			}
			nwputchar(fromhost); /* */
		}
	}
}

nwgetchar()
{
	char x, cnull = 0;

	lseek(nw, &(((struct nwdevice *)0)->nw_c_tohost), L_SET);
	if (read(nw, &x, sizeof(x)) != sizeof(x)) {
		perror("nwgetchar: read");
		exit(1);
	}
	if (x) {
		lseek(nw, &(((struct nwdevice *)0)->nw_c_tohost), L_SET);
		if (write(nw, &cnull, sizeof(cnull)) != sizeof(cnull)) {
			perror("nwgetchar: write");
			exit(1);
		}
	}
	return (x);
}

nwputchar(x)
	char x;
{
	char c;

	lseek(nw, &(((struct nwdevice *)0)->nw_c_fromhost), L_SET);
	for (c = 0; c != 0; ){
		if (read(nw, &c, sizeof(c)) != sizeof(c)) {
			perror("nwputchar: read");
			exit(1);
		}
	}
	lseek(nw, &(((struct nwdevice *)0)->nw_c_fromhost), L_SET);
	if (write(nw, &x, sizeof(x)) != sizeof(x)) {
		perror("nwputchar: write");
		exit(1);
	}
}
