#!	/bin/sh
#
# $Header: mkdual,v 1.1 89/04/07 09:22:51 mark Exp $
#
#!	/bin/sh
#
#	This script sets up the dual universe enviroment.
#	for the directory tree rooted at .  It assumes that
#	It assumes that / is a vanilla BSD directory, i.e. there
#	exists bin, etc, lib, usr/lib, usr/include, and
#	usr/bin.  It also assumes that directory tree
#	$SYSVROOT is a SYSTEM V structure.
#
#	The following MACROs should be changed to reflect 
#	the SYSV sources.
#
	if test $# -ne 1
	then echo "Usage: :mkdual sysv-root"
	     exit 255
	fi
	SYSVROOT=$1
	SYSVBIN=$SYSVROOT/bin			# SYSV /bin
	SYSVETC=$SYSVROOT/etc			# SYSV /etc
	SYSVLIB=$SYSVROOT/lib			# SYSV /lib
	SYSVSHLIB=$SYSVROOT/shlib		# SYSV /shlib
	SYSVUBIN=$SYSVROOT/usr/bin		# SYSV /usr/bin
	SYSVUINC=$SYSVROOT/usr/include		# SYSV /usr/include
	SYSVULIB=$SYSVROOT/usr/lib		# SYSV /usr/lib
	SYSVNET=$SYSVROOT/usr/net		# SYSV /usr/net
	SYSVNSERVE=$SYSVROOT/usr/nserve		# SYSV /usr/nserve
	SYSVCRON=$SYSVROOT/usr/spool/cron	# SYSV /usr/spool/cron
#
# Remove existing SYSV links.
#
	/.bin.BSD/rm -f /.bin.SYSV /.etc.SYSV /.lib.SYSV /shlib /usr/.bin.SYSV \
		/usr/.lib.SYSV /usr/.include.SYSV /usr/net /usr/nserve \
		/usr/mail /usr/spool/cron
	
#
# Set up /bin
#
	if test ! -f /.bin.\$UNIVERSE
	then /.bin.BSD/mv /bin /.bin.BSD
		/.bin.BSD/ln -s /.bin.\$UNIVERSE /bin
	fi
	/.bin.BSD/ln -s $SYSVBIN /.bin.SYSV
#
# Set up /etc
#
	if test ! -f /.etc.\$UNIVERSE
	then /.bin.BSD/mv /etc /.etc.BSD
		/.bin.BSD/ln -s /.etc.\$UNIVERSE /etc
	fi
	/.bin.BSD/ln -s $SYSVETC /.etc.SYSV
#
# Set up /lib
#
	if test ! -f /.lib.\$UNIVERSE
	then /.bin.BSD/mv /lib /.lib.BSD
		/.bin.BSD/ln -s /.lib.\$UNIVERSE /lib
	fi
	/.bin.BSD/ln -s $SYSVLIB /.lib.SYSV
#
# Set up /shlib
#
	/.bin.BSD/ln -s $SYSVSHLIB /shlib
#
# Set up /usr/net
#
	/.bin.BSD/ln -s $SYSVNET /usr/net
#
# Set up /usr/nserve
#
	/.bin.BSD/ln -s $SYSVNSERVE /usr/nserve
#
# Set up /usr/bin
#
	if test ! -f /usr/.bin.\$UNIVERSE
	then /.bin.BSD/mv /usr/bin /usr/.bin.BSD
		/.bin.BSD/ln -s /usr/.bin.\$UNIVERSE /usr/bin
	fi
	/.bin.BSD/ln -s $SYSVUBIN /usr/.bin.SYSV
#
# Set up /usr/src
#
#	if test ! -f /usr/.src.\$UNIVERSE
#	then /.bin.BSD/mv /usr/src /usr/.src.BSD
#		/.bin.BSD/ln -s /usr/.src.\$UNIVERSE /usr/src
#	fi
#	/.bin.BSD/ln -s $SYSVUBIN /usr/.src.SYSV
#
# Set up /usr/include
#
	if test ! -f /usr/.include.\$UNIVERSE
	then /.bin.BSD/mv /usr/include /usr/.include.BSD
		/.bin.BSD/ln -s /usr/.include.\$UNIVERSE /usr/include
	fi
	/.bin.BSD/ln -s $SYSVUINC /usr/.include.SYSV
#
# Set up /usr/lib
#
	if test ! -f /usr/.lib.\$UNIVERSE
	then /.bin.BSD/mv /usr/lib /usr/.lib.BSD
		/.bin.BSD/ln -s /usr/.lib.\$UNIVERSE /usr/lib
	fi
	/.bin.BSD/ln -s $SYSVULIB /usr/.lib.SYSV

#
# set up /usr/mail
#
	/.bin.BSD/ln -s /usr/spool/mail /usr
	if test ! -d /usr/spool/mail/:saved ; then
		mkdir /usr/spool/mail/:saved
		chmod 775 /usr/spool/mail/:saved
		chgrp mailer /usr/spool/mail/:saved
	fi

#
# set up /usr/spool/cron
#
	/.bin.BSD/ln -s $SYSVCRON /usr/spool/cron

#
# Set up /etc/{group,mtab,passwd,utmp}
#
	(cd $SYSVETC; rm -f group mtab passwd utmp)
	/.bin.BSD/ln -s /.etc.BSD/group $SYSVETC
	/.bin.BSD/ln -s /.etc.BSD/mtab $SYSVETC/mtab
	/.bin.BSD/ln -s /.etc.BSD/passwd $SYSVETC
	/.bin.BSD/ln -s /.etc.BSD/utmp $SYSVETC
