#define BLKSZ	512
#define GETFIELD(s, v, min, max)	v = getfield(s, v, base, min, max, menu)
#define GETBITS(s, bit, v)		v = getbits(s, bit, v)

#include	<sys/types.h>
#ifdef STANDALONE
#include	"saio.h"
#include	"sais68k.h"
#include	"../is68kdev/scsi.h"
#include	"../is68kdev/gsreg.h"
#else  STANDALONE
#define ASCII_SNS_7_KEY
#include	<stdio.h>
#include	<sys/file.h>
#include	<sys/ioctl.h>
#include	<sys/ggio.h>
#include	<ctype.h>
#endif STANDALONE
#include	<setjmp.h>

u_char	gdb_cont, gdb_target, gdb_lun;
int	scsi_unit;
u_char	gotit, badwritten, aborted, verbose;
u_char	maxretries, retries, ops, base;
u_int	badsize, capac, newbad, lapbad, lastfnd;
static jmp_buf menu;
struct hacb_dcb	*dcb;
#define MAXBAD	1000
struct	badentry	{
		u_int	blockno;
		u_char	sensekey;
		u_char	errcode;
		u_char	retries;
		u_char	timesfound;
}	badtable[MAXBAD], *nextbad;

#ifdef STANDALONE
#define pa(x)	paddr(x)
#define CMD_ISSUE(a, b, c, d)	gdissue(a, b, c, !d)
#define MAXPERACC 80
char testbuf[MAXPERACC*BLKSZ], cmpbuf[MAXPERACC*BLKSZ], savbuf[MAXPERACC*BLKSZ];
#define DOALLOC(a, b, c)
#define FFLUSH(a)
extern	int	xbad144_soft, xbad144_hadsoft, gd_formatting;
extern	struct	scsi_sns	gd_sns;
#else STANDALONE
#define pa(x)	(x)
#define CMD_ISSUE(a, b, c, d)	cmd_issue(a, b, c, d)
#define getlocal()	(0)
#define MAXPERACC 0xFF
char	*testbuf, *cmpbuf, *savbuf, *doalloc();
#define DOALLOC(a, b, c)	a = doalloc(a,b,c)
#define FFLUSH(a)		fflush(a)
int	xbad144_soft, xbad144_hadsoft, gd_formatting;
struct	scsi_sns	gd_sns;
struct	hacb_dcb	real_dcb;
char			rawdev[16];
#endif STANDALONE

int	getdisk(), docheck(), readbad(), editbad(), reassign(), 
	do_format(), cmd_exit();
struct commands {
	char 	*cmd_name;
	int	(*cmd_exec)();
	int	cmd_param;
#define	OP_SAVE		1
#define	OP_WRITE	2
#define	OP_COMP		4
} cmd[] = {
	"Choose disk drive unit",	getdisk,	0,
	"Save/Write/Read/Compare/Restore",docheck,OP_SAVE|OP_WRITE|OP_COMP,
	"Save/Write/Read/Restore",	docheck, 	OP_SAVE|OP_WRITE,
	"Write/Read/Compare",		docheck, 	OP_WRITE|OP_COMP,
	"Write/Read",			docheck, 	OP_WRITE,
	"Read",				docheck,	0,
	"Read current bad blocks list",	readbad,	0,
	"Edit bad block table",		editbad,	0,
	"Reassign bad blocks",		reassign,	0,
	"Format disk",			do_format,	0,
	"Exit",				cmd_exit,	0,
	0,0,0
};

main()
{
	u_char	i = 1;

	gd_formatting = 0;
	setjmp(menu);
	printf("\nSCSI disk bad block utility\n");
	printf("You can work in Decimal or Hexadecimal\n");
	if (GETBITS("Is Decimal OK?", 1, i)) {
		base = 10;
		printf("Using Decimal input/output\n");
	} else {
		base = 0x10;
		printf("Using Hexadecimal input/output\n");
	}
	verbose = 0;
	GETBITS("Use verbose mode?", 1, verbose);
	(*(cmd[0].cmd_exec))();
	setjmp(menu);
	while (1) {
		for (i=0; cmd[i].cmd_name; i++)
			printf("    %d: %-35s\n", i, cmd[i].cmd_name);
		i--;
		GETFIELD("Select a function:", i, 0, i);
		ops = cmd[i].cmd_param;
		(*(cmd[i].cmd_exec))();
	}
			
}

getdisk()
{
	while (1) {
		GETFIELD("Controller", gdb_cont, 0, 3);
		GETFIELD("Target Device", gdb_target, 0, 3);
		GETFIELD("Lun", gdb_lun, 0, 1);
		if (initdisk())
			continue;
		break;
	}
	badsize = MAXBAD;
	GETFIELD("Maximum acceptable number of bad blocks", badsize, 1, MAXBAD);
	nextbad = badtable;
}
		

docheck()
{
        u_int	count, lba, nblocks, laps, loblock, hiblock, lapcnt;

	nblocks = MAXPERACC;
	laps = 0;
	loblock = 0;
	hiblock = capac;
	maxretries = 1;
	xbad144_soft = 1;
	GETFIELD("Starting blockno", loblock, 0, capac);
	GETFIELD("  Ending blockno", hiblock, loblock, capac);
	GETFIELD("Number of laps (0 means forever)", laps, 0, 999);
	lapcnt = 0;
	GETFIELD("Number of blocks per access", nblocks, 1, MAXPERACC);
	DOALLOC(cmpbuf,nblocks,BLKSZ);
	if (ops & OP_WRITE)
		DOALLOC(testbuf,nblocks,BLKSZ);
	if (ops & OP_SAVE)
		DOALLOC(savbuf,nblocks,BLKSZ);
	if (GETBITS("Map soft errors", 1, xbad144_soft))
	    GETFIELD("Maximum number of tries per access", maxretries, 1, 9);
	else
	    maxretries = 1;

	do {
	    newbad = 0;
	    lapbad = 0;
	    printf("begin lap %d\n", ++lapcnt);
	    if (ops & OP_WRITE) {
		setbuf(nblocks);
		printf("pattern: %2x%2x%2x\n",
			testbuf[0]&0xFF, testbuf[1]&0xFF, testbuf[2]&0xFF );
	    }
	    aborted = 0;
            for (lba = loblock; lba <= hiblock; ) {
                if (getlocal())
                        aborted = 1;
                if (aborted)
                        break;
                count = lba + nblocks > hiblock ? hiblock - lba + 1 : nblocks;
                if (((lba-loblock) % (count*100)) == 0) {
			printf("\rblk %d     ",lba);

			FFLUSH(stdout);
		}
		checkchunk(lba, count, 0);
                lba += count;
            }
	    printf("\nlap done: %d bad this lap; %d new; %d total this disk\n",
		lapbad, newbad, nextbad - badtable);
	    if (aborted)
		break;
	    --laps;
	} while (laps > 0);
	return(0);
}



checkchunk(lba,count,offset)
	int lba;
	int count;
	int offset;
{
	if ((ops & OP_SAVE) && dio(CMD_XREAD,lba,count,savbuf+offset*BLKSZ))
		return(byhalves(lba,count,offset));
	if ((ops & OP_WRITE) && dio(CMD_XWRITE,lba,count,testbuf+offset*BLKSZ))
		return(byhalves(lba,count,offset));
	if (dio(CMD_XREAD,lba,count,cmpbuf+offset*BLKSZ))
		return(byhalves(lba,count,offset));
	if ((ops & OP_COMP) && verify(lba,count,offset,testbuf,cmpbuf))
		return(0);
	if ((ops & OP_SAVE) && dio(CMD_XWRITE,lba,count,savbuf+offset*BLKSZ))
		return(byhalves(lba,count,offset));
	return(0);
}

byhalves(lba, count, offset)
	int lba;
	int count;
	int offset;
{
	int locnt;

	if (gotit) {
		locnt = lastfnd + 1;
		checkchunk(locnt, count + lba - locnt, offset + locnt - lba);
		gotit = 0;
	} else {
		if (count == 1)
			return(addbad(lba,0));
		locnt = count/2;
		checkchunk(lba, locnt, offset);
		checkchunk(lba + locnt, count - locnt,locnt + offset );
	}
	return(0);
}

#define VALID_INFO	1
#define MANUAL		2
addbad(block,how)
	int	block;
	int	how;
{
	register struct badentry *bp = nextbad;

	if (verbose)
		printf("\nfoundbad! (bn%d)\n",block);
	lapbad++;
	while (--bp >= badtable)
		if (bp->blockno == block)
			return(bp->timesfound++);
	if (verbose)
		printf("adding to table\n");
	if ((nextbad - badtable) > badsize) {
		printf("\nToo many bad blocks\n");
		aborted = 1;
		return(-1);
	}
	nextbad->blockno = lastfnd = block;
	if (how == VALID_INFO)
		gotit = 1;
	if (how == MANUAL)
		nextbad->sensekey |= 0x80;
	else {
		nextbad->sensekey = gd_sns.sns_7.sns_7_key;
		nextbad->errcode = gd_sns.sns_7.sns_7_err;
		nextbad->retries = retries;
	}
	nextbad++;
	newbad++;
	return(0);
}

readbad()
{
	char 				dp[8*MAXBAD+4];
	char				desc_size = 4;
	int				*bp, cnt;
	int				param = 0x1D000000;

	GETBITS("Read Manufacturer's List?",   0x10000000, param);
	GETBITS("Read Grown Defect List?",     0x08000000, param);
	GETBITS("Use Physical Sector Format?", 0x05000000, param);
	if ((param&0x05000000) == 0x05000000)
		desc_size = 8;
        SET_CDB_1(&dcb->dcb_cdb, CMD_RDDEFECT, gdb_lun, 0, param,
		desc_size*MAXBAD+4, 0, 0);
        SET_DCB(dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_DISC,
		sizeof (struct cdb_1), DCB_BW_16, DCB_AM_STD_S_D, 0,
			pa(dp), desc_size*MAXBAD+4, 1);
        if (CMD_ISSUE("READ DEFECT", dcb, scsi_unit, verbose)) {
		printf("FAILED\n");
		return(0);
	}
	if ((cnt = (*(u_short *)(dp+2))/desc_size) > MAXBAD)
	    printf("Warning: %d defects mapped out; only showing first %d\n",
			cnt, MAXBAD);
	if (cnt == 0)
	    printf("No bad blocks in list\n");
	bp = (int *)dp;
	while (cnt--) {
	    bp++;
	    if (desc_size == 4) {
		printf("bn %6d (0x%05x)|", *bp, *bp);
	    } else {
		printf("cylinder %4d (0x%03x), head %2d (0x%01x), ",
			(*bp)>>8, (*bp)>>8, (*bp)&0xF, (*bp)&0xF);
		bp++;
		printf("sector %2d (0x%02x)\n", *bp, *bp);
	    }
	}
	GETBITS("\nContinue?", 1, cnt);
	return(0);
}

editbad()
{
	struct badentry	*dp, *bp = badtable;
	int	block = 0, i = 0;

	GETBITS("Do you wish to manually add bad blocks", 1, i);
	while (i) {
		GETFIELD("BlockNo to Add", block, 0, capac);
		if (addbad(block, MANUAL))
		    printf("Block already in list\n");
		GETBITS("more?", 1, i);
	}
	if (nextbad == badtable)
	    printf("No bad blocks in list\n");
	while (bp < nextbad) {
	    printf("    Entry      BlockNo    TimesFound ");
	    printf("SenseKey   ErrCode    Retries\n");
	    for (block=0; block<20; block++) {
		if (base == 10)
		    printf("    %11d%11d%11d%11d%11d%11d\n",
		    	bp - badtable, bp->blockno, bp->timesfound,
		    	bp->sensekey, bp->errcode, bp->retries);
		if (base == 0x10)
		    printf("    %11x%11x%11x%11x%11x%11x\n",
		    	bp - badtable, bp->blockno, bp->timesfound,
		    	bp->sensekey, bp->errcode, bp->retries);
		if (++bp >= nextbad)
		    break;
	    }
	    if (GETBITS("Do you wish to delete any of these blocks", 1, i)) {
		GETFIELD("Entry to Delete", block, 0, bp - badtable - 1);
		for (dp = badtable+block; dp < nextbad; dp++)
		    *dp = *(dp+1);
		nextbad--;
		bp = badtable + block;
	    }
	}
}

do_format()
{
	int				i = 0;
	int				param = 0x180000;
	int				data = 0x00800000;

	GETBITS("Purge Grown Defect List?",   0x80000, param);

        SET_CDB_0(&dcb->dcb_cdb, CMD_FORMAT, gdb_lun, param, 0, 0, 0);
        SET_DCB(dcb, DCB_NOIE, DCB_DIR_OUT, DCB_SW, DCB_DISC,
            sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0, pa(&data),4,1);
        printf("^GWARNING: this command destroys disk contents\n");
	if (GETBITS("Do you want to proceed", 1, i)) {
		printf("formatting...");
		gd_formatting = 1;
                if (CMD_ISSUE("FORMAT", dcb, scsi_unit, verbose))
			printf("FAILED\n");
		else
			printf("succeeded\n");
		gd_formatting = 0;
	}
}

reassign()
{
	struct badentry 		*bp = nextbad;
	int				docopy = 0, didcopy, i = 0;
	int				fmtlist[2];
	char				copybuf[BLKSZ];

	GETBITS("Copy each reassigned sector", 1, docopy);
	while (--bp >= badtable) {
		if (docopy) {
            		SET_CDB_1(&dcb->dcb_cdb, CMD_XREAD, gdb_lun, 0,
				bp->blockno, 1, 0, 0);
            		SET_DCB(dcb, DCB_NOIE, DCB_DIR_IN, DCB_NOSW, DCB_DISC,
				sizeof (struct cdb_1), DCB_BW_16,
                		DCB_AM_STD_S_D, 0, pa(copybuf), BLKSZ, BLKSZ);
                	if (CMD_ISSUE("XREAD", dcb, scsi_unit, verbose))
				printf("can't read block 0x%x\n", bp->blockno);
			else
				didcopy = 1;
		}
        	fmtlist[0] = 4;
                fmtlist[1] = bp->blockno;
        	SET_CDB_0(&dcb->dcb_cdb, CMD_REASSIGN, gdb_lun, 0, 0, 0, 0);
        	SET_DCB(dcb, DCB_NOIE, DCB_DIR_OUT, DCB_SW, DCB_DISC,
            		sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0,
			pa(fmtlist), 8, 1);
		if (verbose)
			printf("Reassigning block %d(0x%x)\n",
				bp->blockno, bp->blockno);
                if (CMD_ISSUE("REASSIGN", dcb, scsi_unit, verbose))
			printf("REASSIGNMENT OF BN 0x%x FAILED\n", bp->blockno);
		else if (didcopy) {
			didcopy = 0;
            		SET_CDB_1(&dcb->dcb_cdb, CMD_XWRITE, gdb_lun, 0,
				bp->blockno, 1, 0, 0);
            		SET_DCB(dcb, DCB_NOIE, DCB_DIR_OUT, DCB_NOSW, DCB_DISC,
				sizeof (struct cdb_1), DCB_BW_16,
                		DCB_AM_STD_S_D, 0, pa(copybuf), BLKSZ, BLKSZ);
                	if (CMD_ISSUE("XWRITE", dcb, scsi_unit, verbose))
				printf("can't write block 0x%x\n", bp->blockno);
		}
	}
	nextbad = badtable;
}

cmd_exit()
{
	int	i = 1;

	if (nextbad != badtable) {
	    printf("WARNING: there are bad blocks found but not reassigned\n");
	    if (GETBITS("Reassign them before exiting", 1, i))
		reassign();
	}
	exit(0);
}

initdisk()
{
	struct scsi_rcap	rcap;

	if (opendisk())
		return(-1);
        SET_CDB_1(&dcb->dcb_cdb, CMD_RCAPAC, gdb_lun, 0, 0, 0, 0, 0);
        SET_DCB(dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_DISC,
            sizeof (struct cdb_1), DCB_BW_16, DCB_AM_STD_S_D, 0,
            pa(&rcap), sizeof(rcap), 1);
        if (CMD_ISSUE("RCAPAC", dcb, scsi_unit, verbose))
                return (-1);
        capac = rcap.rcap_lba;
	return(0);
}

dio(func, lba, count, buf)
	int	func;
	int	lba;
	int	count;
	char	*buf;
{
	if (verbose) {
	    printf("lba %6d, cnt %3d, ", lba, count);	/* 21 char */
	    if ((buf == savbuf) && (func == CMD_XREAD))
		printf("saving   ");			/* 9 char */
	    if ((buf == testbuf) && (func == CMD_XWRITE))
		printf("writing  ");			/* 9 char */
	    if ((buf == cmpbuf) && (func == CMD_XREAD))
		printf("reading  ");			/* 9 char */
	    if ((buf == savbuf) && (func == CMD_XWRITE))
		printf("restoring");			/* 9 char */
printf("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b");
	    FFLUSH(stdout);
	}
        while (1) {
            SET_CDB_1(&dcb->dcb_cdb, func,  gdb_lun, 0, lba, count, 0, 0);
            SET_DCB(dcb, DCB_NOIE, (func==CMD_XREAD) ? DCB_DIR_IN : DCB_DIR_OUT,
                DCB_NOSW, DCB_DISC, sizeof (struct cdb_1), DCB_BW_16,
                DCB_AM_STD_S_D, 0, pa(buf), count*BLKSZ, BLKSZ);
	    gd_sns.sns_7.sns_7_class = 0;
            if (CMD_ISSUE((func==CMD_XREAD) ? "XREAD" : "XWRITE",
	      dcb, scsi_unit, verbose)) {
	    	if (gd_sns.sns_7.sns_7_class == 0) {
		    printf("Unrecoverable Controller Error\n");
	    	    aborted = 1;
		}
		if ((++retries == maxretries)|| xbad144_soft) {
	    	    if (gd_sns.sns_7.sns_7_valid)
			addbad(SCSI_HMML(gd_sns.sns_7.sns_7_info),VALID_INFO);
		    return(-1);
		}
	    } else {	
		if (xbad144_hadsoft) {
		    	xbad144_hadsoft = 0;
	    	    if (gd_sns.sns_7.sns_7_valid)
			addbad(SCSI_HMML(gd_sns.sns_7.sns_7_info),VALID_INFO);
		    return(-1);
		}
		return (0);                     /* ok */
            }
        }
}

#define	NPAT 13
static char patterns[NPAT][3] =
	{
		{0xdb, 0x6d, 0xb6},
		{0x6d, 0xb6, 0xdb},
		{0xb6, 0xdb, 0x6d},
		{0x24, 0x92, 0x49},
		{0x92, 0x49, 0x24},
		{0x49, 0x24, 0x92},
		{0x55, 0x55, 0x55},
		{0xaa, 0xaa, 0xaa},
		{0,    0,    0	 },
		{0xff, 0xff, 0xff},
		{0xbe, 0xef, 0xbe},
		{0xfe, 0xed, 0xfe},
		{0x39, 0xce, 0x73},
	};

setbuf(nblocks)
	u_int	nblocks;
{
	register int i, j;
	static int counter = -1;

	counter++;
	for (j = 0 ; j < nblocks; j++)
	    for (i = 0; i < BLKSZ; i++)
		testbuf[(j*BLKSZ) + i] = patterns[counter % NPAT][i % 3];
}

verify(lba, count, offset, testbuf, cmpbuf)
	int	lba, count, offset;
	char	*testbuf, *cmpbuf;
{
	register u_int *t = (u_int *)(testbuf + offset*BLKSZ);
	register u_int *c = (u_int *)(cmpbuf + offset*BLKSZ);
	register int  n, cnt = count;

	if (verbose) {
	    printf("lba %6d, cnt %3d, ", lba, count);	/* 21 char */
	    printf("comparing");			/* 9 char */
printf("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b");

	}
	while (cnt-- > 0)
	    for (n = BLKSZ/sizeof(u_int); n>0; n--)
	    	if (*t++ != *c++) {
		    addbad((lba + count - cnt),0);
		    t += (n - 1);
		    c += (n - 1);
		}
}

#ifdef STANDALONE
opendisk()
{
	int			fi, i = 1;
	char			*disk = "gd(00,0)";

        dcb = gsgetdcb((gdb_cont<<3) | gdb_target);
	scsi_unit = (gdb_cont<<3)|(gdb_target<<1)|gdb_lun;
	disk[3] = '0' + scsi_unit/10;
	disk[4] = '0' + scsi_unit%10;
	printf("Opening CONT%d, TARG%d, LUN%d: %s\n",
		gdb_cont, gdb_target, gdb_lun, disk);
	if (!(GETBITS("Is this correct", 1, i)))
		return(-1);
	if (fi >= 0)
		close(fi);
	if ((fi = open(disk, 2)) < 0) {
		printf("cannot open\n");
		return(-1);
	}
	return(0);
}
#else STANDALONE
opendisk()
{
	int			i = 1;
	char			disk[16];

        dcb = &real_dcb;
	sprintf(disk,"/dev/rgd%dc", (gdb_cont<<3)|(gdb_target<<1)|gdb_lun);
	sprintf(rawdev,"/dev/rgg%d%d", gdb_cont, gdb_target);
	printf("Opening CONT%d, TARG%d, LUN%d: %s, %s\n",
		gdb_cont, gdb_target, gdb_lun, disk, rawdev);
	if (!(GETBITS("Is this correct", 1, i)))
		return(-1);
	if (scsi_unit > 0)
		close(scsi_unit);
	if ((scsi_unit = open(disk, O_RDWR, 0)) < 0) {
		perror(disk);
		return(-1);
	}
	close(scsi_unit);
	if ((scsi_unit = open(rawdev, O_RDWR, 0)) < 0) {
		perror(rawdev);
		return(-1);
	}
	return(0);
}

cmd_issue(command, dcb, scsi_unit, verbose)
	char		*command;
	struct hacb_dcb	*dcb;
	int		scsi_unit;
	int		verbose;
{
	struct hacb_dcb			dcbsav;
	int				count = 0;


	bcopy(dcb, &dcbsav, sizeof(struct hacb_dcb));
	while (1) {
	    switch (cmd_issue2(command, dcb, scsi_unit, verbose)) {
		case  0:	return (0);			/* ok */
		case  -1:	return (-1);			/* hard error */
		case  1:	if (++count == 3)		/* retry */
					return (-1);
	    }
	    bcopy(&dcbsav, dcb, sizeof(struct hacb_dcb));
	}
}

cmd_issue2(command, dcb, scsi_unit, verbose)
	char		*command;
	struct hacb_dcb	*dcb;
	int		scsi_unit;
	int		verbose;
{
	register int cc, nsense = 0;

#define	SHHHH(x)	{ if (verbose) x;}

	if (cc = ioctl(scsi_unit, GGIOCCMD, dcb)) {
		printf("%s: err=%d: ", rawdev, cc);
		perror("ioctl");
		return (-1);
	}
	if (dcb->dcb_err == 0)		/* return if no error */
		return (0);
	if ((dcb->dcb_scsi_status & SCSI_STATUS_CHECK) == 0) {
	    SHHHH(printf("%s: %s: fatal error: cerr %x: scsi %b\n",
		rawdev, command, dcb->dcb_cerr, dcb->dcb_scsi_status,
		SCSI_STATUS_BITS));
	    return (-1);
	}
sns:	SET_CDB_0(&dcb->dcb_cdb, CMD_SENSE, gdb_lun, 0, sizeof (gd_sns), 0, 0);
	SET_DCB(dcb, DCB_IE, DCB_DIR_IN, DCB_SW, DCB_DISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0, pa(&gd_sns),
	    sizeof (gd_sns), 1);
	if (cc = ioctl(scsi_unit, GGIOCCMD, dcb)) {
		printf("%s: SENSE: err=%d: ", rawdev, cc);
		perror("ioctl");
		return (-1);
	}
	if (dcb->dcb_err) {
	    dcb->dcb_err = 0;
	    if (nsense++ < 5)
		goto sns;
	    SHHHH(printf("%s: SENSE: fatal error\n", rawdev));
	    return (-1);
	}
	if (gd_sns.sns_7.sns_7_class != 7) {
	    SHHHH(printf("%s: invalid sense class %d\n", rawdev,
		gd_sns.sns_7.sns_7_class));
	    return (-1);
	}
	SHHHH(printf("%s: %s: %s: code %x", rawdev, command,
	    ascii_sns_7_key[gd_sns.sns_7.sns_7_key], gd_sns.sns_7.sns_7_err));
	if (gd_sns.sns_7.sns_7_valid)
	    SHHHH(printf(": bn %d (0x%x)", SCSI_HMML(gd_sns.sns_7.sns_7_info),
		SCSI_HMML(gd_sns.sns_7.sns_7_info)));
	switch (gd_sns.sns_7.sns_7_key) {
	    case SNS_7_KEY_RECOVERED:
		SHHHH(printf(": soft error\n"));
		if (xbad144_soft) {
		    xbad144_hadsoft = 1;
		    return (-1);
		}
		return (0);

	    case SNS_7_KEY_ABORT_CMD:
	    case SNS_7_KEY_UNIT_ATTN:
		SHHHH(printf(": reissued\n"));
		return (1);

	    default:
		SHHHH(printf(": hard error\n"));
		return (-1);
	}
}

getfield(field, value, base, min, max, err_jmp_buf)
	char	*field;
	u_int	value;
	jmp_buf err_jmp_buf;
{
	register int	i = 0, j = 0, x = value;
	char		backspace[9];
	int		newvalue;
	static char	buf[100];

	x = value;
	i = 0;
	do {
		backspace[i] = '\b';
		i++;
		x /= base;
	} while (x);
	backspace[i] = 0;
range:	if (min != max) {
	    if (base == 10)
		sprintf(buf,"%s (%d-%d)", field, min, max);
	    else
		sprintf(buf,"%s (0x%x-0x%x)", field, min, max);
	} else
		sprintf(buf,"%s", field, value, backspace);
	if (base == 10)
	    printf("    %+40s: %d%s", buf, value, backspace);
	else
	    printf("    %+40s: 0x%x%s", buf, value, backspace);
	buf[0] = 0;
	gets(buf);
	if (buf[0] && !isxdigit(buf[0]) && err_jmp_buf)
		longjmp(err_jmp_buf, 1);
	if (sscanf(buf, base == 10 ? "%d" : "%x", &newvalue) < 0)
		newvalue = value;
	if (min != max && ((newvalue < min) || (newvalue > max)))
		goto range;
	value = x = newvalue;
	j = 0;
	do {
		j++;
		x /= base;
	} while (x);
	if (j < i) {
	    if (base == 10)
		printf("    %+39s*: %d\n", " ", value);
	    else
		printf("    %+39s*: 0x%x\n", " ", value);
	}
	return value;
}

getbits(field, bit, value)
	char		*field;
{
	static char	buf[100];

	printf("    %+40s: ",field);
	if (value & bit)
		printf("Y\b");
	else
		printf("N\b");
	buf[0] = 0;
	gets(buf);
	if (value & bit) {
		if (buf[0] == 'n' || buf[0] == 'N')
			value &= ~bit;
	} else {
		if (buf[0] == 'y' || buf[0] == 'Y')
			value |= bit;
	}
	return value;
}

char *
doalloc(ptr, cnt, size)
	char *ptr;
	int cnt, size;
{
	if (ptr)
		free(ptr);
	if ((ptr = (char *)calloc(cnt, size)) < 0) {
		printf("calloc error\n");
		exit(1);
	}
	return(ptr);
}

#endif STANDALONE
