static char *RCSid = "$Header: fpinit.c,v 1.2 87/09/11 12:19:53 root Exp $";

/*
 * $Log:	fpinit.c,v $
 * Revision 1.2  87/09/11  12:19:53  root
 * Fix for new style Sky interface support.
 * 
 * Revision 1.1  86/03/03  10:05:24  root
 * Initial revision
 * 
 */

# include <stdio.h>
/*
**	Make this thing with the -f option
**	(and don't put any floats or doubles in the source)
*/
main()
{
	unsigned short *skycmd, *skyctl;
	unsigned long *skydat;
	unsigned short *skymc1, *skymc2;

	unsigned long uaddr, ucode, rucode, rdat;
	register int i, j;
	extern unsigned short *skyaddr;

	skycmd = skyaddr;
	skyctl = skyaddr+1;
	skydat = (unsigned long *)(skyaddr+2);
	skymc1 = skyaddr+4;
	skymc2 = skyaddr+5;

	if (skyaddr == 0) {
		printf("No sky board in system\n");
		exit(1);
	}
/*
**	First load microcode
*/
	*skyctl = 0;	/* Halt the Sky board */
	while (scanf("%x %x", &uaddr, &ucode) != EOF) {
		*skycmd = (unsigned short)uaddr;
		*skymc1 = (unsigned short)ucode;
		*skymc2 = (unsigned short)(ucode >> 16);
# ifdef DEBUG
		printf("%x %x\n", uaddr, ucode);
# endif DEBUG
		if ((rucode = ((*skymc2 << 16) | *skymc1)) != ucode) {
			printf("Sky microcode initialization error:");
			printf(" wrote %x, read %x\n", ucode, rucode);
			exit(1);
		}
	}
	printf("Microcode loaded\n");
/*
**	Next, initialize the board
*/
	*skyctl = 0x80;
	*skycmd = 0x1000;
	*skycmd = 0x1000;
	*skycmd = 0x1001;
	*skyctl = 0x40;
	printf("Sky board initialized\n");
/*
**	Now, run some diagnostics
*/
	*skycmd = 0x1041;
	for (j = 0; j < 8; j++) {
		*skydat = 0x3f800000;
		for (i = 0; i < 10000; i++)
			if (*skyctl < 0)
				break;
			else if (i >= 10000) {
				printf("Sky board diagnostic failure\n");
				exit(1);
			}
	}
# ifdef DEBUG
	printf("Context restore done\n");
# endif DEBUG
	*skycmd = 0x1040;
	for (j = 0; j < 8; j++)
		if ((rdat = *skydat) != 0x3f800000) {
			printf("Sky board diagnostic failure\n");
			exit(1);
		}
# ifdef DEBUG
	printf("Context save done\n");
# endif DEBUG
	*skycmd = 0x102D;	
	*skydat = 0x3f800000;
	for (i = 0; i < 10000; i++)
		if (*skyctl == 0xBF4C)
			break;
		else if (i >= 10000) {
			printf("Sky board diagnostic failure\n");
			exit(1);
		}
	if ((rdat = *skydat) != 0) {
		printf("Sky board diagnostic failure\n");
			exit(1);
	}
	printf("Sky board diagnostic tests completed\n");
}
