/* @(#)df.c	1.4 86/12/04 NFSSRC */
#ifndef lint
static	char *sccsid = "@(#)df.c	4.17 6/19/83";
#endif

#include <sys/param.h>
#include <ufs/fs.h>
#include <sys/stat.h>
#include <sys/vfs.h>

#include <stdio.h>
#include <mntent.h>

/*
 * df
 */
char	*mpath();

int	iflag;

struct mntent *getmntpt(), *mntdup();

union {
	struct fs iu_fs;
	char dummy[SBSIZE];
} sb;
#define sblock sb.iu_fs

daddr_t	alloc();
char	*strcpy();

main(argc, argv)
	int argc;
	char **argv;
{
	int i;
        struct stat statb;
        char tmpname[1024];

	while (argc > 1 && argv[1][0]=='-') {
		switch (argv[1][1]) {

		case 'i':
			iflag++;
			break;

		default:
			fprintf(stderr, "usage: df [ -i ] [ filsys... ]\n");
			exit(0);
		}
		argc--, argv++;
	}
	sync();
	printf("Filesystem            kbytes    used   avail capacity");
	if (iflag)
		printf(" iused   ifree  %%iused");
	printf("  Mounted on\n");
	if (argc <= 1) {
		register FILE *mtabp;
		register struct mntent *mnt;
 
		if ((mtabp = setmntent(MOUNTED, "r")) == NULL)
			exit(1);
		while ((mnt = getmntent(mtabp)) != NULL) {
			if (strcmp(mnt->mnt_type, MNTTYPE_IGNORE) == 0 ||
			    strcmp(mnt->mnt_type, MNTTYPE_SWAP) == 0)
				continue;
			if (strcmp(mnt->mnt_type, MNTTYPE_42) == 0 &&
			    (stat(mnt->mnt_fsname, &statb) >= 0) &&
			   (((statb.st_mode & S_IFMT) == S_IFBLK) ||
			    ((statb.st_mode & S_IFMT) == S_IFCHR))) {
				(void) strcpy(tmpname, mnt->mnt_fsname);
				dfreedev(tmpname);
			} else {
				dfreemnt(mnt->mnt_dir, mnt);
			}
		}
		(void) endmntent(mtabp);
		exit(0);
	}
        for (i=1; i<argc; i++) {
		register struct mntent *mnt;

		if (stat(argv[i], &statb) < 0) {
			(void) fprintf(stderr, "df: ");
			perror(argv[i]);
		} else {
			if ((statb.st_mode & S_IFMT) == S_IFBLK ||
			    (statb.st_mode & S_IFMT) == S_IFCHR) {
				dfreedev(argv[i]);
			} else {
				if ((mnt = getmntpt(argv[i])) != NULL)
					dfreemnt(argv[i], mnt);
			}
		}
	}
}

dfreedev(file)
	char *file;
{
	long totalblks, availblks, avail, free, used;
	int fi;

	fi = open(file, 0);
	if (fi < 0) {
		perror(file);
		return;
	}
	bread(fi, SBLOCK, (char *)&sblock, SBSIZE);
	printf("%-20.20s", file);
	totalblks = sblock.fs_dsize;
	free = sblock.fs_cstotal.cs_nbfree * sblock.fs_frag +
	    sblock.fs_cstotal.cs_nffree;
	used = totalblks - free;
	availblks = totalblks * (100 - sblock.fs_minfree) / 100;
	avail = availblks > used ? availblks - used : 0;
	printf("%8d%8d%8d",
	    totalblks * sblock.fs_fsize / 1024,
	    used * sblock.fs_fsize / 1024,
	    avail * sblock.fs_fsize / 1024);
	printf("%6.0f%%",
	    availblks==0? 0.0: (double)used/(double)availblks * 100.0);
	if (iflag) {
		int inodes = sblock.fs_ncg * sblock.fs_ipg;
		used = inodes - sblock.fs_cstotal.cs_nifree;
		printf("%8ld%8ld%6.0f%% ", used, sblock.fs_cstotal.cs_nifree,
		    inodes == 0 ? 0.0 : (double)used / (double)inodes * 100.0);
	} else
		printf("  ");
	(void) printf("  %s\n", mpath(file));
	(void) close(fi);
}

dfreemnt(file, mnt)
	char *file;
	struct mntent *mnt;
{
	long totalblks, avail, free, used, reserved;
	struct statfs fs;

	if (statfs(file, &fs) < 0) {
		perror(file);
		return;
	}
	if (strlen(mnt->mnt_fsname) > 20) {
		printf("%s\n", mnt->mnt_fsname);
		printf("                    ");
	} else {
		printf("%-20.20s", mnt->mnt_fsname);
	}
	totalblks = fs.f_blocks;
	free = fs.f_bfree;
	used = totalblks - free;
	avail = fs.f_bavail;
	reserved = free - avail;
	if (avail < 0)
		avail = 0;
	printf("%8d%8d%8d", totalblks * fs.f_bsize / 1024,
	    used * fs.f_bsize / 1024, avail * fs.f_bsize / 1024);
	totalblks -= reserved;
	printf("%6.0f%%",
	    totalblks==0? 0.0: (double)used/(double)totalblks * 100.0);
	if (iflag) {
		long files, used;

		files = fs.f_files;
		used = files - fs.f_ffree;
		printf("%8ld%8ld%6.0f%% ", used, fs.f_ffree,
		    files == 0? 0.0: (double)used / (double)files * 100.0);
	} else
		printf("  ");
	printf("  %s\n", mnt->mnt_dir);
}

/*
 * Given a name like /usr/src/etc/foo.c returns the mntent
 * structure for the file system it lives in.
 */
struct mntent *
getmntpt(file)
	char *file;
{
	FILE *mntp;
	struct mntent *mnt, *mntsave;
	struct stat filestat, dirstat;

	if (stat(file, &filestat) < 0) {
		perror(file);
		return(NULL);
	}

	if ((mntp = setmntent(MOUNTED, "r")) == 0) {
		perror(MOUNTED);
		exit(1);
	}

	mntsave = NULL;
	while ((mnt = getmntent(mntp)) != 0) {
		if (strcmp(mnt->mnt_type, MNTTYPE_IGNORE) == 0 ||
		    strcmp(mnt->mnt_type, MNTTYPE_SWAP) == 0)
			continue;
		if ((stat(mnt->mnt_dir, &dirstat) >= 0) &&
		   (filestat.st_dev == dirstat.st_dev)) {
			mntsave = mntdup(mnt);
		}
	}
	(void) endmntent(mntp);
	if (mntsave) {
		return(mntsave);
	} else {
		fprintf(stderr, "Couldn't find mount point for %s\n", file);
		exit(1);
	}
	/*NOTREACHED*/
}


long lseek();

bread(fi, bno, buf, cnt)
        int fi;
	daddr_t bno;
	char *buf;
{
	int n;
	extern errno;

	(void) lseek(fi, (long)(bno * DEV_BSIZE), 0);
	if ((n=read(fi, buf, cnt)) != cnt) {
		printf("\nread error bno = %ld\n", bno);
		printf("count = %d; errno = %d\n", n, errno);
		exit(0);
	}
}

/*
 * Given a name like /dev/rrp0h, returns the mounted path, like /usr.
 */
char *
mpath(file)
	char *file;
{
        FILE *mntp;
        register struct mntent *mnt;

        if ((mntp = setmntent(MOUNTED, "r")) == 0) {
                (void) fprintf(stderr, "df: ");
                perror(MOUNTED);
                exit(1);
        }
 
        while ((mnt = getmntent(mntp)) != 0) {
                if (strcmp(file, mnt->mnt_fsname) == 0) {
                        (void) endmntent(mntp);
                        return (mnt->mnt_dir);
                }
        }
        (void) endmntent(mntp);
	return "";
}

char *
xmalloc(size)
	unsigned int size;
{
	register char *ret;
	char *malloc();
	
	if ((ret = (char *)malloc(size)) == NULL) {
		(void) fprintf(stderr, "umount: ran out of memory!\n");
		exit(1);
	}
	return (ret);
}

struct mntent *
mntdup(mnt)
	register struct mntent *mnt;
{
	register struct mntent *new;

	new = (struct mntent *)xmalloc(sizeof(*new));

	new->mnt_fsname = (char *)xmalloc(strlen(mnt->mnt_fsname) + 1);
	(void) strcpy(new->mnt_fsname, mnt->mnt_fsname);

	new->mnt_dir = (char *)xmalloc(strlen(mnt->mnt_dir) + 1);
	(void) strcpy(new->mnt_dir, mnt->mnt_dir);

	new->mnt_type = (char *)xmalloc(strlen(mnt->mnt_type) + 1);
	(void) strcpy(new->mnt_type, mnt->mnt_type);

	new->mnt_opts = (char *)xmalloc(strlen(mnt->mnt_opts) + 1);
	(void) strcpy(new->mnt_opts, mnt->mnt_opts);

	new->mnt_freq = mnt->mnt_freq;
	new->mnt_passno = mnt->mnt_passno;

	return (new);
}

