#define	SERVER
#include <stdio.h>
#include <errno.h>
#include <sgtty.h>
#include <signal.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <is68kif/enet.h>
#include <netinet/in.h>
#include <net/if.h>
#include <is68kstand/saboot.h>

extern int errno;
struct eniocb EnetControlBlk;
u_char myaddr[6];
char hostname[32];
char autoboot[256];
struct boot_packet	bp;
char *enet0 = (char *)0;
int	allow_writes = 0;

struct enfilter PacketFilter =   /* Receive only boot packets */
{	127, /* enf_Priority  */
	7,   /* enf_FilterLen */
    	ENF_PUSHWORD+6,ENF_PUSHLIT|ENF_EQ,ETHERTYPE_ISIBOOT,
    	ENF_PUSHWORD+6,ENF_PUSHLIT|ENF_EQ,ETHERTYPE_ISIBOOT_OLD, 
	ENF_NOPUSH|ENF_OR
};


/*
 * 	This bootd runs on a host with an "enet" filterd connection to 
 * ethernet.  It is capable of providing access to files on the host from 
 * other machines on the network, called remote machines.  It is intended 
 * to allow other machines on the network to boot from files on hosts that are 
 * running the bootd.  
 * 	The protocol used to request services of the bootd is specific 
 * to the ethernet.  All operations are initiated by the remote machine by 
 * transmiting packets. All packets are the same length.  The host machine 
 * will transmit packets back (possibly with added information) to the remote
 * machine as an acknoldgement of its request.  The remote machine initiates 
 * a connection with a bootd by broadcasting a "connect" packet, with the 
 * hostname of the server in the data portion of the packet.  After this 
 * connection is acknoldged all transmits from the remote machine are to the
 * host that acknoldged the connect request.  A state diagram of the protocol 
 * is shown below:
 *
 *   +-------+             +----------+           +-------+--read|write-|
 *   | CLOSED|             | CONNECTED|           | OPENED|             |
 *   +-------+---connect-->+----------+---open--->+-------+<------------|
 *       ^                                          |
 *       |--------------close-----------------------|
 *
 * 	In order for the bootd to support requests from more than one 
 * machine at once a "connection block" list is used.  When a packet comes
 * in we check through all active connections blocks to see if there is one with
 * a network address field the same as the packets source address.  If so, we 
 * use that connection state to service the packet.  If no connection was found
 * we get a new connection block from the idle pool.  When the connection is 
 * closed the connection block is returned to the idle pool.
 */
#define MAXCONECTIONS 10


struct connection {
	struct connection	*c_next;
	FILE 			*c_fid;
	int			c_state;
	u_char			c_addr[6];
}	cnct[MAXCONECTIONS];

struct connection *activep;
struct connection *idlep;

/*
 * The file bootd.conf has information relating ethernet address to a machine's
 * host name its boot strings. Lines in the file consist of the following ascii
 * representation: ethernet-address hostname bootstring. Such as:
 *
 * 70:01:00:70:00:22	foo	fooserver:/vmunix HOST=goo SERVER=foo	
 *
 * where the first part is a 48 bit ethernet addrerss, the second is the 
 * corresponding hosts name, and remainder of the line is the boot string.
 * The ethernet address is represented as "x:x:x:x:x:x" where x is a hex 
 * number between 00 and ff;  the bytes are always in network order. Lines
 * may be commented with a "#" as their first character.
 */
static char *bootfname = "/etc/bootd.conf";

int	showactive(), inactive(), traceonoff();

trace = 0;


main(ac, av)
int ac;
char **av;
{
	int net;
	u_char tmp[6];
	struct connection *ap, *tp;
	int n, i;
	char *cp;

	chdir("/dev");
	if (ac > 1  &&  av[1][0] != '-')
		enet0 = av[1];
	else if (ac > 1  &&  av[1][0] == '-') {
		cp = &av[1][1];
		while (*cp) {
			if (*cp == 't')
				trace = 1;
			if (*cp == 'w')
				allow_writes = 1;
			*cp++;
		}
	}

#ifndef	DEBUG
	if (fork())
		exit(0);
	for (i = getdtablesize() - 1; i >= 0; i--)
		(void) close(i);
	(void) open("/dev/null", O_RDONLY);
	(void) dup2(0, 1);
	(void) dup2(0, 2);
	n = open("/dev/tty", O_RDWR);
	if (n > 0) {
		(void) ioctl(n, TIOCNOTTY, (char *)NULL);
		(void) close(n);
	}
#endif	DEBUG
	openlog("bootd", LOG_PID|LOG_CONS, LOG_DAEMON);

	/* print out active connections on hangup signal */
	signal(SIGHUP, showactive);

	/* make all connections inactive */
	signal(SIGTERM, inactive);

	/* toggle trace option */
	signal(SIGINT, traceonoff);

	/* open up the enet packet filter file for the boot server */
	net = NetOpen();

	/* initialize the connection lists */
	for (i = 0 ; i < (MAXCONECTIONS - 1) ; i++)
		cnct[i].c_next = &cnct[i+1];
	idlep = &cnct[0];
	activep = 0;
		
	/* service requests */
	for (;;) {
		/* pick up a packet */
		NetRead(net, &bp, sizeof(struct boot_packet));
		if (trace) {
		    syslog(LOG_DEBUG, 
			"REQ%d: SRC %x:%x:%x:%x:%x:%x DST %x:%x:%x:%x:%x:%x",
			bp.bp_pkid,
			bp.bp_eh.ether_shost[0], bp.bp_eh.ether_shost[1],
			bp.bp_eh.ether_shost[2], bp.bp_eh.ether_shost[3],
			bp.bp_eh.ether_shost[4], bp.bp_eh.ether_shost[5],
			bp.bp_eh.ether_dhost[0], bp.bp_eh.ether_dhost[1],
			bp.bp_eh.ether_dhost[2], bp.bp_eh.ether_dhost[3],
			bp.bp_eh.ether_dhost[4], bp.bp_eh.ether_dhost[5]);
		}

		/* try to find an active connection at that source address */
		for (ap = activep; ap; ap = ap->c_next)
			if (bcmp(ap->c_addr, bp.bp_eh.ether_shost, 6) == 0)
				break;

		/* if no active connection then create a new connection */
		if (ap == 0) {
			if (idlep == 0) {
				syslog(LOG_ERR, "out of connections");
				continue;
			}
			ap = idlep;
			idlep = ap->c_next;
			ap->c_next = activep;
			activep = ap;
			ap->c_state = BOOT_CLOSE;
			bcopy(bp.bp_eh.ether_shost, ap->c_addr, 6);
			if (trace)
				syslog(LOG_DEBUG,"ACTIVATE connection %x",ap);
		}
		if (trace)
			syslog(LOG_DEBUG, "%x: STATE: %s; COMMAND: %s", ap, 
				bootstate[ap->c_state], command[bp.bp_cmd]);

		/* switch on the state of the connection and service request */
		switch (ap->c_state) {
		    case BOOT_CLOSE:
		    case BOOT_AUTOBOOT:
		    reconnect:
			if (bp.bp_cmd!=BOOT_CONNECT && bp.bp_cmd!=BOOT_AUTOBOOT)
				continue;
			if (bp.bp_cmd == BOOT_AUTOBOOT) {
			    if (!bootd_ntoboot(bp.bp_eh.ether_shost,autoboot)){
			    	if (trace)
				    syslog(LOG_DEBUG,"AUTOBOOT NOT FOUND");
				rmactive(ap);
				continue;
			    }
			    if (trace)
				syslog(LOG_DEBUG,"AUTOBOOT %s",autoboot);
			    strcpy(bp.bp_data, autoboot);
			} else {
			    /* if not for this host then throw away */
			    gethostname(hostname,sizeof hostname);
			    if (trace)
				syslog(LOG_DEBUG, "HOST %s==%s", 
					bp.bp_data, hostname);
			    if (strcmp(bp.bp_data, hostname) != 0) {
					rmactive(ap);
					continue;
			    }
			}
			/* modify broadcast address */
			if ((bp.bp_eh.ether_dhost[0] == 0xFF) &&
			    (bp.bp_eh.ether_dhost[1] == 0xFF) &&
			    (bp.bp_eh.ether_dhost[2] == 0xFF) &&
			    (bp.bp_eh.ether_dhost[3] == 0xFF) &&
			    (bp.bp_eh.ether_dhost[4] == 0xFF) &&
			    (bp.bp_eh.ether_dhost[5] == 0xFF)) {
				if (trace)
					syslog(LOG_DEBUG, "MYADDR->BROADCAST");
				bcopy(myaddr, bp.bp_eh.ether_dhost, 6);
			}
			break;

		    case BOOT_CONNECT:
			/* connect packet out of sequence, reconnect */
			if (bp.bp_cmd==BOOT_CONNECT || bp.bp_cmd==BOOT_AUTOBOOT)
				goto reconnect;
			/* if not an open packet then throw away */
			if (bp.bp_cmd != BOOT_OPEN)
				continue;
			if (trace)
				syslog(LOG_DEBUG, "OPEN %s", bp.bp_data);
			if (ap->c_fid != NULL)
				fclose(ap->c_fid);
			if ((ap->c_fid = fopen(bp.bp_data,"r+")) == NULL) {
				if (trace)
					syslog(LOG_DEBUG, "file not found");
				bp.bp_cmd = BOOT_CLOSE;
			}
			break;

		    case BOOT_OPEN:
		    case BOOT_READ:
		    case BOOT_WRITE:
			switch (bp.bp_cmd) {
		    	    case BOOT_CONNECT:
		    	    case BOOT_AUTOBOOT:
				/* connect packet out of sequence, reconnect */
				goto reconnect;

			    case BOOT_WRITE:
			    case BOOT_READ:
				if ((n = fseek(ap->c_fid, bp.bp_offset, 0)) >= 0) {
				    if (bp.bp_cmd == BOOT_READ)
					n = fread(bp.bp_data,1,bp.bp_len,ap->c_fid);
				    else if (allow_writes)
					n = fwrite(bp.bp_data,1,bp.bp_len,ap->c_fid);
				    else
					n = bp.bp_len;
				} else if (trace)
					syslog(LOG_DEBUG, "%x: seek error %x",
						ap, bp.bp_offset);
				if (trace && n != bp.bp_len)
					syslog(LOG_DEBUG, "%x: shortio %x %x",
						ap, n, bp.bp_len);
				if (n <= 0)
					bp.bp_len = 0;
				else
					bp.bp_len = n;
				break;

			    case BOOT_CLOSE:
				/* delete the connection from active list */
				rmactive(ap);
				if (trace)
					syslog(LOG_DEBUG,
						"DELETE connection %x",ap);
				if (ap->c_fid != NULL) {
					fclose(ap->c_fid);
					ap->c_fid = NULL;
				}
				ap = NULL;
				break;
			}
			break;

		    default:
			syslog(LOG_ERR, "bad packet");
		}

		/* send back reply packet */
		bcopy(bp.bp_eh.ether_dhost, tmp, 6);
		bcopy(bp.bp_eh.ether_shost, bp.bp_eh.ether_dhost, 6);
		bcopy(tmp, bp.bp_eh.ether_shost, 6);
		if (trace) {
		    syslog(LOG_DEBUG, 
			"REP%d: DST %x:%x:%x:%x:%x:%x SRC %x:%x:%x:%x:%x:%x",
			bp.bp_pkid,
			bp.bp_eh.ether_dhost[0], bp.bp_eh.ether_dhost[1],
			bp.bp_eh.ether_dhost[2], bp.bp_eh.ether_dhost[3],
			bp.bp_eh.ether_dhost[4], bp.bp_eh.ether_dhost[5],
			bp.bp_eh.ether_shost[0], bp.bp_eh.ether_shost[1],
			bp.bp_eh.ether_shost[2], bp.bp_eh.ether_shost[3],
			bp.bp_eh.ether_shost[4], bp.bp_eh.ether_shost[5]);
		}
		NetWrite(net, &bp, sizeof(struct boot_packet));
		if (ap)
			ap->c_state = bp.bp_cmd;
	}
}

/*
 * Open an ethernet connection returning fileid on connection
 */
NetOpen()
{
	register int i, net;
	struct eniocb *buffer = &EnetControlBlk;
	u_int maxwaiting;
	struct endevp endevp;
	register u_char *p;

	if (enet0) {
		if( (net = open(enet0, 2)) >= 0)
			ioctl( net, FIOCLEX, 0 ); /* Close file on a exec */
		else {
			if (errno == EBUSY)
				syslog(LOG_ERR, "already active");
			else
				syslog(LOG_ERR, "open: %m");
			exit(1);
		}
	} else {
		enet0 = "/dev/enet?a";
		for (enet0[9] = '0';  enet0[9] < '4';  enet0[9] += 1)
			if( (net = open(enet0, 2)) >= 0  ||  errno != EBUSY)
				break;
		if (net < 0) {
			syslog(LOG_ERR, "open: %m");
			exit(1);
		}
	}

    	ioctl( net, EIOCDEVP, &endevp );
    	bcopy((caddr_t)endevp.end_addr, myaddr, 6);
	if (trace)
		syslog(LOG_DEBUG, "MYADDR %x:%x:%x:%x:%x:%x", myaddr[0],
			myaddr[1], myaddr[2], myaddr[3], myaddr[4], myaddr[5]);

    	/* Ask for maximum incoming packet buffering */
    	maxwaiting = buffer->en_maxwaiting;
    	ioctl( net, EIOCSETW, &maxwaiting );

    	/* Flush packets in the input queue */
    	ioctl( net, EIOCFLUSH, 0 );

    	/* Set the kernel packet filter */
    	ioctl( net, EIOCSETF, &PacketFilter ); /* default is to ignore all */

    	return( net );
}

/* 
 * Receive a packet from the ethernet specified by net and place it in packet.
 */
NetRead( net, packet, packetlength)
int	net;			/* File id of ethernet */
struct	boot_packet *packet;	/* Packet to read */
int	packetlength;		/* Actual packet length */
{
    packetlength = read( net, packet, packetlength );

    if( packetlength < sizeof(struct boot_packet) ) 
        return( -1 );

    return( packetlength );
}

/* 
 * Send a boot packet over the ethernet specified by net
 */
NetWrite( net, packet, packetlength)
int	net;				/* file id to write to */
register struct	boot_packet *packet;	/* Packet to write */
{
	return( write(net, packet, packetlength));
}

showactive()
{
	struct connection *ap;

	syslog(LOG_DEBUG, "connection status: trace %s", trace ? "on" : "off");
	for (ap = activep; ap; ap = ap->c_next)
		syslog(LOG_DEBUG, "%s (%x:%x:%x:%x:%x):%x\n", 
			bootstate[ap->c_state],
			ap->c_addr[0], ap->c_addr[1], ap->c_addr[2], 
			ap->c_addr[3], ap->c_addr[4], ap->c_addr[5]);
}

rmactive(ap)
struct connection *ap;
{
	struct connection *tp;

	if (ap == activep)
		activep = ap->c_next;
	else {
		for (tp = activep; tp; tp = tp->c_next)
			if (tp->c_next == ap)
				break;
		if (tp == 0) {
			syslog(LOG_ERR, "lost");
			exit(1);
		}
		tp->c_next = ap->c_next;
	}
	ap->c_next = idlep;
	idlep = ap;
}

inactive()
{
	struct connection *ap;

	for (ap = activep;  ap  &&  ap->c_next;  ap = ap->c_next)
		;
	if (ap) {
		ap->c_next = idlep;
		idlep = activep;
		activep = 0;
	}
}

traceonoff()
{
	if (trace) {
		syslog(LOG_DEBUG, "trace off");
		trace = 0;
	} else {
		syslog(LOG_DEBUG, "trace on");
		trace = 1;
	}
}

/*
 * Given a 48 bit ethernet address, this routine returns the bootstring.
 * Returns zero if not found;
 */
bootd_ntoboot(e, boot)
	char *e;		/* function input */
	char *boot;		/* function output */
{
	char ce[6];
	char chost[32];
	char buf[512];
	FILE *bootdf;
	int found = 0;
	
	if ((bootdf = fopen(bootfname, "r")) == NULL)
		syslog(LOG_ERR, "cant open %s: %m", bootfname);
	else {
		fseek( bootdf, 0, 0);
		found = 0;
		while (fscanf(bootdf, "%[^\n] ", buf) == 1) {
			if (bootd_parse(buf, ce, chost, boot) &&
			    ((bcmp(e, ce, 6)) == 0)) {
				found = 1;
				break;
			}
		}
		fclose(bootdf);
	}
	return (found);
}
/*
 * Parses a line from /etc/bootd.conf into its components.
 * Returns zero if successful, non-zero otherwise.
 */
bootd_parse(s, e, host, boot)
	char *s;		/* the string to be parsed */
	char *e;		/* ethernet address to be filled in */
	char *host;		/* hostname to be filled in */
	char *boot;		/* bootstring to be filled in */
{
	register int i;
	int t[6];
	
	if ((s[0] == '#') || sscanf(s, " %2x:%2x:%2x:%2x:%2x:%2x %s %[^\n] ", 
	    &t[0], &t[1], &t[2], &t[3], &t[4], &t[5], host, boot) != 8)
		return 0;
	for (i = 0 ; i < 6; i++)
		e[i] = t[i];
	return 1;
}
