static char *RcsId = 
    "$Header: dosys.c,v 1.1 87/09/17 14:22:44 root Exp $";

/* static char *sccsid = "@(#)dosys.c	4.1 (Berkeley) 81/02/28"; */

/*
 * $Log:	dosys.c,v $
 * Revision 1.1  87/09/17  14:22:44  root
 * Initial revision
 * 
 * Revision 1.2  86/05/13  12:50:32  reb
 * Enlarge argv array in doexec() and add check for overflow of that array.
 * 
 * Revision 1.1  86/02/26  08:57:33  root
 * Initial revision
 * 
 * Revision 1.1  83/12/12  09:10:33  kcs
 * Initial revision
 * 
 * Revision 4.6  83/12/11  23:43:53  crl
 * Have closedir() use new directory structures, being careful since
 * 	we have used a vfork()
 * 
 * Revision 4.5  83/12/04  17:29:31  crl
 * In await() enable the interrupt catching before waiting so we will 
 * 	do the $@ deletion.
 * 
 * Revision 4.4  83/10/31  01:17:30  crl
 * Doshell() now looks for a variable SHELL which specifies the shell
 * 	to use in executing a command.
 * 
 * Revision 4.3  83/07/23  14:45:41  crl
 * sys/types.h included in defs.h.
 * 
 * Revision 4.2  83/07/22  14:14:26  crl
 * Made to work transparently with RCS.
 * 
 * Revision 4.1  83/03/01  00:43:12  crl
 * Vanilla 4.1 version
 */

#include "defs.h"
#include <signal.h>
#include <errno.h>
#include <sys/stat.h>

dosys(comstring,nohalt)
register char *comstring;
int nohalt;
{
	register int status;

	if(metas(comstring))
		status = doshell(comstring,nohalt);
	else
		status = doexec(comstring);
	return(status);
}

/* Are there are any  Shell meta-characters? */

metas(s)
register char *s;
{
	register char c;

	while( (funny[c = *s++] & META) == 0 )
		;
	return( c );
}

doshell(comstring,nohalt)
char *comstring;
int nohalt;
{
#ifdef SHELLENV
	char *getenv();
#endif
	static char *shellstr;
	static char *shellcom;
	struct varblock *v;

	if (shellcom == NULL) {
		v = varptr("SHELL");
		if ((shellcom = v->varval) == NULL) {
#ifdef SHELLENV
			if ((shellcom = getenv("SHELL")) == NULL)
				shellcom = SHELLCOM;
			else
				shellcom = copys(shellcom);
#else
			shellcom = SHELLCOM;
#endif
			v->varval = shellcom;
		}
		if ((shellstr = rindex(shellcom, '/')) == NULL)
			shellstr = shellcom;
		else
			shellstr++;
	}
	if((waitpid = vfork()) == 0) {
		enbint(SIG_DFL);
		doclose();
		execl(shellcom, shellstr, (nohalt ? "-c" : "-ce"), comstring, 0);
		fatal("Couldn't load Shell");
	}
	return( await() );
}

await()
{
	int status;
	register int pid;
	int intrupt();

	enbint(intrupt);
	while( (pid = wait(&status)) != waitpid)
		if(pid == -1)
			fatal("bad wait code");
	waitpid = 0;
	return(status);
}

/* Close open directory files before exec'ing */

doclose()
{
	register struct opendir *od;

	/*
	 * We have done a vfork, so we can`t do anything to stomp on our
	 * paren`t address space.  Unfortunately, the code above doesn`t
	 * work since our parent`s files remain open. And we can`t just
	 * do a closedir, since it will free a dynamically-allocated table
	 * entry. So we use this hack, calling close directly. If the
	 * interface ever changes, we are going to be out of luck.
	 */

	for (od = firstod; od; od = od->nxtopendir)
		if (od->dirfc != NULL)
			close(od->dirfc->dd_fd);
}

#define MAXARGV	400

doexec(str)
register char *str;
{
	register char *t;
	char *argv[MAXARGV];
	register char **p;

	while( *str==' ' || *str=='\t' )
		++str;
	if( *str == '\0' )
		return(-1);	/* no command */

	p = argv;
	for(t = str ; *t ; ) {
		if (p >= argv + MAXARGV)
			fatal1("%s: Too many arguments.", str);
		*p++ = t;
		while(*t!=' ' && *t!='\t' && *t!='\0')
			++t;
		if(*t)
			for( *t++ = '\0' ; *t==' ' || *t=='\t'  ; ++t)
				;
	}

	*p = NULL;

	if((waitpid = vfork()) == 0) {
		enbint(SIG_DFL);
		doclose();
		enbint(intrupt);
		execvp(str, argv);
		fatal1("Cannot load %s",str);
	}

	return( await() );
}

touch(force, name)
int force;
char *name;
{
	struct stat stbuff;
	char junk[1];
	int fd;

	if( stat(name,&stbuff) < 0)
		if(force)
			goto create;
		else {
			fprintf(stderr, "touch: file %s does not exist.\n", name);
			return;
		}

	if(stbuff.st_size == 0)
		goto create;

	if( (fd = open(name, 2)) < 0)
		goto bad;

	if( read(fd, junk, 1) < 1) {
		close(fd);
		goto bad;
	}
	lseek(fd, 0L, 0);
	if( write(fd, junk, 1) < 1 ) {
		close(fd);
		goto bad;
	}
	close(fd);
	return;

bad:
	fprintf(stderr, "Cannot touch %s\n", name);
	return;

create:
	if( (fd = creat(name, 0666)) < 0)
		goto bad;
	close(fd);
}
