/* Copyright (c) 1980 Regents of the University of California */
#include <stdio.h>
#include "as.h"
#include "assyms.h"
#include "instrs.h"


/*
 *	Sizes to Loader reference types and type flags
 */
/*0	1	2	3	4	5	6	7	8*/
int	type_124[] =	/* {1,2,4,8} ==> {TYPB, TYPW, TYPL, TYPQ} */
{0,	 TYPB,	TYPW,	 0,	 TYPL,	 0,	 TYPF,	 0,	 TYPD};

/*
 *	type flags to Loader reference and byte lengths
 */
/*TYPB	TYPW	TYPL	TYPQ	TYPF	TYPD*/
int	ty_NORELOC[] =	/* {TYPB..TYPD} ==> {1 if relocation not OK */
{0,	0,	0,	1,	1,	1};
int	ty_nbyte[] =	/* {TYPB..TYPD} ==> {1,2,4,8} */
{1,	2,	4,	8,	4,	8};
int	ty_nlg[] =	/* {TYPB..TYPD} ==> lg{1,2,4,8} */
{0,	1,	2,	3,	2,	3};

insout(op, ap, nact)
	register struct arg *ap;
	register short nact;
{
	short		jxxflg;
	register	struct	instab	*ip;		/* the instruction */

    tryagain:
	jxxflg = nact;
	if (nact < 0)
		nact = -nact;
	if (passno == 1) {
		ip = itab[op];
		if (nact != ip->i_nargs) {
			if (nact < ip->i_nargs)
				yyerror("Too few arguments");
			else
				yyerror("Too many arguments");
			return;
		}
		if (nact) {
			register struct insfmt *fp =
				(struct insfmt *)ip->i_ifmt;
			register short i;
			for (i = ip->i_nfmt;  i--;  fp++) {
				register struct arg *rap;
				register long *mp, res;
				register short j;
				mp = &fp->if_m0;
				for (rap = ap, j = nact;
				    j-- > 0;  rap++, mp++) {
					res = rap->a_atype & *mp;
					if (res == 0)
						goto nomatch;
					else if (rap->a_atype > 0 && *mp > 0)
						/* no specials => match OK */
						continue;
					else {
						/* one or both is special */
						if (res > 0)
							/* non & SPEC */
							goto nomatch;
						else if (res == SPECIAL)
							/* mismatch w/SPECs */
							goto nomatch;
						else
							continue;
					}
				}
				break;
			    nomatch:
				continue;
			}
			if (i < 0) {
				if (op == JBSR) {	/* royal kludge */
					extern struct symtab *lastjxxx;
					extern int njxxx;
					lastjxxx->s_tag = JXINACTIVE;
					njxxx += 1;
					op = JSR;
					goto tryagain;
				}
				yyerror("invalid addressing mode");
				return;
			}
			if (op == JBSR && ((ap->a_xp->e_xtype&XTYPE)==XABS)) {
				extern struct symtab *lastjxxx;
				extern int njxxx;
				lastjxxx->s_tag = JXINACTIVE;
				njxxx += 1;
				op = JSR;
				goto tryagain;
			}
		    }
	} /* both passes here */
	if (jxxflg < 0)
		ijxout(op, ap, nact);
	else
		putins(op, ap, nact);
}

extern	int d124;

putins(op, ap, n)
	struct arg *ap;
	register short n;
{
	register struct insfmt *fp;
	register struct	instab	*ip;
	register short i;

#ifdef DEBUG
	fflush(stdout);
#endif
    tryagain:
	ip = itab[op];
	fp = (struct insfmt *)ip->i_ifmt;
	for (i = ip->i_nfmt;  i--;  fp++) {
		register struct arg *rap;
		register long *mp, res;
		register short j;
		mp = &fp->if_m0;
		for (rap = ap, j = n; j-- > 0;  rap++, mp++) {
			res = rap->a_atype & *mp;
			if (res == 0)
				goto nomatch;
			else if (rap->a_atype > 0 && *mp > 0)
				/* no specials => match OK */
				continue;
			else {
				/* one or both is special */
				if (res > 0)
					/* non & SPEC */
					goto nomatch;
				else if (res == SPECIAL)
					/* mismatch w/SPECs */
					goto nomatch;
				else
					continue;
			}
		}
		mp = &fp->if_m0;
		for (rap = ap, j = n;  j-- > 0;  rap++, mp++) {
			register struct exp *ep;
			if (rap->a_atype & (IMML|IMMD))	/* imm of any size */
				rap->a_atype |= IMM;
			switch (rap->a_atype & ATYPEMASK) {
			  case ABS:
				if (rap->a_xsize == 4) {
					rap->a_amode = M_ABSL;
					break;
				}
				if (rap->a_xsize == 2) {
					rap->a_amode = M_ABSS;
					break;
				}
				ep = rap->a_xp;
				if ((ep->e_xtype & XTYPE) == XABS  &&
				    !(ep->e_xtype & XFORW)) {
					if (ep->e_xvalue >= MINWORD  &&
					    ep->e_xvalue <= MAXWORD)
						rap->a_amode = M_ABSS;
					else
						rap->a_amode = M_ABSL;
				} else
					rap->a_amode = (d124==4) ? M_ABSL : M_ABSS;
				rap->a_xsize = (rap->a_amode == M_ABSS) ? 2 : 4;
				break;
			  case IMM:
				rap->a_amode = M_IMM;
				switch (*mp & ((IMML|IMMD) & ~IMM)) {
				  case ~IMM&IMMSB:
				  case ~IMM&IMMB:	rap->a_xsize = 1; break;
				  case ~IMM&IMB3:
				  case ~IMM&IMB5:
				  case ~IMM&IMMSW:
				  case ~IMM&IMMW:	rap->a_xsize = 2; break;
				  case ~IMM&IMML:	rap->a_xsize = 4; break;
				  case ~IMM&IMMF:
					/* KLUDGE to tell from TYPL */
							rap->a_xsize = 6; break;
				  case ~IMM&IMMD:	rap->a_xsize = 8; break;
				  default:		rap->a_xsize = 0; break;
				}
				break;
			}
		}
		break;
	    nomatch:
		continue;
	}
	if (i < 0) {
		if (op == JBSR) {	/* royal kludge */
			op = JSR;
			goto tryagain;
		}
		yyerror("invalid mode");
		return;
	}
	if (op == JBSR  &&  ((ap->a_xp->e_xtype&XTYPE)==XABS)) {
		op = JSR;
		goto tryagain;
	}
	if (passno == 1)
		dotp->e_xvalue += 2;	/* at least one word for the opcode */
	(*fp->if_build)(fp->if_opcode, ap);
}

nop (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2) {
		if (!for68020 && (op & 0xf0ff)==0x50FC)
			/* TRAPxx */
			yywarning("68020 instruction used");
	} else {
		outw (op);
	}
}

r0 (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2) {
		if (!for68020)
			if (op==0x49C0 || op==0x06C0 || op==0x06C8)
				/* EXTBL, RTM dn, RTM an */
				yywarning("68020 instruction used");
	} else {
		op |= (ap->a_areg1 & 7);
		outw (op);
	}
}

r0d (op, ap)
  short op;
  struct arg *ap;
{
	if (passno == 2) {
		op |= ((ap + 1)->a_areg1 & 7);
		outw (op);
	}
}

r0_r9 (op, ap)
  short op;
  struct arg *ap;
{
	if (passno == 2) {
		op |= (((ap + 1)->a_areg1 & 7) << 9) | (ap->a_areg1 & 7);
		outw (op);
	}
}

r9_r0 (op, ap)
  short op;
  struct arg *ap;
{
	if (passno == 2) {
		op |= ((ap->a_areg1 & 7) << 9) | ((ap + 1)->a_areg1 & 7);
		outw (op);
	}
}

r0_r9_imm (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2;
		if (!for68020)
			yywarning("68020 instruction used");
	} else {	/* passno == 2 */
		op |= (((ap + 1)->a_areg1 & 7) << 9) | (ap->a_areg1 & 7);
		outw (op);
		outrel ((ap + 2)->a_xp, TYPW);
	}
}

ea_r9 (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += easize (ap);
		if (!for68020 && op==0x4100)
			/* CHKL */
			yywarning("68020 instruction used");
	} else	/* passno == 2 */
		eaddr (op | (((ap + 1)->a_areg1 & 7) << 9), ap);
}

r9_ea (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2)
		dotp->e_xvalue += easize (ap + 1);
	else
		eaddr (op | ((ap->a_areg1 & 7) << 9), (ap + 1));
}

ea_ea6 (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2)
		dotp->e_xvalue += easize (ap) + easize (ap + 1);
	else
		eaddr_eaddr (op, ap);
}

ea (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2)
		dotp->e_xvalue += easize (ap);
	else
		eaddr (op, ap);
}

ead (op, ap)
  short op;
  struct arg *ap;
{
	ap += 1;
	if (passno != 2)
		dotp->e_xvalue += easize (ap);
	else
		eaddr (op, ap);
}

q39_ea (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2)
		dotp->e_xvalue += easize (ap + 1);
	else
		eaddr (op | ((ap->a_xp->e_xvalue & 7) << 9), (ap + 1));
}

q39_r0 (op, ap)
  short op;
  struct arg *ap;
{
	if (passno == 2) {
		op |= ((ap->a_xp->e_xvalue&7) << 9) | ((ap + 1)->a_areg1 & 7);
		outw (op);
	}
}

qb0_r9 (op, ap)
  short op;
  struct arg *ap;
{
	if (passno == 2) {
		op |= (((ap + 1)->a_areg1&7) << 9) | (ap->a_xp->e_xvalue&255);
		outw (op);
	}
}

q30 (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2) {
		if (!for68020)
			yywarning("68020 instruction used");
	} else {
		op |= (ap->a_xp->e_xvalue & 7);
		outw (op);
	}
}

q40 (op, ap)
  short op;
  struct arg *ap;
{
	if (passno == 1) {
		if ((ap->a_xp->e_xvalue & ~15) != 0)
			yyerror("invalid trap vector");
	} else {
		op |= (ap->a_xp->e_xvalue & 15);
		outw (op);
	}
}

imm_ea (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2) {
		register int len = ap->a_xsize;
		if (len == 1)
			len = 2;
		dotp->e_xvalue += len + easize (ap + 1);
		if (!for68020 && op==0x06C0)
			/* CALLM */
			yywarning("68020 instruction used");
	} else {
		imm_eaddr (op, ap, ap + 1);
	}
}

ea_imm (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2) {
		register int len = (ap + 1)->a_xsize;
		if (len == 1)
			len = 2;
		dotp->e_xvalue += len + easize (ap);
	} else {
		imm_eaddr (op, ap + 1, ap);
	}
}

list_ea (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap + 1);
		if (ap->a_areg1 >= 16)
			yyerror("Invalid register list for movem.");
	} else {
		register unsigned mask;
		if (ap->a_atype == REGLIST && (ap+1)->a_atype == DEC) {
			register int i;
			register unsigned val;

			/* for predec w/reglist, */
			/* flip: b0->b15, b1->b14, ... */
			mask = 0;
			val = ap->a_xp->e_xvalue;
			for (i = 16; i > 0; i--) {
				mask <<= 1;
				if (val & 1)
					mask++;
				val >>= 1;
			}
		} else
			mask = ap->a_xp->e_xvalue;
		w_eaddr (op, mask, ap + 1);
	}
}

ea_list (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if ((ap + 1)->a_areg1 >= 16)
			yyerror("Invalid register list for movem.");
	} else {
		w_eaddr (op, (ap + 1)->a_xp->e_xvalue, ap);
	}
}

r0_imm (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		register int len = (ap + 1)->a_xsize;
		if (len == 1)
			len = 2;
		dotp->e_xvalue += len;
		if (!for68020 && len == 4)
			yywarning("68020 instruction used");
	} else {
		register int mode = type_124[(ap+1)->a_xsize];
		op |= (ap->a_areg1 & 7);
		outw (op);
		if (mode == TYPB)
			outb (0);
		outrel ((ap+1)->a_xp, mode);
	}
}

imm (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		register int len = ap->a_xsize;
		if (len == 1)
			len = 2;
		dotp->e_xvalue += len;
		if (!for68020 && (op & 0xf0ff)==0x50FA)
			/* TRAPxxW */
			yywarning("68020 instruction used");
	} else {
		register int mode = type_124[ap->a_xsize];
		outw (op);
		if (mode == TYPB)
			outb (0);
		outrel (ap->a_xp, mode);
	}
}

imml (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 4;
		if (!for68020 && (op & 0xf0ff)==0x50FB)
			/* TRAPxxL */
			yywarning("68020 instruction used");
	} else {
		outw (op);
		outrel (ap->a_xp, TYPL);
	}
}

r0_disp (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2) 
		dotp->e_xvalue += 2;	/* at least one word for the opcode */
	else {
		op |= ((ap->a_areg1 & 7) << 9) | ((ap + 1)->a_areg1 & 7); 
		outw (op);
		addrwds(ap+1); 
	}
}

disp_r0 (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2) 
		dotp->e_xvalue += 2;	/* at least one word for the opcode */
	else {
		op |= (((ap + 1)->a_areg1 & 7) << 9) | (ap->a_areg1 & 7); 
		outw (op);
		addrwds(ap); 
	}
}

r0_disp16 (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2)
		dotp->e_xvalue += 2;
	else {
		op |= (ap->a_areg1 & 7);
		outw (op);
		ap++;
		if ((ap->a_xp->e_xtype & ~(XFORW|XXTRN)) == XUNDEF)
			yyerror("decr&branch to undefined label");
		outrel (ap->a_xp, TYPW | RELOC_LABEL);
	}
}

disp8 (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno == 2) {
		if ((ap->a_xp->e_xtype & ~(XFORW|XXTRN)) == XUNDEF)
			yyerror("branch to undefined label");
		ap->a_xp->e_xvalue -= 2;
		if ((ap->a_xp->e_xvalue - dotp->e_xvalue) == 0) {
			/* "bras 1f; 1: ...*/
			/* must emit nop instead! */
			outw (0x4e71);
		} else {
			op = (unsigned)op >> 8;
			outb (op);
			outrel (ap->a_xp, TYPB | RELOC_LABEL);
		}
	}
}

disp16 (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2)
		dotp->e_xvalue += 2;
	else {
		if ((ap->a_xp->e_xtype & ~(XFORW|XXTRN)) == XUNDEF)
			yyerror("branch to undefined label");
		outw (op);
		outrel (ap->a_xp, TYPW | RELOC_LABEL);
	}
}

disp32 (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 4;
		if (!for68020)
			yywarning("68020 instruction used");
	} else {
		if ((ap->a_xp->e_xtype & ~(XFORW|XXTRN)) == XUNDEF)
			yyerror("branch to undefined label");
		op |= 0x00FF;
		outw (op);
		outrel (ap->a_xp, TYPL | RELOC_LABEL);
	}
}

movs_ea (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2)
		dotp->e_xvalue += 2 + easize (ap + 1);
	else
		w_eaddr (op, (ap->a_areg1 << 12) + 0x0800, ap + 1);
}

ea_movs (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2)
		dotp->e_xvalue += 2 + easize (ap);
	else
		w_eaddr (op, ((ap + 1)->a_areg1 << 12), ap);
}

ea_rh0 (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68020 instruction used");
	} else
		w_eaddr (op, ((ap + 1)->a_areg1 << 12), ap);
}

ea_rh1 (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68020 instruction used");
	} else
		w_eaddr (op, ((ap + 1)->a_areg1 << 12) | 0x0800, ap);
}

ea_rh0p0 (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68020 instruction used");
	} else {
		register int extwd;
		register struct arg *ap1 = ap + 1;

		if (ap1->a_atype == DREG)
			extwd = (ap1->a_areg1 << 12) | ap1->a_areg1;
		else
			extwd = (ap1->a_areg2 << 12) | ap1->a_areg1;
		w_eaddr (op, extwd, ap);
	}
}

ea_rh1p0 (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68020 instruction used");
	} else {
		register int extwd = 0x0800;
		register struct arg *ap1 = ap + 1;

		if (ap1->a_atype == DREG)
			extwd |= (ap1->a_areg1 << 12) | ap1->a_areg1;
		else
			extwd |= (ap1->a_areg2 << 12) | ap1->a_areg1;
		w_eaddr (op, extwd, ap);
	}
}

ea_rh0p1 (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68020 instruction used");
	} else {
		register int extwd;
		register struct arg *ap1 = ap + 1;

		extwd = (ap1->a_areg2 << 12) | ap1->a_areg1 | 0x0400;
		w_eaddr (op, extwd, ap);
	}
}

ea_rh1p1 (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68020 instruction used");
	} else {
		register int extwd = 0x0C00;
		register struct arg *ap1 = ap + 1;

		extwd |= (ap1->a_areg2 << 12) | ap1->a_areg1;
		w_eaddr (op, extwd, ap);
	}
}

cas_ea (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap + 2);
		if (!for68020)
			yywarning("68020 instruction used");
	} else
		w_eaddr (op, ((ap+1)->a_areg1 << 6) | ap->a_areg1, ap + 2);
}

cas2 (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 4;
		if (!for68020)
			yywarning("68020 instruction used");
	} else {
		register int w;

		outw(op);
		w = ((ap+2)->a_areg1 << 12) | ((ap+1)->a_areg1 << 6) |
			ap->a_areg1;
		outw(w);
		w = ((ap+2)->a_areg2 << 12) | ((ap+1)->a_areg2 << 6) |
			ap->a_areg2;
		outw(w);
	}
}

static short contcode[] = {
	0x0800,	/* USP */
	0x0801,	/* VB */
	0x0000,	/* SFC */
	0x0001,	/* DFC */
	0x0002,	/* CAC */
	0x0802,	/* CAA */
	0x0803,	/* MSP */
	0x0804	/* ISP */
};

r_c (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2;
		if (!for68020 && (ap+1)->a_areg1 >= R_CAC)
			yywarning("68020 control register used");
	} else {
		register short rop;
		outw (op);
		rop = (ap->a_areg1 << 12) | contcode[(ap + 1)->a_areg1 - R_USP];
		outw (rop);
	}
}

c_r (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2;
		if (!for68020 && ap->a_areg1 >= R_CAC)
			yywarning("68020 control register used");
	} else {
		register short rop;
		outw (op);
		rop = ((ap + 1)->a_areg1 << 12) | contcode[ap->a_areg1 - R_USP];
		outw (rop);
	}
}

eafld (op, ap)
  short op;
  struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68020 instruction used");
	} else {
		if (ap->a_hasbf == 0 ) {
			yyerror("missing bitfield selection");
			return;
		}
		fld_ea(op, 0, ap);
	}
}

eafld_r12 (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68020 instruction used");
	} else {
		if (ap->a_hasbf == 0 ) {
			yyerror("missing bitfield selection");
			return;
		}
		fld_ea(op, (ap + 1)->a_areg1 << 12, ap);
	}
}

r12_eafld (op, ap)
  short op;
  register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap + 1);
		if (!for68020)
			yywarning("68020 instruction used");
	} else {
		if ((ap+1)->a_hasbf == 0 ) {
			yyerror("missing bitfield selection");
			return;
		}
		fld_ea(op, ap->a_areg1 << 12, (ap + 1));
	}
}

fld_ea (op, bf_spec, ap)
  short op;
  register short bf_spec;
  register struct arg *ap;
{
	if (ap->a_bforeg)
		bf_spec |= 0x0800;
	bf_spec |= (ap->a_bfoff & 0x1f) << 6;

	if (ap->a_bfwreg)
		bf_spec |= 0x0020;
	bf_spec |= (ap->a_bfwid & 0x1f);

	w_eaddr (op, bf_spec, ap);
}

easize (ap)
  register struct arg *ap;
{
	register short size;

	switch (ap->a_amode) {
	  case M_DISP:
		if (ap->a_bsize != 4) return 2;
		/* else fall thru */
	  case M_INDEX:
	  case M_PREX:
	  case M_POSTX:
		return ixsize(ap->a_amode, ap);
	  case M_ABSS:
		return 2;
	  case M_ABSL:
		return 4;
	  case M_PCDISP:
		if (ap->a_bsize != 4) return 2;
		/* else fall thru */
	  case M_PCINDEX:
	  case M_PCPREX:
	  case M_PCPOSTX:
		return ixsize(ap->a_amode, ap);
	  case M_IMM:
		if ((size = ap->a_xsize) == 1) size = 2; /* TYPB */
		else if (size == 6) size = 4;		 /* TYPF */
		return size;
	  default:
		return 0;
	}
}

ixsize(amode, ap)
  int amode;
  register struct arg *ap;
{
	register int size;
	register long bdisp, odisp;

	size = 2;
	bdisp = ap->a_xp->e_xvalue;

	switch (amode) {
	  case M_DISP:
	  case M_PCDISP:
		/* ONLY get here if for68020 and ap->a_bsize == 4! */
		size += 4;
		break;
	  case M_INDEX:
	  case M_PCINDEX:
		if ((ap->a_xp->e_xtype & XTYPE) != XABS ||
		    ap->a_xp->e_xtype & XFORW ||
		    ap->a_bsize != 0) {
			if (for68020) {
				if (ap->a_bsize == 2)
					size += 2;
				else
					size += 4;
			}
		} else if ((char)bdisp != bdisp) {
			if ((short)bdisp == bdisp)
				size += 2;
			else
				size += 4;
		}
		break;
	  case M_PREX:
	  case M_POSTX:
	  case M_PCPREX:
	  case M_PCPOSTX:
		if ((ap->a_xp->e_xtype & XTYPE) != XABS ||
		    ap->a_xp->e_xtype & XFORW ||
		    ap->a_bsize != 0) {
			if (ap->a_bsize == 2)
				size += 2;
			else
				size += 4;
		} else if (bdisp != 0) {
			if ((short)bdisp == bdisp)
				size += 2;
			else
				size += 4;
		}
		if ((ap->a_od->e_xtype & XTYPE) != XABS ||
		     ap->a_od->e_xtype & XFORW ||
		     ap->a_osize != 0) {
			if (ap->a_osize == 2)
				size += 2;
			else
				size += 4;
		} else if ((odisp = ap->a_od->e_xvalue) != 0) {
			if ((short)odisp == odisp)
				size += 2;
			else
				size += 4;
		}
		break;
	}
	return size;
}

static short addrmode;		/* saves addressing mode from modereg() */

modereg(ap, ea2)
  register struct arg *ap;
{
	register int reg = ap->a_areg1 & 7;
	register int mode = 7;

	switch (ap->a_amode) {
	  case M_DREG:	mode = 0; break;
	  case M_AREG:	mode = 1; break;
	  case M_INDR:	mode = 2; break;
	  case M_INC:	mode = 3; break;
	  case M_DEC:	mode = 4; break;
	  case M_DISP:
			if (ap->a_bsize != 4)
				mode = 5;
			else
				mode = 6;
			break;
	  case M_INDEX:
	  case M_PREX:
	  case M_POSTX:
			mode = 6;
			if (ap->a_areg1 == R_ZA)
				reg = 0;
			break;
	  case M_ABSS:	reg = 0; break;
	  case M_ABSL:	reg = 1; break;
	  case M_PCDISP:
			if (ap->a_bsize != 4)
				reg = 2;
			else
				reg = 3;
			break;
	  case M_PCINDEX:
	  case M_PCPREX:
	  case M_PCPOSTX:
	  		reg = 3; break;
	  case M_IMM:	reg = 4; break;
	  default:	yyerror("modereg: strange mode 0x%x", ap->a_atype);
			addrmode = 0;
			return (0);
	}
	addrmode = mode;
	if (ea2)
		return ((reg << 9) | (mode << 6));
	else
		return ((mode << 3) | reg);
}

addrwds(ap)
  register struct arg *ap;
{
	register int mode;
	register long bdisp;

	switch (ap->a_amode) {

	  case M_PCDISP:
			if (ap->a_bsize != 4) {
				mode = TYPW;
				bdisp = ap->a_xp->e_xvalue;
				if ((ap->a_xp->e_xtype & ~XFORW) != XABS) {
					mode |= RELOC_PCREL;
					bdisp -= dotp->e_xvalue & ~1;
				}
				if ((short)bdisp != bdisp)
					yyerror("displacement overflow");
			} else {
				index_wd (ap->a_amode, ap);
				return;
			}
			break;
	  case M_DISP:
			if (ap->a_bsize != 4) {
				mode = TYPW;
				bdisp = ap->a_xp->e_xvalue;
				if ((short)bdisp != bdisp)
					yyerror("displacement overflow");
			} else {
				index_wd (ap->a_amode, ap);
				return;
			}
			break;

	  case M_INDEX:
	  case M_PCINDEX:
	  case M_PREX:
	  case M_POSTX:
	  case M_PCPREX:
	  case M_PCPOSTX:

			index_wd (ap->a_amode, ap);
			return;

	  case M_ABSS:	mode = TYPW;
			break;

	  case M_ABSL:	mode = TYPL;
			break;

	  case M_IMM:	if ((mode = type_124[ap->a_xsize]) == TYPB)
				outb (0);
			break;
	}
	outrel (ap->a_xp, mode);
}

union index_word {
	unsigned short word;
	struct {
#ifdef VAX_CROSS
		unsigned short disp:8;
		unsigned short usefull:1;
		unsigned short scale:2;
		unsigned short sz:1;
		unsigned short reg:3;
		unsigned short isareg:1;
#else VAX_CROSS
		unsigned short isareg:1;
		unsigned short reg:3;
		unsigned short sz:1;
		unsigned short scale:2;
		unsigned short usefull:1;
		unsigned short disp:8;
#endif VAX_CROSS
	} brief;
	struct {
#ifdef VAX_CROSS
		unsigned short ixsel:3;
		unsigned short zfill:1;
		unsigned short bdsize:2;
		unsigned short isupp:1;
		unsigned short bsupp:1;
		unsigned short usefull:1;
		unsigned short scale:2;
		unsigned short sz:1;
		unsigned short reg:3;
		unsigned short isareg:1;
#else VAX_CROSS
		unsigned short isareg:1;
		unsigned short reg:3;
		unsigned short sz:1;
		unsigned short scale:2;
		unsigned short usefull:1;
		unsigned short bsupp:1;
		unsigned short isupp:1;
		unsigned short bdsize:2;
		unsigned short zfill:1;
		unsigned short ixsel:3;
#endif VAX_CROSS
	} full;
};

/* index_wd -	Use data in arg structure to compute an index word
 *		and emit appropriate offsets
 */
index_wd (amode, ap)
int amode;
register struct arg   *ap;
{
	register short reg;
	register long bdisp, odisp;
	register struct exp *bd, *od;
	union index_word ixwd;
	int mode, omode;

	mode = 0;
	omode = 0;
	ixwd.word = 0;			/* clear all bits */
	bd = ap->a_xp;
	od = ap->a_od;

	switch (amode) {
	case M_PCDISP:
		ap->a_areg2 = -1;
		/* fall thru */
	case M_PCPREX:
	case M_PCPOSTX:
		if ((bd->e_xtype & ~XFORW) != XABS)
			mode = RELOC_PCREL;
		ixwd.full.usefull = 1;
		break;
	case M_DISP:
		ap->a_areg2 = -1;
		/* fall thru */
	case M_PREX:
	case M_POSTX:
		ixwd.full.usefull = 1;
		break;

	case M_PCINDEX:
		if ((bd->e_xtype & ~XFORW) != XABS)
			mode = RELOC_PCREL;
		/* fall thru */
	case M_INDEX:
		bdisp = bd->e_xvalue;
		if (mode == RELOC_PCREL)
			bdisp -= dotp->e_xvalue & ~1;
		if ((bd->e_xtype & XTYPE) != XABS ||
		    bd->e_xtype & XFORW ||
		    ap->a_bsize != 0)
			ixwd.full.usefull = 1;
		else if (bdisp < -128 || bdisp > 127)
			ixwd.full.usefull = 1;
		else if (ap->a_ascale != 0 && !for68020)
			yywarning("68020 addressing mode used/required");
		break;
	}
	if (od != NULL)
		ixwd.full.usefull = 1;

	reg = ap->a_areg1;
	if (reg == R_ZPC || reg == R_ZA) { /* ZPC || ZA */
		ixwd.full.usefull = 1;
		ixwd.full.bsupp = 1;
	}

	reg = ap->a_areg2;
	if (reg == -1) {
		ixwd.full.isupp = 1;
	} else if (reg < 8) {
		ixwd.full.reg = reg;
	} else if (reg < 16) {
		ixwd.full.isareg = 1;
		ixwd.full.reg = reg;
	}

	if (ap->a_xsize == 4)
		ixwd.full.sz = 1;		/* else word */

	ixwd.full.scale = ap->a_ascale;

	if (!ixwd.full.usefull) {
		ixwd.brief.disp = bd->e_xvalue;
		outb (ixwd.word>>8);		/* install index byte */
		mode |= TYPB;
		outrel (bd, mode);	/* disp byte */
	} else {
		bdisp = bd->e_xvalue;
		if (mode == RELOC_PCREL)
			bdisp -= dotp->e_xvalue & ~1;
		if ((bd->e_xtype & XTYPE) != XABS ||
		    bd->e_xtype & XFORW ||
		    ap->a_bsize != 0) {
			if (mode == RELOC_PCREL) {
				/* take extn. word emitted before */
				/* outrel() call into account */
				bd->e_xvalue += 2;
			}
			if (ap->a_bsize == 2) {
				ixwd.full.bdsize = 02;
				mode |= TYPW;
			} else {
				ixwd.full.bdsize = 03;
				mode |= TYPL;
			}
		} else if (bdisp == 0) {
			ixwd.full.bdsize = 01;
		} else if ((short)bdisp == bdisp) {
			ixwd.full.bdsize = 02;
			mode |= TYPW;
		} else {
			ixwd.full.bdsize = 03;
			mode |= TYPL;
		}
		if (od != NULL) {
			odisp = od->e_xvalue;
			if ((od->e_xtype & XTYPE) != XABS ||
			    od->e_xtype & XFORW ||
			    ap->a_osize != 0) {
				if (ap->a_osize == 2) {
					ixwd.full.ixsel = 02;
					omode |= TYPW;
				} else {
					ixwd.full.ixsel = 03;
					omode |= TYPL;
				}
			} else if (odisp == 0) {
				ixwd.full.ixsel = 01;
			} else if ((short)odisp == odisp) {
				ixwd.full.ixsel = 02;
				omode |= TYPW;
			} else {
				ixwd.full.ixsel = 03;
				omode |= TYPL;
			}
			if ((amode == M_POSTX || amode == M_PCPOSTX) &&
			    ! ixwd.full.isupp)
				ixwd.full.ixsel |= 04;
		}
		outw (ixwd.word);		/* install index word */
		if (ixwd.full.bdsize >= 2)
			outrel (bd, mode);	/* base disp word(s) */
		if (od != NULL && (ixwd.full.ixsel & ~04) >= 2)
			outrel (od, omode);	/* outer disp word(s) */
		if (!for68020)
			yywarning("68020 addressing mode used/required");
	}
}

eaddr (op, ap)
  register short op;
  struct arg *ap;
{
	op |= modereg(ap,0);
	outw (op);

	if (addrmode >= 5)
		addrwds(ap);
}

imm_eaddr (op, ap_imm, ap)
  register short op;
  register struct arg *ap_imm;
  struct arg *ap;
{
	register short imode;

	op |= modereg(ap, 0);
	outw (op);

	imode = type_124[ap_imm->a_xsize];
	if (imode == TYPB)
		outb (0);
	outrel (ap_imm->a_xp, imode);

	if (addrmode >= 5)
		addrwds(ap);
}

w_eaddr (op, w, ap)
  register short op;
  register int w;
  struct arg *ap;
{

	op |= modereg(ap, 0);
	outw (op);

	outw (w);

	if (addrmode >= 5)
		addrwds(ap);
}

eaddr_eaddr (op, ap)
  register short op;
  struct arg *ap;
{
	register short addrmode1;
	register struct arg *ap2 = ap + 1;

	op |= modereg(ap, 0);
	addrmode1 = addrmode;		/* save for use below */

	op |= modereg(ap2, 1);

	outw (op);

	if (addrmode1 >= 5)
		addrwds(ap);

	if (addrmode >= 5)
		addrwds(ap2);

}


/* Fxxx <ea>,fn ops */
fp0_ea_f7 (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68881 instruction used");
	} else
		w_eaddr (0xF200, op | (((ap+1)->a_areg1 & 07) << 7), ap);
}

/* Fxxx fm,fn ops */
fp0_f10_f7 (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2;
		if (!for68020)
			yywarning("68881 instruction used");
	} else {
		outw (0xF200);
		op |= ((ap->a_areg1 & 07) << 10) |
			(((ap+1)->a_areg1 & 07) << 7);
		outw (op);
	}
}

/* FMOV fn,<ea> */
fp0_f7_ea (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap + 1);
		if (!for68020)
			yywarning("68881 instruction used");
	} else
		w_eaddr (0xF200, op | ((ap->a_areg1 & 07) << 7), ap + 1);
}

/* FMOVL <ea>,<cntlregs> */
/* FTST <ea> */
fp0_ea (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68881 instruction used");
	} else
		w_eaddr (0xF200, op, ap);
}

/* FMOVL <cntlregs>,<ea> */
fp0_ea2 (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap + 1);
		if (!for68020)
			yywarning("68881 instruction used");
	} else
		w_eaddr (0xF200, op, ap + 1);
}

/* FTST fm */
fp0_f10 (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68881 instruction used");
	} else {
		outw (0xF200);
		op |= ((ap->a_areg1 & 07) << 10);
		outw (op);
	}
}

/* FMOVP fn,<ea> */
fp0_movp_ea (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap + 1);
		if (!for68020)
			yywarning("68881 instruction used");
	} else {
		register struct arg *rp = ap + 1;
		register unsigned short rop;

		rop = op | ((ap->a_areg1 & 07) << 7);

		if (!rp->a_haskfac) {
			yyerror("missing k-factor");
		}
		if (rp->a_bforeg) {
			/* dynamic k-factor (in Dreg) */
			rop |= rp->a_bfoff << 4;
			rop |= 0x1000;
		} else {
			/* static k-factor */
			rop |= rp->a_bfoff & 0x7F;
		}

		w_eaddr (0xF200, rop, rp);
	}
}

/* FMOVCR #n,fn */
fp0_imm_f7 (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2;
		if (!for68020)
			yywarning("68881 instruction used");
		if (ap->a_xp->e_xvalue < 0)
			yyerror("negative fmovecr constant");
	} else {
		outw (0xF200);
		op |= (((ap+1)->a_areg1 & 07) << 7) |
			(ap->a_xp->e_xvalue & 0x7f);
		outw (op);
	}
}

/* FMOVEMX <freglist>,<ea> */
fp0_flist_ea (op, ap)
short op;
register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap + 1);
		if (!for68020)
			yywarning("68881 instruction used");
		if (ap->a_atype == REGLIST &&
		    (ap->a_areg1 < 16 || ap->a_areg1 > 23))
			yyerror("Invalid register list for fmovemx.");
	} else {
		register unsigned mask;
		if (ap->a_atype == REGLIST && (ap+1)->a_atype != DEC) {
			register int i;
			register unsigned val;

			/* reglist has been build backward, */
			/* so need to flip: b0->b7, b1->b6, ... */
			mask = 0;
			val = ap->a_xp->e_xvalue;
			for (i = 8; i > 0; i--) {
				mask <<= 1;
				if (val & 1)
					mask++;
				val >>= 1;
			}
		} else
			mask = ap->a_xp->e_xvalue & 0xFF;
		w_eaddr (0xF200, op | mask, ap + 1);
	}
}

/* FMOVEMX <ea>,<freglist> */
fp0_ea_flist (op, ap)
short op;
struct arg *ap;
{
	register struct arg *ap1 = ap + 1;

	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68881 instruction used");
		if (ap1->a_atype == REGLIST &&
		    (ap1->a_areg1 < 16 || ap1->a_areg1 > 23))
			yyerror("Invalid register list for fmovemx.");
	} else {
		register unsigned mask;
		if (ap1->a_atype == REGLIST) {
			register int i;
			register unsigned val;

			/* reglist has been build backward, */
			/* so need to flip: b0->b7, b1->b6, ... */
			mask = 0;
			val = ap1->a_xp->e_xvalue;
			for (i = 8; i > 0; i--) {
				mask <<= 1;
				if (val & 1)
					mask++;
				val >>= 1;
			}
		} else
			mask = ap1->a_xp->e_xvalue & 0xFF;
		w_eaddr (0xF200, op | mask, ap);
	}
}

/* FMOVEMX dn,<ea> */
fp0_r4_ea (op, ap)
short op;
register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap + 1);
		if (!for68020)
			yywarning("68881 instruction used");
	} else {
		w_eaddr (0xF200, op | (ap->a_areg1 << 4), ap + 1);
	}
}

/* FMOVEMX <ea>,dn */
fp0_ea_r4 (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68881 instruction used");
	} else {
		w_eaddr (0xF200, op | ((ap+1)->a_areg1 << 4), ap);
	}
}

/* FMOVEML <creglist>,<ea> */
fp0_clist_ea (op, ap)
short op;
register struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap + 1);
		if (!for68020)
			yywarning("68881 instruction used");
		if (ap->a_atype == REGLIST &&
		    (ap->a_areg1 < R_FPIAR || ap->a_areg1 > R_FPCR))
			yyerror("Invalid register list for fmoveml.");
	} else {
		w_eaddr (0xF200, op | ((ap->a_xp->e_xvalue & 07) << 10),
			ap + 1);
	}
}

/* FMOVEML <ea>,<creglist> */
fp0_ea_clist (op, ap)
short op;
struct arg *ap;
{
	register struct arg *ap1;

	ap1 = ap + 1;
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68881 instruction used");
		if (ap1->a_atype == REGLIST &&
		    (ap1->a_areg1 < R_FPIAR || ap1->a_areg1 > R_FPCR))
			yyerror("Invalid register list for fmoveml.");
	} else {
		w_eaddr (0xF200, op | ((ap1->a_xp->e_xvalue & 07) << 10),
			ap);
	}
}

/* FSINCOS <ea>,fn:fq ops */
fp0_ea_fpair (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68881 instruction used");
	} else
		w_eaddr (0xF200, op | (((ap+1)->a_areg2 & 07) << 7) |
				((ap+1)->a_areg1 & 07), ap);
}

/* FSINCOS fm,fn:fq ops */
fp0_f10_fpair (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2)
		dotp->e_xvalue += 2;
		if (!for68020)
			yywarning("68881 instruction used");
	else {
		outw (0xF200);
		op |= ((ap->a_areg1 & 07) << 10) |
			(((ap+1)->a_areg2 & 07) << 7) | ((ap+1)->a_areg1 & 07);
		outw (op);
	}
}

/* FSxx ops */
fp1_ea (cond, ap)
short cond;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68881 instruction used");
	} else
		w_eaddr (0xF240, cond, ap);
}

/* FDBxx dn,<label> ops */
fp1_r0_disp16 (cond, ap)
short cond;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 4;
		if (!for68020)
			yywarning("68881 instruction used");
	} else {
		register short rop = 0xF248 | (ap->a_areg1 & 7);
		outw (rop);
		outw (cond);
		ap++;
		if ((ap->a_xp->e_xtype & ~(XFORW|XXTRN)) == XUNDEF)
			yyerror("floating decr&branch to undefined label");
		outrel (ap->a_xp, TYPW | RELOC_LABEL);
	}
}

/* FTPxx ops */
fp1_trap (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2;
		if (!for68020)
			yywarning("68881 instruction used");
	} else {
		outw (0xF27C);
		outw (op);
	}
}

/* FTPxxW #<word> ops */
fp1_trapw (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 4;
	} else {
		outw (0xF27A);
		outw (op);
		outrel (ap->a_xp, TYPW);
	}
}

/* FTPxxL #<lword> ops */
fp1_trapl (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 6;
		if (!for68020)
			yywarning("68881 instruction used");
	} else {
		outw (0xF27B);
		outw (op);
		outrel (ap->a_xp, TYPL);
	}
}

/* FBxxW ops */
fp_disp16 (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2;
		if (!for68020)
			yywarning("68881 instruction used");
	} else {
		if ((ap->a_xp->e_xtype & ~(XFORW|XXTRN)) == XUNDEF)
			yyerror("floating branch to undefined label");
		outw (op);
		outrel (ap->a_xp, TYPW | RELOC_LABEL);
	}
}

/* FBxxL ops */
fp_disp32 (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 4;
		if (!for68020)
			yywarning("68881 instruction used");
	} else {
		if ((ap->a_xp->e_xtype & ~(XFORW|XXTRN)) == XUNDEF)
			yyerror("floating branch to undefined label");
		outw (op);
		outrel (ap->a_xp, TYPL | RELOC_LABEL);
	}
}

/* FNOP */
fp2_nop (op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2;
		if (!for68020)
			yywarning("68881 instruction used");
	} else {
		outw (op);
		outw (0);
	}
}

/* 68030 PMMU ops */
pmmu(op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2;
		if (!for68020)
			yywarning("68030 instruction used");
	} else {
		outw (0xF000);
		outw (op);
	}
}

pmmu_msk(op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2;
		if (!for68020)
			yywarning("68030 instruction used");
	} else {
		outw (0xF000);
		op |= ((ap+1)->a_xp->e_xvalue & 07) << 5;
		outw (op);
	}
}

pmmu_fcmsk(op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2;
		if (!for68020)
			yywarning("68030 instruction used");
	} else {
		outw (0xF000);
		if (ap->a_atype == DREG)
			op |= (ap->a_areg1 & 07);
		else
			op |= (ap->a_xp->e_xvalue & 07);
		op |= ((ap+1)->a_xp->e_xvalue & 07) << 5;
		outw (op);
	}
}

pmmu_msk_ea(op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap+2);
		if (!for68020)
			yywarning("68030 instruction used");
	} else {
		w_eaddr (0xF000, op | ((ap+1)->a_xp->e_xvalue & 07) << 5, ap+2);
	}
}

pmmu_fcmsk_ea(op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap+2);
		if (!for68020)
			yywarning("68030 instruction used");
	} else {
		if (ap->a_atype == DREG)
			op |= (ap->a_areg1 & 07);
		else
			op |= (ap->a_xp->e_xvalue & 07);
		op |= ((ap+1)->a_xp->e_xvalue & 07) << 5;
		w_eaddr (0xF000, op, ap+2);
	}
}

pmmu_ea1(op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap);
		if (!for68020)
			yywarning("68030 instruction used");
	} else {
		w_eaddr (0xF000, op, ap);
	}
}

pmmu_ea2(op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap+1);
		if (!for68020)
			yywarning("68030 instruction used");
	} else {
		w_eaddr (0xF000, op, ap+1);
	}
}

pmmu_fc_ea(op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap+1);
		if (!for68020)
			yywarning("68030 instruction used");
	} else {
		if (ap->a_atype == DREG)
			op |= (ap->a_areg1 & 07);
		else
			op |= (ap->a_xp->e_xvalue & 07);
		w_eaddr (0xF000, op, ap+1);
	}
}

pmmu_ea_r(op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap+1);
		if (!for68020)
			yywarning("68030 instruction used");
	} else {
		op |= ((ap+2)->a_areg1 & 07) << 5;
		w_eaddr (0xF000, op, ap+1);
	}
}

pmmu_fc_ea_r(op, ap)
short op;
struct arg *ap;
{
	if (passno != 2) {
		dotp->e_xvalue += 2 + easize (ap+1);
		if (!for68020)
			yywarning("68030 instruction used");
	} else {
		if (ap->a_atype == DREG)
			op |= (ap->a_areg1 & 07);
		else
			op |= (ap->a_xp->e_xvalue & 07);
		op |= ((ap+2)->a_areg1 & 07) << 5;
		w_eaddr (0xF000, op, ap+1);
	}
}
