static	char sccsid[] = "@(#)setup.c	4.10 (Berkeley) 85/05/09";
/*
 * adb - routines to read a.out+core at startup
 */
#include "defs.h"
#include <frame.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/file.h>
#ifdef vax
#include <vax/rpb.h>
#endif vax
#ifdef	VQX
#include <machine/board.h>
#endif	VQX

off_t	datbas;			/* offset of the base of the data segment */
off_t	stksiz;			/* stack size in the core image */
INT	sigcode;	/* belongs in head.h */

char	*symfil	= "a.out";
char	*corfil	= "core";

#ifdef is68k

extern int hiwater;     /* current stack hi water mark */ 
L_INT	entrypt;	/* entry point to a.out file */

#define OMAG_TEXTOFF 0x20
#define BASE_DATA_SEGMENT (1L << 17)  /* data base in core */   
ADDR	usersp;

#ifdef	VQX
extern int fvmcore;
#endif	VQX

#endif is68k

setsym()
{
	off_t loc;
	struct exec hdr;
	register struct nlist *sp;
	int ssiz;
	char *strtab;

	fsym = getfile(symfil, 1);
	txtmap.ufd = fsym;
	if (read(fsym, (char *)&hdr, sizeof hdr) != sizeof hdr ||
	    N_BADMAG(hdr)) {
		txtmap.e1 = MAXFILE;
		return;
	}
	filhdr = hdr;
	loc = filhdr.a_text+filhdr.a_data;
	txtmap.f1 = txtmap.f2 = N_TXTOFF(filhdr);
#ifdef is68k
#ifdef VQX
#define PHTOKV(x)	(x - PHYSMEMBASE + SYSV_BASE)
	/* VQX prom requires phys addr entry point in kernel image */
	if (kernel)
	    filhdr.a_entry = PHTOKV(filhdr.a_entry);
#endif VQX
	txtmap.b1 = entrypt = filhdr.a_entry;
#else
	txtmap.b1 = 0;
#endif is68k
	switch (filhdr.a_magic) {

	case OMAGIC:
#ifdef is68k
		txtmap.b1 = txtmap.b2 = 0;
		txtmap.e1 = txtmap.e2 = loc;
#else
		txtmap.b1 = txtmap.e1 = 0;
		txtmap.b2 = datbas = 0;
		txtmap.e2 = loc;
#endif is68k
		break;

	case ZMAGIC:
	case NMAGIC:
#ifdef is68k
		txtmap.e1 = filhdr.a_text;
		txtmap.b2 = datbas = upround(filhdr.a_text, PAGSIZ);
		txtmap.e2 = datbas + filhdr.a_data;
		txtmap.f2 += txtmap.e1;
#else
		txtmap.e1 = filhdr.a_text;
		txtmap.b2 = datbas = round(filhdr.a_text, PAGSIZ);
		txtmap.e2 = datbas + filhdr.a_data;
		txtmap.f2 += txtmap.e1;
#endif is68k
	}
	loc = N_SYMOFF(filhdr);
	symtab = (struct nlist *) malloc(filhdr.a_syms);
	esymtab = &symtab[filhdr.a_syms / sizeof (struct nlist)];
	if (symtab == NULL)
		goto nospac;
#ifdef is68k
	lseek(fsym, loc, 0);
#else
	lseek(fsym, loc, L_SET);
#endif is68k
	if (filhdr.a_syms == 0)
		goto nosymt;
	/* SHOULD SQUISH OUT STABS HERE!!! */
	if (read(fsym, symtab, filhdr.a_syms) != filhdr.a_syms)
		goto readerr;
	if (read(fsym, &ssiz, sizeof (ssiz)) != sizeof (ssiz))
		goto oldfmt;
	strtab = (char *) malloc(ssiz);
	if (strtab == 0)
		goto nospac;
	*(int *)strtab = ssiz;
	ssiz -= sizeof (ssiz);
	if (read(fsym, strtab + sizeof (ssiz), ssiz) != ssiz)
		goto readerr;
	for (sp = symtab; sp < esymtab; sp++)
		if (sp->n_strx)
			/* SHOULD PERFORM RANGE CHECK HERE */
			sp->n_un.n_name = strtab + sp->n_un.n_strx;
#ifdef is68k
	init_das(symfil);	/* read in standalone disassembler sym table */
#ifdef VQX
	if (kernel)
	    filhdr.a_entry = PHTOKV(filhdr.a_entry); /* restore entry pt.*/
#endif VQX
#endif is68k
nosymt:
#ifndef is68k
	if (INKERNEL(filhdr.a_entry)) {
		txtmap.b1 += KERNOFF;
		txtmap.e1 += KERNOFF;
		txtmap.b2 += KERNOFF;
		txtmap.e2 += KERNOFF;
	}
#endif is68k
	return;
readerr:
	printf("Error reading symbol|string table\n");
	exit(1);
nospac:
	printf("Not enough space for symbol|string table\n");
	exit(1);
oldfmt:
	printf("Old format a.out - no string table\n");
	exit(1);
}

setcor()
{
#ifdef	is68k
	struct pte masterpaddr;
#endif	is68k

	fcor = datmap.ufd = getfile(corfil,2);
	if (kernel && fcor != -1 && INKERNEL(filhdr.a_entry)) {
		struct stat stb;

		kcore = 1;
		fstat(fcor, &stb);
		datmap.b1 = 0;
		datmap.e1 = -1;
#ifndef VQX
#ifdef notdef
		if (kernel == 0 && (stb.st_mode & S_IFREG))
			datmap.b1 = 0x80000000;
#endif notdef
#endif
		lookup("_Sysmap");
		sbr = cursym->n_value;
		lookup("_Syssize");
		slr = cursym->n_value;
#ifdef	is68k
		printf("sbr %X slr %X\n", sbr, slr);
#else	is68k
		printf("sbr %x slr %x\n", sbr, slr);
#endif	is68k
		lookup("_masterpaddr");
#ifdef VQX
		if (fvmcore)
		    physrw(fcor, KVTOPHOFF(cursym->n_value), &masterpcbb, 1);
		else
		    physrw(fcor, KVTOPH(cursym->n_value), &masterpcbb, 1);
		if (fvmcore)
		    masterpcbb = (masterpcbb&PG_PFNUM) - PHYSMEMBASE;
		else
		    masterpcbb = masterpcbb&PG_PFNUM;
#else	VQX	
#ifdef	is68k
		physrw(fcor, KVTOPH(cursym->n_value), &masterpaddr, 1);
		masterpcbb = (masterpaddr.pg_pfnum)*NBPG;
#else	is68k
		physrw(fcor, KVTOPH(cursym->n_value), &masterpcbb, 1);
		masterpcbb = (masterpcbb&PG_PFNUM)*NBPG;
#endif	is68k
#endif	VQX
		getpcb();
#ifdef	vax
		findstackframe();
#endif	vax
		return;
	}
	if (read(fcor, (char *)&u, ctob(UPAGES))!=ctob(UPAGES)
#ifdef vax
	   || !INUDOT(u.u_pcb.pcb_ksp) || !INSTACK(u.u_pcb.pcb_usp)
#endif vax
	    ) {
		datmap.e1 = MAXFILE;
		return;
	}
#ifdef is68k
	*((ADDR *)&u.u_ar0) &= (UPAGES*NBPG - 1);
#endif is68k
	signo = u.u_arg[0];
	sigcode = u.u_code;
	filhdr.a_text = ctob(u.u_tsize);
	filhdr.a_data = ctob(u.u_dsize);
	stksiz = ctob(u.u_ssize);
	switch (filhdr.a_magic) {

	case OMAGIC:
		datmap.b1 = 0;
		datmap.e1 = filhdr.a_text+filhdr.a_data;
		datmap.f2 = ctob(UPAGES) + datmap.e1;
#ifdef	is68k
					/* for alternate text load pts */
		datmap.f1 = (entrypt? entrypt: ctob(UPAGES));
#endif	is68k
		break;

	case NMAGIC:
	case ZMAGIC:
#ifdef is68k
		datmap.b1 = upround(filhdr.a_text, BASE_DATA_SEGMENT);
		datmap.f1 = ctob(UPAGES);
#else
		datmap.b1 = round(filhdr.a_text, PAGSIZ);
#endif is68k
		datmap.e1 = datmap.b1 + filhdr.a_data;
		datmap.f2 = ctob(UPAGES) + filhdr.a_data;
		break;
	}
	datbas = datmap.b1;
#ifdef is68k
 	usersp= *(ADDR *)(((ADDR)&u)+(ADDR)&u.u_ar0[SP]);

/* setup stack for all IS68k bus and cpu types */
	datmap.b2 = hiwater - stksiz; 
	datmap.e2 = hiwater;

	if (!INKERNEL(filhdr.a_entry)) 
          core_exec_match();		/* compare a.out name w/core name */
#else
	datmap.f1 = ctob(UPAGES);
	datmap.b2 = MAXSTOR - stksiz;
	datmap.e2 = MAXSTOR;
#endif is68k
}

#ifdef	is68k

off_t
mkphys(addr)
	off_t addr;
{
	register off_t o;
 	struct pte pte;

#ifdef VQX
	if (addr == 0) return (addr);	/* KLUGE: make vaddr0==paddr0*/
	o = addr & PGOFSET;
	addr -= SYSV_BASE;
	addr >>= PGSHIFT;
	addr *=  NBPW;
	addr = lookup("_Sysmap")->n_value + addr;
	if (fvmcore)
	    physrw(fcor, KVTOPHOFF((long) addr), &addr, 1);
	else
	    physrw(fcor, KVTOPH((long) addr), &addr, 1);
	if (fvmcore)
	    addr = ((addr & PG_PFNUM) | o) - PHYSMEMBASE;
	else
	    addr = (addr & PG_PFNUM) | o;
	return(addr);
#else	VQX
	addr = KVTOPH(addr);
	o = addr & PGOFSET;
	addr >>= PGSHIFT;
	addr *=  NBPW;
	addr = lookup("_Sysmap")->n_value + addr;
	physrw(fcor, KVTOPH((long) addr), &pte, 1);
	addr = (pte.pg_pfnum << PGSHIFT) | o;
	return(addr);
#endif	VQX
}

getpcb()
{
	char *panicstr, buf[256];
	register char *cp;
	struct pte *pteaddr, apte;
	struct pte uptes[UPAGES];
	register struct pte *Usrptmap;
	register struct	pte *usrpt;
	register int i;

#ifdef VQX
	lseek(fcor, masterpcbb, L_SET);
#else VQX
	lseek(fcor, KVTOPH(masterpcbb), L_SET);
#endif VQX
	if (read(fcor, (char *)&u, sizeof(struct user))!=sizeof(struct user)) {
		printf("can't read u area\n");
		return;
	}
	pcb = u.u_pcb;

	usrpt = (struct pte *)lookup("_usrpt")->n_value;
	Usrptmap = (struct pte *)lookup("_Usrptmap")->n_value;
	pteaddr = &Usrptmap[btokmx(pcb.pcb_p0br) + pcb.pcb_szpt -1];
	lseek(fcor, mkphys((int)pteaddr), L_SET);
	if (read(fcor, (char *)&apte, sizeof(apte)) != sizeof(apte)) {
		printf("can't read indir pte to get u\n");
		return;
	}
#ifdef	VQX
	if (fvmcore)
	    lseek(fcor, (long)ctob(pftondx(apte.pg_pfnum+1))-
			(UPAGES)*sizeof (struct pte), L_SET);
	else
#endif	VQX
	lseek(fcor, (long)ctob(apte.pg_pfnum+1)-(UPAGES)*sizeof (struct pte), 
								L_SET);
	if (read(fcor, (char *)uptes, sizeof(uptes)) != sizeof(uptes)) {
		printf("can't read page table for u\n");
		return;
	}
#ifdef	VQX
	if (fvmcore)
	    masterpcbb += PHYSMEMBASE;
#endif	VQX
	if (uptes[0].pg_pfnum != masterpcbb/NBPG) {
		printf("could not find pte's for whole uarea\n");
		return;
	}
	for (i = 0 ; i < UPAGES ; i++) {
#ifdef	VQX
	    if (fvmcore)
		lseek(fcor, (long)ctob(pftondx(uptes[i].pg_pfnum)), L_SET);
	    else
#endif	VQX
		lseek(fcor, (long)ctob(uptes[i].pg_pfnum), L_SET);
		if (read(fcor, udot.upages[i], CLSIZE*NBPG) != CLSIZE*NBPG) {
		    printf("cant read page %d of u\n", uptes[i].pg_pfnum);
		    return;
		}
	}

	printf("%s: ", u.u_comm);
	printf("p0br %X p0lr %X p1br %X p1lr %X\n",
	    pcb.pcb_p0br, pcb.pcb_p0lr, pcb.pcb_p1br, pcb.pcb_p1lr);

	lookup("_u");
	ustart = cursym->n_value;
	ustack = cursym->n_value + (int)&((struct user *)0)->u_stack[0];
	eustack = cursym->n_value + ctob(UPAGES);

	if (lookup("_panicstr") == 0)
		return;
#ifdef	VQX
	if (fvmcore)
	    lseek(fcor, KVTOPHOFF(cursym->n_value), L_SET);
	else
#endif
	lseek(fcor, KVTOPH(cursym->n_value), L_SET);
	read(fcor, &panicstr, sizeof (panicstr));
	if (panicstr == 0)
		return;
#ifdef	VQX
	if (fvmcore)
	    lseek(fcor, KVTOPHOFF((off_t)panicstr), L_SET);
	else
#endif
	lseek(fcor, KVTOPH((off_t)panicstr), L_SET);
	read(fcor, buf, sizeof (buf));
	for (cp = buf; cp < &buf[sizeof (buf)] && *cp; cp++)
		if (!isascii(*cp) || (!isprint(*cp) && !isspace(*cp)))
			*cp = '?';
	if (*cp)
		*cp = '\0';
	printf("panic: %s\n", buf);
}

#else is68k

getpcb()
{

	lseek(fcor, KVTOPH(masterpcbb), L_SET);
	read(fcor, &pcb, sizeof (struct pcb));
	pcb.pcb_p0lr &= ~AST_CLR;
	printf("p0br %x p0lr %x p1br %x p1lr %x\n",
	    pcb.pcb_p0br, pcb.pcb_p0lr, pcb.pcb_p1br, pcb.pcb_p1lr);
}


caddr_t	rpb, scb;
caddr_t	intstack, eintstack;
caddr_t	ustack, eustack;
struct	frame *getframe();
struct	frame *checkintstack();

/*
 * Find the current stack frame when debugging the kernel.
 * If we're looking at a crash dump and this was not a ``clean''
 * crash, then we must search the interrupt stack carefully
 * looking for a valid frame.
 */
findstackframe()
{
	char *panicstr, buf[256];
	register struct frame *fp;
	caddr_t addr;
	register char *cp;
	int mask;

	if (lookup("_panicstr") == 0)
		return;
	lseek(fcor, KVTOPH(cursym->n_value), L_SET);
	read(fcor, &panicstr, sizeof (panicstr));
	if (panicstr == 0)
		return;
	lseek(fcor, KVTOPH((off_t)panicstr), L_SET);
	read(fcor, buf, sizeof (buf));
	for (cp = buf; cp < &buf[sizeof (buf)] && *cp; cp++)
		if (!isascii(*cp) || (!isprint(*cp) && !isspace(*cp)))
			*cp = '?';
	if (*cp)
		*cp = '\0';
	printf("panic: %s\n", buf);
	/*
	 * After a panic, look at the top of the rpb stack to
	 * find a stack frame.  If this was a clean crash,
	 * i.e. one which left the interrupt and kernel stacks
	 * in a reasonable state, then we should find a pointer
	 * to the proper stack frame here (at location scb-4).
	 * If we don't find a reasonable frame here, then we
	 * must search down through the interrupt stack.
	 */
	intstack = lookup("_intstack")->n_value;
#define	NISP	3			/* from locore.s */
	eintstack = intstack + NISP*NBPG;
	rpb = lookup("_rpb")->n_value;
	scb = lookup("_scb")->n_value;
	lookup("_u");
	ustack = cursym->n_value + (int)&((struct user *)0)->u_stack[0];
	eustack = cursym->n_value + ctob(UPAGES);
	physrw(fcor, KVTOPH((int)scb - sizeof (caddr_t)), &addr, 1);
	fp = getframe(fcor, addr);
	if (fp == 0)
		fp = checkintstack();
	/* search kernel stack? */
	if (fp == 0) {
		printf("can't locate stack frame\n");
		return;
	}
	/* probably shouldn't clobber pcb, but for now this is easy */
	pcb.pcb_fp = addr;
	pcb.pcb_pc = fp->fr_savpc;
	pcb.pcb_ap = addr + sizeof (struct frame) + fp->fr_spa;
	for (mask = fp->fr_mask; mask; mask >>= 1)
		if (mask & 01)
			pcb.pcb_ap += sizeof (caddr_t);
}

/*
 * Search interrupt stack for a valid frame.
 */
struct frame *
checkintstack(fcor)
{
	char stack[NISP*NBPG];
	off_t off = vtophys(intstack);
	struct frame *fp;
	register caddr_t addr;

	if (off == -1 || lseek(fcor, off, L_SET) != off ||
	    read(fcor, stack, sizeof (stack)) != sizeof (stack))
		return ((struct frame *)0);
	addr = eintstack;
	do {
		addr -= sizeof (caddr_t);
		fp = (struct frame *)&stack[addr - intstack];
	} while (addr >= intstack + sizeof (struct frame) &&
	    !checkframe(fp));
	return (addr < intstack+sizeof (struct frame) ? (struct frame *)0 : fp);
}

/*
 * Get a stack frame and verify it looks like
 * something which might be on a kernel stack.
 */
struct frame *
getframe(fcor, fp)
	int fcor;
	caddr_t fp;
{
	static struct frame frame;
	off_t off;

	if (!kstackaddr(fp) || (off = vtophys(fp)) == -1)
		return ((struct frame *)0);
	if (lseek(fcor, off, L_SET) != off ||
	    read(fcor, &frame, sizeof (frame)) != sizeof (frame))
		return ((struct frame *)0);
	if (!checkframe(&frame))
		return ((struct frame *)0);
	return (&frame);
}

/*
 * Check a call frame to see if it's ok as
 * a kernel stack frame.
 */
checkframe(fp)
	register struct frame *fp;
{
	if (fp->fr_handler != 0 || fp->fr_s == 0)
		return (0);
	if (!kstackaddr(fp->fr_savap) || !kstackaddr(fp->fr_savfp))
		return (0);
	if (!kstackaddr(fp->fr_savfp))
		return (0);
	return (within(fp->fr_savpc, txtmap.b1, txtmap.e1));
}

/*
 * Check if an address is in one of the kernel's stacks:
 * interrupt stack, rpb stack (during restart sequence),
 * or u. stack.
 */
kstackaddr(addr)
	caddr_t addr;
{

	return (within(addr, intstack, eintstack) ||
	    within(addr, rpb + sizeof (struct rpb), scb) ||
	    within(addr, ustack, eustack));
}

#endif	is68k

create(f)
	char *f;
{
	register int fd;

	fd = creat(f, 0644);
	if (fd < 0)
		return (-1);
	close(fd);
	return (open(f, wtflag));
}

getfile(filnam, cnt)
	char *filnam;
{
	register int fsym;

	if (eqstr(filnam, "-"))
		return (-1);
	fsym = open(filnam, wtflag);
	if (fsym < 0 && xargc > cnt) {
		if (wtflag)
			fsym = create(filnam);
		if (fsym < 0)
			printf("cannot open `%s'\n", filnam);
	}
	return (fsym);
}

setvar()
{

	var[varchk('b')] = datbas;
	var[varchk('d')] = filhdr.a_data;
	var[varchk('e')] = filhdr.a_entry;
	var[varchk('m')] = filhdr.a_magic;
	var[varchk('s')] = stksiz;
	var[varchk('t')] = filhdr.a_text;
}

/* Attempt to determine if the core file belongs to the binary file
   being debugged
*/
core_exec_match()
{
	if ((filhdr.a_magic==ZMAGIC) && (u.u_magic==ZMAGIC) &&
	   (!strcmp(symfil,&u.u_comm)))
		return;
	
	if ((filhdr.a_magic == OMAGIC) && (filhdr.a_magic == u.u_magic))
	        return;		/* harder to I.D. OMAGIC files */
	   
	printf("Corefile probably not from this program\n");
}
