/*	machine.h	4.1	81/05/14	*/

#include <sys/vm.h>

#define	PAGSIZ		(NBPG*CLSIZE)

#define DBNAME "adb\n"
#define LPRMODE "%R"
#define OFFMODE "+%R"

#ifdef vax
#define	TXTRNDSIZ	PAGSIZ
#else
/* IS68k */
#define	TXTRNDSIZ	(PAGSIZ*(stoc(ctos(1))))
#endif

#define	MAXINT	0x7fffffff
#ifdef vax
#define	MAXSTOR ((1L<<31) - ctob(UPAGES))
#endif

#define	MAXFILE 0xffffffff
/*
 * INSTACK tells whether its argument is a stack address.
 * INUDOT tells whether its argument is in the (extended) u. area.
 * These are used for consistency checking and dont have to be exact.
 *
 * INKERNEL tells whether its argument is a kernel space address.
 * KVTOPH trims a kernel virtual address back to its offset
 * in the kernel address space.
 */
#ifdef kernel_decode
#define	INSTACK(x)	(((x)&0xf0000000) == 0x70000000)
#else
#define	INSTACK(x)	(1)		/* NEEDED for Stack Backtrace */
#endif kernel_decode

#ifdef is68k
#ifdef VQX
/* KVTOPH translates kernel virtual address to physical address. 
 * KVTOPHOFF translates to offset in kernel address space.
 */
#define	KVTOPH(x)	((x) - SYSV_BASE + PHYSMEMBASE)
#define	KVTOPHOFF(x)	((x) - SYSV_BASE)
#define	INKERNEL(x)	(((x)&0xe0000000) == 0x40000000)
#define ptetob(p)	(((struct pte)(p)).pg_pfnum * NBPG)
#else VQX
#define	INKERNEL(x)	((unsigned long)(x) >= (unsigned long)hiwater)
#define	KVTOPH(x)	((x)& ~0xf0000000)
#endif VQX
#else is68k
#define	INUDOT(x)	(((x)&0xf0000000) == 0x70000000)
#define	INKERNEL(x)	(((x)&0xf0000000) == 0x80000000)
#define	KVTOPH(x)	((x)&~ 0x80000000)
#define	KERNOFF		0x80000000
#endif is68k
