#include "param.h"
#include "mbuf.h"
#include "user.h"
#include "kernel.h"
#include "buf.h"
#include "proc.h"
#include "file.h"
#include "vnode.h"

#include "../netinet/in.h"

#include "../wipc/wipc.h"
#include "../wipc/wipc_packet.h"
#include "../wipc/wipc_pklink.h"

/*
 * CALLED AT INTERRUPT TIME!
 */
ReceivePacket(lp)
register struct pklink *lp;
{
	register int pid;
	register struct proc *p;
	register int n;

	if ((n = InterruptReceive(lp)) == 0) {
		pid = rpid_pid(lp->packet.dst);
		p = (pid == 0) ? &proc[0] : pfind(pid);
		if (p == (struct proc *)0  ||  p->p_pid != pid  ||
		    p->p_stat == SZOMB)
			n = ESRCH;
		else
			n = EnqueuePacket(lp, &p->p_trecq, &p->p_trepq);
		if (n)
			SendNack(lp, n);
	}
	return n;
}

/*
 * Don't try using this to forward to a process on another machine!
 */
ForwardPacket(wp, rpid)
struct packet *wp;
unsigned long rpid;
{
	register struct proc *p;
	register struct pklink *lp = (struct pklink *)(wp + 1) - 1;
	register int pid, n;

	if (MID(rpid) != SELF_MID) {
		SendNack(lp, EINVAL);
		return EINVAL;
	}
	pid = PID(rpid);
	p = (pid == 0) ? &proc[0] : pfind(pid);
	if (p == (struct proc *)0  ||  p->p_pid != pid  ||
	    p->p_stat == SZOMB)
		n = ESRCH;
	else
		n = EnqueuePacket(lp, &p->p_trecq, &p->p_trepq);
	if (n)
		SendNack(lp, n);
	return n;
}

FreePackets()
{
	DequeuePackets(&u.u_procp->p_trecq);
	DequeuePackets(&u.u_procp->p_trepq);
}


my_pid()
{
	extern int server_pid;

	if (u.u_procp->p_pid == server_pid)
		return SERVER_PID;
	return u.u_procp->p_pid;
}

struct pklink **
my_recq()
{
	return &u.u_procp->p_trecq;
}

struct pklink **
my_repq()
{
	return &u.u_procp->p_trepq;
}

struct minfo *
GetMinfoMem()
{
	register struct mbuf *m;

	if ((m = m_get(M_DONTWAIT, MT_IFADDR)) == (struct mbuf *)0)
		return (struct minfo *)0;
	m->m_len = MLEN;
	m->m_off = MMINOFF;
	return mtod(m, struct minfo *);
}

FreeMinfoMem(p)
struct minfo *p;
{
	m_free(dtom(p));
}

struct packet *
GetPacketMem()
{
	register struct mbuf *m;

	if ((m = m_get(M_DONTWAIT, MT_DATA)) == (struct mbuf *)0)
		panic("GetPacketMem");
	m->m_len = MLEN;
	m->m_off = MMINOFF;
	return mtod(m, struct packet *);
}

FreePacketMem(p)
struct packet *p;
{
	m_free(dtom(p));
}

sysWipc()
{
	struct a {
		int	swtch;
		int	a0, a1, a2, a3, a4;
	} *uap;

	uap = (struct a *)u.u_ap;
	switch (uap->swtch) {
	  case 0:
		sysSend(uap->a0, uap->a1);
		break;
	  case 1:
		sysReceive(uap->a0, uap->a1);
		break;
	  case 2:
		sysReply(uap->a0, uap->a1);
		break;
	  case 3:
		sysReplyOnCopy(uap->a0, uap->a1, uap->a2, uap->a3);
		break;
	  case 4:
		sysCopyTo(uap->a0, uap->a1, uap->a2, uap->a3, uap->a4);
		break;
	  case 5:
		sysCopyFrom(uap->a0, uap->a1, uap->a2, uap->a3, uap->a4);
		break;
	  case 6:
		sysRmid(uap->a0);
		break;
	}
}

sysSend(ump, rpid)
struct wmsg *ump;
unsigned long rpid;
{
	struct wmsg wmsg;

	if (u.u_error = copyin(ump, &wmsg, sizeof wmsg))
		return;
	if (!useracc(ump, sizeof *ump, B_WRITE))
		goto fault;
	if ((wmsg.h.rflags & RF_UMBZ)  ||
	    ((wmsg.h.xs0 | wmsg.h.xs1) & XS_UMBZ)) {
		u.u_error = EINVAL;
		return;
	}
	if ((wmsg.h.xs0 & XS_READ)  &&
	    !useracc(wmsg.seg0.addr, wmsg.seg0.len, B_READ))
		goto fault;
	if ((wmsg.h.xs0 & XS_WRITE)  &&
	    !useracc(wmsg.seg0.addr, wmsg.seg0.len, B_WRITE))
		goto fault;
	if ((wmsg.h.xs1 & XS_READ)  &&
	    !useracc(wmsg.seg1.addr, wmsg.seg1.len, B_READ))
		goto fault;
	if ((wmsg.h.xs1 & XS_WRITE)  &&
	    !useracc(wmsg.seg1.addr, wmsg.seg1.len, B_WRITE))
		goto fault;

	wmsg.h.rflags |= RF_USER;
	if (wmsg.h.xs0 & (XS_READ | XS_WRITE))
		wmsg.h.xs0 |= XS_USER;
	if (wmsg.h.xs1 & (XS_READ | XS_WRITE))
		wmsg.h.xs1 |= XS_USER;
	u.u_r.r_val1 = xSend(&wmsg, rpid);
	if (u.u_error == 0)
		u.u_error = copyout(&wmsg, ump, sizeof *ump);
	return;
  fault:
	u.u_error = EFAULT;
}

sysReceive(ump, rpid)
struct wmsg *ump;
unsigned long rpid;
{
	struct wmsg wmsg;

	EnableRecQueue();
	EnableRepQueue();
	if (!useracc(ump, sizeof *ump, B_WRITE)) {
		u.u_error = EFAULT;
		return;
	}
	u.u_r.r_val1 = xReceive(&wmsg, rpid);
	if (u.u_error == 0)
		u.u_error = copyout(&wmsg, ump, sizeof *ump);
}

sysReply(ump, rpid)
struct wmsg *ump;
unsigned long rpid;
{
	struct wmsg wmsg;

	if (u.u_error = copyin(ump, &wmsg, sizeof wmsg))
		return;
	u.u_error = xReply(&wmsg, rpid);
}

sysReplyOnCopy(ump, rpid, addr, xs)
struct wmsg *ump;
unsigned long rpid;
char *addr;
unsigned char xs;
{
	struct wmsg wmsg;

	if (u.u_error = copyin(ump, &wmsg, sizeof wmsg))
		return;
	u.u_error = xReplyOnCopy(&wmsg, rpid, addr, xs);
}

sysCopyTo(rpid, srcaddr, dstaddr, len, dstxs)
unsigned long rpid;
char *srcaddr, *dstaddr;
unsigned long len;
unsigned char dstxs;
{
	if (!useracc(srcaddr, len, B_READ)) {
		u.u_error = EFAULT;
		return;
	}
	u.u_error = xCopyTo(rpid, srcaddr, dstaddr, len, XS_USER, dstxs);
}

sysCopyFrom(rpid, srcaddr, dstaddr, len, srcxs)
unsigned long rpid;
char *srcaddr, *dstaddr;
unsigned long len;
unsigned char srcxs;
{
	if (!useracc(dstaddr, len, B_WRITE)) {
		u.u_error = EFAULT;
		return;
	}
	u.u_error = xCopyFrom(rpid, srcaddr, dstaddr, len, srcxs, XS_USER);
}

sysRmid(umachname)
register char *umachname;
{
	char machname[64];
	register char *p = machname, *q = &machname[sizeof machname];
	register int i;
	extern unsigned long NameToRmid();

	while (i = fubyte(umachname++)) {
		if (i < 0) {
			u.u_error = EFAULT;
			return;
		}
		*p++ = (char)i;
		if (p >= q) {
			u.u_error = EINVAL;
			return;
		}
	}
	*p = '\0';
	u.u_r.r_val1 = NameToRmid(machname);
}

DestroyPgrp(pgrp)
int pgrp;
{
	killpg1(SIGKILL, pgrp, 0);
}

DeletePgrp(rmid)
unsigned long rmid;
{
	int pgrp;
	extern int hz;

	pgrp = GetPgrp(rmid);
	SetPgrp(rmid, 0);
	if (pgrp) {
		killpg1(SIGTERM, pgrp, 0);
		timeout(DestroyPgrp, pgrp, 5 * hz);
	}
}

ServerDisconnect(mname)
	char *mname;
{
	if (diskless && (strcmp(mname, servername) == 0)) {
		printf("TRFS: %s server \"%s\" went down\n", 
			vbnum ? "cluster" : "diskless", servername);
		panic("loss of server");
	}
}

struct timeval ConnectTime;

SetNetTime(sec, usec)
long sec, usec;
{
	ConnectTime.tv_sec = sec;
	ConnectTime.tv_usec = usec;
}

SetRepRetry(rpid, sendseqid)
unsigned long rpid;
unsigned short sendseqid;
{
	u.u_tlastrpid = rpid;
	u.u_tlastsendseq = sendseqid;
}

CheckRepRetry(rpid, sendseqid)
unsigned long rpid;
unsigned short sendseqid;
{
	return rpid  &&
		u.u_tlastrpid == rpid  &&  u.u_tlastsendseq == sendseqid;
}

NameToIPAddr(name, naddr)
char *name;
struct in_addr *naddr;
{
	unsigned long rpid;
	char addbuf[24];
	extern unsigned long inet_addr();

	if (u.u_trrdirmid)
		rpid = u.u_trrdirmid | SERVER_PID;
	else
		rpid = SELF_MID | SERVER_PID;

	if (SdINAddr(rpid, name, strlen(name) + 1, addbuf, sizeof addbuf))
		return 0;
	naddr->s_addr = inet_addr(addbuf);
	return 1;
}

struct KFile {
	struct vnode	*kf_vp;
	struct buf	*kf_bp;
	unsigned long	kf_off;
	char		*kf_ptr;
	char		*kf_eobuf;
};

HostToINAddr(name, addbuf, addlen)
register char *name;
register char *addbuf;
int addlen;
{
	struct KFile KFile;
	register struct KFile *kfp = &KFile;
	char nms[32];
	int err;

	if (err = KFOpen("/etc/hosts", kfp))
		return err;
	while (KFGetToken(addbuf, addlen, kfp, "#\n", " \t#\n", " \t#")) {
		if (addbuf[0] == '\0')
			continue;
		while (KFGetToken(nms, sizeof nms, kfp, "", " \t#\n", " \t#")) {
			if (nms[0] == '\0'  ||  nms[0] == '\n')
				break;
			if (strcmp(nms, name) == 0) {
				KFClose(kfp);
				return 0;
			}
		}
	}
	KFClose(kfp);
	return EINVAL;
}

KFOpen(fname, kfp)
char *fname;
struct KFile *kfp;
{
	kfp->kf_vp = (struct vnode *)0;
	kfp->kf_bp = (struct buf *)0;
	kfp->kf_off = 0;
	if (u.u_tok = (setjmp(&u.u_tsave) == 0)) {
 		u.u_error = vn_open(fname, UIOSEG_KERNEL, FREAD, 0, &kfp->kf_vp);
		u.u_tok = 0;
		if (u.u_error)
			return u.u_error;
		kfp->kf_bp = geteblk(4096);
		KFFillBuf(kfp);
		return 0;
	} else {
		if (u.u_tpnp) {
			pn_dfree(u.u_tpnp);
			u.u_tpnp = (struct pathname *)0;
		}
		u.u_tcurrpid = 0;
		return ESRCH;
	}
}

KFClose(kfp)
register struct KFile *kfp;
{
	if (kfp) {
		if (kfp->kf_vp) {
			VN_RELE(kfp->kf_vp);
			kfp->kf_vp = (struct vnode *)0;
		}
		if (kfp->kf_bp) {
			brelse(kfp->kf_bp);
			kfp->kf_bp = (struct buf *)0;
		}
	}
}

KFGetToken(result, resultlen, kfp, eatbefore, delims, eatafter)
char *result;
int resultlen;
register struct KFile *kfp;
char *eatbefore, *delims, *eatafter;
{
	int ok;

	KFEat(kfp, eatbefore);
	ok = KFCopy(result, resultlen, kfp, delims);
	KFEat(kfp, eatafter);
	return ok;
}

KFEat(kfp, edibles)
register struct KFile *kfp;
register char *edibles;
{
	register char *p, *q;

	while (1) {
		if (kfp->kf_ptr >= kfp->kf_eobuf)
			if (KFFillBuf(kfp) <= 0)
				return;
		p = kfp->kf_ptr;
		q = kfp->kf_eobuf;
		while (p < q) {
			if (!KFAny(*p, edibles)) {
				kfp->kf_ptr = p;
				return;
			}
			if (*p++ == '#')
				while (p < q  &&  *p != '\n')
					p += 1;
		}
		kfp->kf_ptr = p;
	}
}

KFCopy(result, resultlen, kfp, delims)
register char *result;
register int resultlen;
register struct KFile *kfp;
register char *delims;
{
	register char *p, *q;

	if (kfp->kf_ptr >= kfp->kf_eobuf)
		if (KFFillBuf(kfp) <= 0)
			return 0;
	p = kfp->kf_ptr;
	q = kfp->kf_eobuf;
	while (p < q  &&  !KFAny(*p, delims)  &&  --resultlen > 0)
		if ((*result++ = *p++) == '\0')
			break;
	kfp->kf_ptr = p;
	*result = '\0';
	return 1;
}

KFFillBuf(kfp)
register struct KFile *kfp;
{
	register char *p = kfp->kf_bp->b_un.b_addr, *q = p;
	int blen = kfp->kf_bp->b_bcount, n;

	if ((n = KFipRead(kfp->kf_vp, kfp->kf_off, p, blen)) > 0) {
		q = &p[n];
		if (n == blen) {
			q -= 1;
			while (*--q != '\n') {
				if (q == p) {
					q = &p[n - 2];
					break;
				}
			}
			q += 1;
		}
		*q = '\0';
		kfp->kf_off += q - p;
	}
	kfp->kf_ptr = p;
	kfp->kf_eobuf = q;
	return n;
}

KFipRead(vp, off, kaddr, len)
struct vnode *vp;
off_t off;
caddr_t kaddr;
int len;
{
	int resid, err;

	if (err = vn_rdwr(UIO_READ, vp, kaddr, len, off, 
	    UIOSEG_KERNEL, IO_UNIT, &resid))
		return -err;
	return len - resid;
}

KFAny(c, p)
char c;
register char *p;
{
	if (p)
		while (*p)
			if (*p++ == c)
				return 1;
	return 0;
}

TrfsNewproc(pp, cp)
register struct proc *pp, *cp;
{
	cp->p_trecq = pp->p_trecq == PKQCLOSED ? PKQCLOSED : (struct pklink *)0;
	cp->p_trepq = pp->p_trepq == PKQCLOSED ? PKQCLOSED : (struct pklink *)0;
}
