#include "errno.h"
#include "../wipc/wipc.h"
#include "../wipc/wipc_packet.h"

fcopyin(fp)
register struct fragment *fp;
{
	if (fp == (struct fragment *)0)
		return 0;
	return xcopyin(fp->srcaddr, (char *)fp + fp->off, fp->len, fp->srcxs);
}

fcopyout(fp)
register struct fragment *fp;
{
	if (fp == (struct fragment *)0)
		return 0;
	return xcopyout((char *)fp + fp->off, fp->dstaddr, fp->len, fp->dstxs);
}

xcopyin(srcaddr, dstaddr, len, xs)
register char *srcaddr, *dstaddr;
register unsigned long len;
unsigned char xs;
{
	switch (xs & XS_SEGMASK) {
	  case XS_USER:
		return copyin(srcaddr, dstaddr, len);
	  case XS_KERN:
		bcopy(srcaddr, dstaddr, len);
		return 0;
	  case XS_PHYS:
		pcopyin(srcaddr, dstaddr, len);
		return 0;
	}
	return EINVAL;
}

xcopyout(srcaddr, dstaddr, len, xs)
register char *srcaddr, *dstaddr;
register unsigned long len;
unsigned char xs;
{
	switch (xs & XS_SEGMASK) {
	  case XS_USER:
		return copyout(srcaddr, dstaddr, len);
	  case XS_KERN:
		bcopy(srcaddr, dstaddr, len);
		return 0;
	  case XS_PHYS:
		pcopyout(srcaddr, dstaddr, len);
		return 0;
	}
	return EINVAL;
}

pkbuild(dp, sp, len, fp0, fp1)
register struct packet *dp, *sp;
unsigned long len;
register struct fragment *fp0, *fp1;
{
	register unsigned long len0 = len, len1 = 0;

	bcopy(sp, dp, len);
	if (fp0  &&  fp0->len) {
		fcopyin((char *)fp0 + ((char *)dp - (char *)sp));
		len0 = (char *)fp0 - (char *)sp + fp0->off + fp0->len;
	}
	if (fp1  &&  fp1->len) {
		fcopyin((char *)fp1 + ((char *)dp - (char *)sp));
		len1 = (char *)fp1 - (char *)sp + fp1->off + fp1->len;
	}
	return len0 > len1 ? len0 : len1;
}

nbits(bits)
register unsigned long bits;
{
	register int n = 0;

	do {
		if (bits & 1)
			n += 1;
	} while (bits >>= 1);
	return n;
}
