#include "errno.h"
#include "../wipc/wipc.h"
#include "../wipc/wipc_packet.h"
#include "../wipc/wipc_pklink.h"
#include "../wipc/wipc_minfo.h"

extern char hostname[];
struct iface iface[NIFACE];
struct minfo *minfo, *xminfo;
#define	REFCOUNT	10		/* minutes til disconnect if inactive */
int server_pid = 0x7FFF;		/* doesn't really belong here */

unsigned long
MinfoAttach(ix, naddr, name, rmid, rrmid, pklen, pkburst)
int ix;
char *naddr;
char *name;
unsigned long rmid, rrmid;
unsigned short pklen;
unsigned char pkburst;
{
	register struct minfo *mp;
	register struct iface *ifp = &iface[ix];
	struct minfo *name_minfo(), *netaddr_minfo();

	if (name  &&  (mp = name_minfo(name))) {
		if (mp == netaddr_minfo(ifp, naddr))
			goto gotit;
		return 0;
	}
	if ((mp = netaddr_minfo(ifp, naddr)) == (struct minfo *)0) {
		if ((mp = (struct minfo *)GetMinfoMem()) == (struct minfo *)0)
			return 0;
		bzero(mp, sizeof *mp);
		mp->ifp = ifp;
		bcopy(naddr, mp->naddr, ifp->nalen);
		mp->next = minfo;
		mp->xnext = xminfo;
		mp->ref = REFCOUNT;
		minfo = xminfo = mp;
	}
	addname(mp, name);
  gotit:
	if (mp->rmid != rmid  &&  rmid != 0) {
		if (mp->rmid)
			DeletePgrp(mp->rmid);
		mp->rmid = rmid;
	}
	if (mp->rrmid != rrmid  &&  rrmid != 0)
		mp->rrmid = rrmid;
	if (pklen  &&  pkburst) {
		mp->pklen = pklen;
		mp->pkburst = pkburst;
	} else {
		mp->pklen = 0;
		mp->pkburst = 0;
	}
	return mp->rmid;
}

MinfoDetach(name, rmid)
char *name;
unsigned long rmid;
{
	register struct minfo *mp, *mpp;
	extern int hz, FreeMinfoMem();
	struct minfo *name_minfo();
	struct minfo *rpid_minfo();

	DeletePgrp(rmid);
	if ((name  &&  *name  &&  (mp = name_minfo(name)))  ||
	    (rmid  &&  (mp = rpid_minfo(rmid)))) {
		/* should verify rmid here! */
		mpp = (struct minfo *)&minfo;
		do {
			if (mpp->next == mp) {
				mpp->next = mp->next;
				break;
			}
		} while (mpp = mpp->next);
		if (mpp == (struct minfo *)0)
			panic("MinfoDetach: minfo");
		mpp = (struct minfo *)&xminfo;
		if (mpp->next == mp)		/* special check for first */
			mpp->next = mp->xnext;
		else if (mpp = mpp->next) 
		    do {
			if (mpp->xnext == mp) {
				mpp->xnext = mp->xnext;
				break;
			}
		    } while (mpp = mpp->xnext);
		if (mpp == (struct minfo *)0)
			panic("MinfoDetach: xminfo");
		if (mp->vp)				/* dereference swap */
			vn_rele(mp->vp) /*VN_RELE(mp->vp)*/;
		mp->vp = 0;
		timeout(FreeMinfoMem, mp, 16 * hz);	/* kmem consistency */
	}
}

addname(mp, name)
struct minfo *mp;
register char *name;
{
	register char *p, *q;
	register int n;

	if (name == (char *)0)
		return;
	n = strlen(name) + 1;
	if (*(p = mp->names))
		while (*p++)		/* skip first name (real name) */
			;
	q = &p[sizeof mp->names];
	if (n + 1 > q - p)		/* make sure there's room for new */
		return E2BIG;
	ovbcopy(p, p + n, q - p - n);	/* scoot rest of names over */
	bcopy(name, p, n);		/* insert new right after real name */
	*--q = '\0';			/* gotta have two nulls after last */
	while (*--q)			/* delete last name, if necessary */
		*q = '\0';
}

rpid_pid(rpid)
unsigned long rpid;
{
	if ((rpid = PID(rpid)) == SERVER_PID)
		return server_pid;
	return (int)rpid;
}

struct minfo *
rpid_minfo(rpid)
register unsigned long rpid;
{
	register struct minfo *mp = minfo, *prev_mp;

	if ((rpid = MID(rpid))  &&  mp) {
		if (rpid == mp->rmid)
			return mp;
		for (prev_mp = mp;  mp = mp->next;  prev_mp = mp)
			if (rpid == mp->rmid) {
				prev_mp->next = mp->next;
				mp->next = minfo;
				minfo = mp;
				return mp;
			}
	}
	return (struct minfo *)0;
}

struct minfo *
name_minfo(name)
register char *name;
{
	register struct minfo *mp = minfo, *prev_mp;
	register char *names;

	if (mp) {
		names = mp->names;
		while (*names) {
			if (strcmp(name, names) == 0)
				return mp;
			while (*names++)
				;
		}
		for (prev_mp = mp;  mp = mp->next;  prev_mp = mp) {
			names = mp->names;
			while (*names) {
				if (strcmp(name, names) == 0) {
					prev_mp->next = mp->next;
					mp->next = minfo;
					minfo = mp;
					return mp;
				}
				while (*names++)
					;
			}
		}
	}
	return (struct minfo *)0;
}

struct minfo *
netaddr_minfo(ifp, naddr)
register struct iface *ifp;
register char *naddr;
{
	register struct minfo *mp = minfo;
	register unsigned long nalen = ifp->nalen;

	if (mp) 
	    do {
		if (ifp == mp->ifp  &&  bcmp(naddr, mp->naddr, nalen) == 0)
			return mp;
	    } while (mp = mp->next);
	return (struct minfo *)0;
}

MaxPktLen(rpid)
unsigned long rpid;
{
	register struct minfo *mp;

	if (mp = minfo)
		if (MID(rpid) == mp->rmid  ||  (mp = rpid_minfo(rpid)))
			if (mp->pklen)
				return mp->pklen;
			else if (mp->ifp)
				return mp->ifp->pklen;
	return 512 - 16;
}

MaxPktBurst(rpid)
unsigned long rpid;
{
	register struct minfo *mp;

	if (mp = minfo)
		if (MID(rpid) == mp->rmid  ||  (mp = rpid_minfo(rpid)))
			if (mp->pkburst)
				return mp->pkburst;
			else if (mp->ifp)
				return mp->ifp->pkburst;
	return 1;
}

IfaceAttach(unit, xmit, relse, pklen, pkburst, bcst, nalen)
int unit, (*xmit)(), (*relse)();
unsigned long pklen, pkburst, nalen;
unsigned char *bcst;
{
	register struct iface *ifp;
	register int ix;

	for(ifp = iface;  ifp < &iface[NIFACE];  ifp += 1) {
		if (ifp->xmit == (int (*)())0) {
			ix = ifp - iface;
			ifp->flags = 0;
			ifp->unit = unit;
			ifp->xmit = xmit;
			ifp->relse = relse;
			ifp->pklen = pklen;
			ifp->pkburst = pkburst;
			ifp->nalen = nalen;
			if ((ifp->bcst = bcst) != (unsigned char *)0)
				ifp->flags |= BCST;
			return ix;
		}
	}
	return -1;
}

IfaceUp(ix)
{
	register struct iface *ifp = &iface[ix];

	ifp->flags |= UP;
}

IfaceDown(ix)
{
	register struct iface *ifp = &iface[ix];

	ifp->flags &= ~UP;
}

int Xdrop = 0;				/* simulate loss of packets */

SendPacket(p, len, fp0, fp1)
struct packet *p;
unsigned long len;
struct fragment *fp0, *fp1;
{
	register unsigned long rpid = p->dst;
	register struct minfo *mp;
	register struct iface *ifp;
	int rval = ENXIO;

	if (Xdrop && (rand() & 1023) < Xdrop)
		return EIO;
	if (MID(rpid) != BROADCAST_MID) {
		if ((mp = minfo)  &&
		    (MID(rpid) == mp->rmid || (mp = rpid_minfo(rpid))))
			if ((ifp = mp->ifp)  &&  (ifp->flags & UP))
				return (*ifp->xmit)(ifp->unit, mp->naddr,
							p, len, fp0, fp1);
	} else {
		for(ifp = iface;  ifp < &iface[NIFACE];  ifp += 1)
			if ((ifp->flags & (UP | BCST)) == (UP | BCST)  &&
			    (*ifp->xmit)(ifp->unit, ifp->bcst,
					p, len, fp0, fp1) == 0)
				rval = 0;
	}
	return rval;
}

ReleasePacket(p)
struct packet *p;
{
	register struct pklink *lp = (struct pklink *)(p + 1) - 1;
	register struct iface *ifp;

	if (lp->ix < NIFACE  &&  (ifp = &iface[lp->ix])  &&  ifp->relse)
		(*ifp->relse)(ifp->unit, lp);
	else
		printf("TRFS: packet lost\n");
}

/*
 * CALLED AT INTERRUPT TIME!
 */
SendNack(lp, errcode)
register struct pklink *lp;
unsigned char errcode;
{
	register struct iface *ifp;
	struct packet pk;

	if (MAJVER(lp->packet.version) != MAJVER(VERSION))
		return EPROTONOSUPPORT;
	switch (lp->packet.type) {
	  case T_SEND:
		if (((struct sendpk *)(&lp->packet))->msg.h.rflags & RF_NOREP)
			break;
		errcode = -(char)errcode; /* KLUDGE for packet filtering */
		/* else fall thru */

	  case T_COPY_FROM_REQ:
	  case T_COPY_TO_REQ:
		if ((ifp = &iface[lp->ix])  &&
		    MID(lp->packet.src) != BROADCAST_MID  &&
		    MID(lp->packet.dst) != BROADCAST_MID) {
			pk.type = T_NACK;
			pk.version = VERSION;
			pk.retry = lp->packet.retry;
			pk.errcode = errcode;
			pk.sendseqid = lp->packet.sendseqid;
			pk.copyseqid = lp->packet.copyseqid;
			pk.dst = lp->packet.src;
			pk.src = lp->packet.dst;
			return (*ifp->xmit)(ifp->unit, lp->netaddr,
							&pk, sizeof pk, 0, 0);
		}
	}
	return ENXIO;
}

/*
 * CALLED AT INTERRUPT TIME!
 */
SendRep(lp)
struct pklink *lp;
{
	register struct iface *ifp;
	unsigned long newdst = lp->packet.src;

	if (MAJVER(lp->packet.version) != MAJVER(VERSION))
		return EPROTONOSUPPORT;
	if (lp->packet.type == T_SEND  &&  (ifp = &iface[lp->ix])  &&
	    MID(newdst) != BROADCAST_MID  &&  PID(newdst) != INTERRUPT_PID) {
		lp->packet.type = T_REPLY;
		lp->packet.src = lp->packet.dst;
		lp->packet.dst = newdst;
		return (*ifp->xmit)(ifp->unit, lp->netaddr,
				&lp->packet, sizeof(struct sendpk), 0, 0);
	}
	return ENXIO;
}

unsigned long
NameToRmid(name)
register char *name;
{
	register struct minfo *mp;
	unsigned long rmid;
	char naddr[8];
	extern int wipc_ip_ix;
	extern unsigned long Connect(), MinfoAttach();
	unsigned long new_rmid();

	if (hostname[0] == '\0')		/* no anonymous harassment */
		return (unsigned long)0;
	if ((mp = name_minfo(name))  &&  mp->rrmid != 0)
		return mp->rmid;
	Connect(name, BROADCAST_MID);
	if ((mp = name_minfo(name))  &&  mp->rrmid != 0)
		return mp->rmid;
	if (wipc_ip_ix >= 0  &&  NameToIPAddr(name, naddr)) {
		Connect(name, MinfoAttach(wipc_ip_ix, naddr, (char *)0,
						rmid = new_rmid(), 0, 0, 0));
		if ((mp = name_minfo(name))  &&  mp->rrmid != 0)
			return mp->rmid;
		MinfoDetach((char *)0, rmid);
	}
	return (unsigned long)0;
}

char *
RpidToName(rpid)
unsigned long rpid;
{
	struct minfo *mp;

	if (mp = rpid_minfo(rpid))
		return mp->names;
	return (char *)0;
}

SetSwapVp(rpid, vp)
unsigned long rpid;
struct vnode *vp;
{
	register struct minfo *mp;

	if (mp = rpid_minfo(rpid)) {
		if (mp->vp)
			vn_rele(mp->vp) /*VN_RELE(mp->vp)*/;
		mp->vp = vp;
	}
}

struct vnode *
GetSwapVp(rpid)
unsigned long rpid;
{
	struct minfo *mp;

	if (mp = rpid_minfo(rpid))
		return mp->vp;
	return (struct vnode *)0;
}

unsigned long
my_rpid(rpid)
unsigned long rpid;
{
	register struct minfo *mp;
	register unsigned long rrmid;

	rrmid = (unsigned long)my_pid();
	rrmid = PID(rrmid);
	if (mp = rpid_minfo(rpid))
		rrmid |= mp->rrmid;
	return rrmid;
}

#define	INCREMENT(mask)	((~(mask) + 1) & (mask))
unsigned long max_rmid = 0;

unsigned long
new_rmid()
{
	static unsigned long rmnum = 0;
	register unsigned long rmid;
	struct minfo *rpid_minfo();
	int s = splimp();

	do {
		if ((rmid = (rmnum += INCREMENT(MID_MASK))) > MID_MASK - 16)
			rmnum = 0;
		if (rmid > max_rmid)
			max_rmid = rmid;
	} while (rmnum == 0  ||  rpid_minfo(rmid));
	splx(s);
	return rmid;
}

WipcShutdown()
{
	register struct minfo *mp;
	register unsigned long rmid;
	int first = 0;

	for (rmid = 0;  rmid <= max_rmid;  rmid += INCREMENT(MID_MASK))
	    if ((mp = rpid_minfo(rmid))  &&  mp->rmid  &&  mp->rrmid)
		if (Disconnect(mp->rmid) == 0) {
			if (first++ == 0)
				printf("TRFS: shutdown can't reach:");
			else
				printf(",");
			printf(" %s", mp->names);
		}
	Disconnect(0);
	if (first)
		printf("\n");
}
#undef	INCREMENT

int
IsMyMName(name)
register char *name;
{
	register char *names;

	names = hostname;
	while (*names) {
		if (strcmp(name, names) == 0)
			return 1;
		while (*names++)
			;
	}
	return 0;
}

SetPgrp(rpid, newpgrp)
unsigned long rpid;
int newpgrp;
{
	register struct minfo *mp;

	if ((mp = rpid_minfo(rpid)) == (struct minfo *)0)
		return 0;
	if (mp->pgrp == 0  ||  newpgrp == 0)
		mp->pgrp = newpgrp;
	return mp->pgrp;
}

GetPgrp(rmid)
unsigned long rmid;
{
	register struct minfo *mp;

	if (mp = rpid_minfo(rmid))
		return mp->pgrp;
	return 0;
}

MachineSynch(myname)
register char *myname;
{
	register struct minfo *mp;
	register int nbroad = 0;

	if (mp = xminfo) 
	    do {
		if (mp->rmid == 0  ||  mp->rmid == SELF_MID)
			continue;
		if (mp->ref  &&  --mp->ref == 0) {
			if (Disconnect(mp->rmid) == 0)
				MinfoDetach(mp->names, mp->rmid);
		} else if (mp->ifp  &&  (mp->ifp->flags & BCST))
			nbroad += 1;
	    } while (mp = mp->xnext);
	if (myname  &&  *myname) {
		if (nbroad >= 3)
			SdAmAlive(myname, BROADCAST_MID | SERVER_PID);
		else
			nbroad = 0;
		if (mp = xminfo) do {
		    if (mp->rmid == 0 || mp->rmid == SELF_MID || mp->ifp == 0)
			continue;
		    if (nbroad == 0 || (mp->ifp->flags & (UP|BCST)) == UP)
			SdAmAlive(myname, mp->rmid | SERVER_PID);
		} while (mp = mp->xnext);
	}
}

UpdateRef(name)
register char *name;
{
	register struct minfo *mp;

	if (mp = xminfo) 
	    do {
		if (strcmp(name, mp->names) == 0) {
			mp->ref = REFCOUNT;
			return;
		}
	    } while (mp = mp->xnext);
}

VerifyPacket(lp)
register struct pklink *lp;
{
	register struct minfo *mp;

	switch (MID(lp->packet.src)) {
	  case 0:
	  case BROADCAST_MID:
	  case SELF_MID:
		return 1;
	}
	switch (MID(lp->packet.dst)) {
	  case 0:
	  case BROADCAST_MID:
	  case SELF_MID:
		return 1;
	}
	if ((mp = rpid_minfo(lp->packet.src))  &&
	    mp->rrmid == MID(lp->packet.dst)  &&
	    mp->ifp == &iface[lp->ix]  &&
	    bcmp(lp->netaddr, mp->naddr, mp->ifp->nalen) == 0)
		return 1;
	return 0;
}
