#include "../h/ucode.h"
/******************************************************************************
* UCaddr
*
* Converts 21 bit raster byte address to hi and lo long word addresses for GIP
*
* Assembly Interface:
*	input:
*		a3 = raster address
*	output:
*		d2 = hi bits
*		d3 = lo bits
*
******************************************************************************/
	.text
	.globl	UCaddr
UCaddr: movl	a3,sp@-			/* save */
	movl	_screen+2,d3		/* base of display memory */
	subl	d3,a3			/* display memory relative */
	movl	a3,d3			/* copy address */
	asrl	#2,d3			/* discard bottom 2 bits */
	movl	a3,d2			/* copy address */
	asrl	#8,d2			/* discard bottom 18 bits */
	asrl	#8,d2			/* discard bottom 18 bits */
	asrl	#2,d2			/* discard bottom 18 bits */
	andw	#0x7,d2			/* 3 bits significant */
	movl	sp@+,a3			/* restore */
	rts
