#include "../h/ucode.h"
/******************************************************************************
* set_pitch
*
* Check and set the source and destination pitches
* 	must be modulo four for 32 bit boundary
*
* Assembly Interface:
*	input:
*		a0 = source width in bytes
*		a1 = destination width in bytes
*	output:
*		all registers are saved
*
******************************************************************************/
	.text
	.globl	set_pitch
set_pitch:
	jsr	src_pitch
	jsr	dst_pitch
	rts

/******************************************************************************
* src_pitch
*
* Check and set the source pitch
* 	must be modulo four for 32 bit boundary
*
* Assembly Interface:
*	input:
*		a0 = width in bytes
*	output:
*		all registers are saved
*
******************************************************************************/
	.data
UCspitch:
	.word	0			/* save last src pitch */

	.text
	.globl	src_pitch
src_pitch:
	movl	d0,sp@-			/* save d0 */
	movw	a0,d0			/* load width */
	asrw	#2,d0			/* adjust to # of long words */
	cmpw	UCspitch,d0		/* check for already set */
	beq	1f			/* skip load if so */
	movw	d0,UCspitch		/* save pitch */
	movl	d0,sp@-			/* load width */
	movl	#GP_SPTCH,sp@-		/* source pitch command */
	movl	#2,sp@-			/* number of paramters */
	jsr	_UCoutput		/* execute */
	addl	#12,sp			/* clear stack */
    1:	movl	sp@+,d0			/* restore d0 */
	rts

/******************************************************************************
* dst_pitch
*
* Check and set the destination pitch
* 	must be modulo four for 32 bit boundary
*
* Assembly Interface:
*	input:
*		a1 = width in bytes
*	output:
*		all registers are saved
*
******************************************************************************/
	.data
UCdpitch:
	.word	0			/* save last dest pitch */

	.text
	.globl	dst_pitch
dst_pitch:
	movl	d0,sp@-			/* save d0 */
	movw	a1,d0			/* load width */
	asrw	#2,d0			/* adjust to # of long words */
	cmpw	UCdpitch,d0		/* check for already set */
	beq	1f			/* skip load if so */
	movw	d0,UCdpitch		/* save pitch */
	movl	d0,sp@-			/* load width */
	movl	#GP_DPTCH,sp@-		/* dest pitch command */
	movl	#2,sp@-			/* number of paramters */
	jsr	_UCoutput		/* execute */
	addl	#12,sp			/* clear stack */
    1:	movl	sp@+,d0			/* restore d0 */
	rts
