/******************************************************************************
* Bottom(result, r, y)
*
* Splits rectangle "r" vertically at coordinate "y" and returns a rectangle
* that includes the split and everything below it.
*
* C Interface:
*
*	Bottom(result, r, y)
*	struct rectangle *result, r;
*	word y;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| answer			  |  0 (L)
*	+---------------------------------+
*	| r.x            | r.y            |  2 (W), 4 (W)
*	+---------------------------------+
*	| r.w            | r.h            |  8 (W), 10 (W)
*	+---------------------------------+
*	| ///////////////| y              |  14 (W)
*	+---------------------------------+
*
******************************************************************************/
ans	= 0+8
rx	= 4+8
ry	= 6+8
rw	= 8+8
rh	= 10+8
y	= 14+8

	.text
	.globl	_Bottom
_Bottom:
	link	a6,#0			/* set up stack frame */
	moveml	#<d2-d3>,sp@-		/* save registers */
	movemw	a6@(rx),#<d0-d3>	/* blast rectangle in */
	addw	d1,d3			/* compute first y beyond bottom */
	subw	a6@(y),d3		/* compute height of bottom portion */
	movw	a6@(y),d1		/* put top at dividing Y */
	movl	a6@(ans),a0
	movemw	#<d0-d3>,a0@		/* blast result out */
	moveml	sp@+,#<d2-d3>		/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
