#include "../h/ucode.h"
/******************************************************************************
* PaintURaster(mask, mx, my, raster, rx, ry, w, h, color)
*
* Paints the rectangle of width "w" and height "h" located at ("rx", "ry") in
* "raster".  The rectangle is painted with "color" whereever there is a 1 bit
* in the rectangle of the same size at ("mx", "my") in "mask". (in user space)
*
* C Interface:
*
*	PaintURaster(mask, mx, my, raster, rx, ry, w, h, color)
*	RASTER *mask, *raster;
*	int mx, my, rx, ry, w, h;
*	COLOR color;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| mask                            |  0 (L)
*	+---------------------------------+
*	|////////////////| mx             |  6 (W)
*	+---------------------------------+
*	|////////////////| my             | 10 (W)
*	+---------------------------------+
*	| raster                          | 12 (L)
*	+---------------------------------+
*	|////////////////| rx             | 18 (W)
*	+---------------------------------+
*	|////////////////| ry             | 22 (W)
*	+---------------------------------+
*	|////////////////| w              | 26 (W)
*	+---------------------------------+
*	|////////////////| h              | 30 (W)
*	+---------------------------------+
*	|////////////////| color          | 34 (W)
*	+---------------------------------+
*
******************************************************************************/
	.text
	.globl	_PaintURaster
_PaintURaster:
	link	a6,#0			/* establish frame pointer */
	moveml	#<d2-d7,a2-a5>,sp@-	/* save registers */

	/* Get C parameters */
	movl	a6@(0+8),a0		/* get mask pointer */
	movl	a0@(2),a2		/* get mask address */
	movw	a0@,a0			/* get mask width */
	movw	a6@(6+8),d0		/* get mask X coordinate */
	movw	a6@(10+8),d1		/* get mask Y coordinate */
	movl	a6@(12+8),a1		/* get raster pointer */
	movl	a1@(2),a3		/* get raster address */
	movw	a1@,a1			/* get raster width */
	movw	a6@(18+8),d2		/* get raster X coordinate */
	movw	a6@(22+8),d3		/* get raster Y coordinate */
	movw	a6@(26+8),d4		/* get width */
	movw	a6@(30+8),d5		/* get height */

	/* Setup registers */
	jsr	setup			/* do the setup */
	blt	return			/* return if nothing to do */
	andw	#0xf,d1			/* adjust rotation */
#ifdef UCODE
	jsr	_CPUgetdisp		/* get display */
#endif UCODE
	
	movw	a6@(34+8),d7		/* get color */

	/* Paint according to color and direction */
	tstw	d7			/* test color */
	beqs	black			/* branch if black */
white:	cmpl	#0,a4			/* test increment direction for white */
	bgts	whinc			/* branch if incrementing */
	bras	whdec			/* branch if decrementing */

black:	notw	d2			/* complement initial mask */
	notw	d3			/* complement final mask */

	cmpl	#0,a4			/* test increment direction for black */
	bgts	blinc			/* branch if incrementing */
	bra	bldec			/* branch if decrementing */

	/* Paint with white, incrementing addresses */
whinc:
    1:	movesl	a2@,d6			/* read left source word */
	lsrl	d1,d6			/* align with destination */
	andw	d2,d6			/* keep valid bits */
	orw	d6,a3@+			/* write destination back */
	addql	#2,a2			/* bump source address */
	movw	d4,d0			/* initialize word counter */
	blts	3f			/* skip loop if zero */

    2:	movesl	a2@,d6			/* read a source word */
	lsrl	d1,d6			/* align with destination */
	orw	d6,a3@+			/* write it out */
	addql	#2,a2			/* point to next word */
	dbf	d0,2b			/* loop until row finished */

    3:	movesl	a2@,d6			/* read left source word */
	lsrl	d1,d6			/* align with destination */
	andw	d3,d6			/* keep valid bits */
	orw	d6,a3@			/* write destination back */
	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

	bra	returnd			/* return */

	/* Paint with white, decrementing addresses */
whdec:
    1:	movesl	a2@,d6			/* read right source word */
	lsrl	d1,d6			/* align with destination */
	andw	d2,d6			/* keep valid bits */
	orw	d6,a3@			/* write destination back */
	subql	#2,a2			/* bump source address */
	movw	d4,d0			/* initialize word counter */
	blts	3f			/* skip loop if zero */

    2:	movesl	a2@,d6			/* read a source word */
	lsrl	d1,d6			/* align with destination */
	orw	d6,a3@-			/* write it out */
	subql	#2,a2			/* point to next word */
	dbf	d0,2b			/* loop until row finished */

    3:	movesl	a2@,d6			/* read right source word */
	lsrl	d1,d6			/* align with destination */
	andw	d3,d6			/* keep valid bits */
	orw	d6,a3@-			/* write destination back */
	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

	bra	returnd			/* return */

	/* Paint with black, incrementing addresses */
blinc:
    1:	movesl	a2@,d6			/* read left source word */
	lsrl	d1,d6			/* align with destination */
	notw	d6			/* complement it */
	orw	d2,d6			/* make invalid bits harmless */
	andw	d6,a3@+			/* combine source with destination */
	addql	#2,a2			/* bump source address */
	movw	d4,d0			/* initialize word counter */
	blts	3f			/* skip loop if zero */

    2:	movesl	a2@,d6			/* read a source word */
	lsrl	d1,d6			/* align with destination */
	notw	d6			/* complement it */
	andw	d6,a3@+			/* combine source with destination */
	addql	#2,a2			/* point to next word */
	dbf	d0,2b			/* loop until row finished */

    3:	movesl	a2@,d6			/* read right source word */
	lsrl	d1,d6			/* align with destination */
	notw	d6			/* complement it */
	orw	d3,d6			/* make invalid bits harmless */
	andw	d6,a3@			/* combine source with destination */
	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

	bra	returnd			/* return */

	/* Paint with black, decrementing addresses */
bldec:
    1:	movesl	a2@,d6			/* read right source word */
	lsrl	d1,d6			/* align with destination */
	notw	d6			/* complement it */
	orw	d2,d6			/* make invalid bits harmless */
	andw	d6,a3@			/* combine source with destination */
	subql	#2,a2			/* bump source address */
	movw	d4,d0			/* initialize word counter */
	blts	3f			/* skip loop if zero */

    2:	movesl	a2@,d6			/* read a source word */
	lsrl	d1,d6			/* align with destination */
	notw	d6			/* complement it */
	andw	d6,a3@-			/* combine source with destination */
	subql	#2,a2			/* point to next word */
	dbf	d0,2b			/* loop until row finished */

    3:	movesl	a2@,d6			/* read left source word */
	lsrl	d1,d6			/* align with destination */
	notw	d6			/* complement it */
	orw	d3,d6			/* make invalid bits harmless */
	andw	d6,a3@-			/* combine source with destination */
	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */
					/* all done */
returnd:	
#ifdef UCODE_DEBUG
	jsr	_CPUrlsdisp		/* release display */
#endif UCODE_DEBUG
return:	moveml	sp@+,#<d2-d7,a2-a5>	/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
