/*
 *	This file defines the structures et al that are needed for window
 *	manipulation.
 */

#ifndef _WINDOW
#define _WINDOW
#define TITLELENGTH 32		    /* title length */
#define NTILES	    10		    /* number of tiles in ordinary window */
#define TT	    30		    /* title bar thickness */
#define ST	    20		    /* scroll bar thickness */
#define BT	     3		    /* border thickness */
#define RT	     2		    /* rule thickness */

/*
 *	Each window has the following associated attribute structure which is
 *	used to pass parameters into and out of the window.
 */
struct attributes
{
	byte		addressing;
	byte		xphase, yphase;
	byte		orientation;
	byte		direction;
	byte		justification;
	byte		ctype;
	word		thickness;
	word		count;
	word		mask;
	word		xposition, yposition;
	COLORT		color;
	COLORT		bcolor;
	PATTERN		pattern;
	PATTERN		bpattern;
	unsigned short	font;
} STATE;

/*
 *	A window structure is allocted for each window and maintains all of
 *	the vital statistics which are needed .
 */
struct window
{
	struct window	*prev;		/* links to other windows on system */
	struct window	*next;
	short		type;		/* type of this window */
	int 		aid;		/* id for adjust routine */
	int		(*adjust)();	/* routine called to change win size*/
	int		id;		/* id of window */
	int		(*refresh)();	/* refresh routine of window */
	char		title[TITLELENGTH];  /* title of window */
	COLORT		fcolor[NTILES];	/* forground color foor each tile */
	COLORT		bcolor[NTILES]; /* background color for each tile */
	int		*glyph[NTILES]; /* glyph for each tile */
	struct rectangle    ibounds;	/* rectangle of display surface */
	struct rectangle    obounds;	/* rectangle of whole window frame */
	struct rectangle    pcbounds;	/* permanent clipping bounds */
	struct rectangle    tcbounds;	/* temporary clipping bounds */
	struct tile	*tiles;		/* display tile list of window = 
					 * itiles restricted by tcbounds */
	struct tile	*itiles;	/* full tile list of window used for
					 * cursor display */
	struct attributes    attributes;
	struct cursor	*cursor;	/* local cursor of window */

	struct cursor	*gcursor;	/* form of global cursor in window */
};

extern struct window *desk;		/* the desktop */

#endif
