/*
 *	A cursor is defined for each window, and for the system as a whole.
 *	Each window may also given a shape to the global cursor for when it
 *	is in its window.
 */
#ifndef _CURSOR
#define _CURSOR

/* cursor size */
#define	CURSORW		32
#define CURSORH		32

/* flags for blanking cursors when playing with windows */
#define LCURSE	0x01
#define GCURSE	0x02

struct cursor
{
    byte		xref, yref;     /* referance pointes of cursor */
    bool		visible;	/* flag for visibility */
    byte		blanked;	/* count for temporary blanking */
    byte		blink;		/* blink rate of cursor */
    struct rectangle	bounds;		/* clipping bounds of cursor */
    RASTER		face, mask;	/* face and mask of cursor */
    RASTER		back;		/* background of cursor */
};

/*
 *	A rubber band cursor is a variable sized rectangular cursor which can
 *	be moved over the whole screen for purposes of moving and sizeing
 *	windows.
 */
struct rubbercursor
{
    bool	visible;		/* flag for visibility */
    byte	blanked;		/* count for temporary blanking */
    byte	flag;			/* flag for which parts blanked */
    struct rectangle	bounds;		/* clipping bounds of cursor */
    RASTER	horz;			/* area to save background */
    RASTER	lvert;
    RASTER	rvert;
};

/* defines used for blanking part of box */
#define BLANKT 0x01			/* top part of box blanked */
#define BLANKB 0x02			/* bottom part blanked */
#define BLANKL 0x04			/* left side blanked */
#define BLANKR 0x08			/* rigth side blanked */

extern struct cursor *CreateCursor();

#endif
