#include "../h/ucode.h"
/******************************************************************************
* UnsetClipping()
*
* Turns off global micro-code clipping
*
* C Interface:
*
*	UnsetClipping()
*
******************************************************************************/
	.text
	.globl	_UnsetClipping
_UnsetClipping:
#ifdef UCODE_CLIP
	btst	#GPHASGIP_B,_gptype	/* see if we have a GIP to use */
	beq	manual			/* no do it the hard way */

	/* Make sure that clipping is turned off */
	link	a6,#0			/* establish frame pointer */
	movl	#GP_CLIPOF,sp@-		/* push clip off command */
	movl	#1,sp@-			/* push number of parameters */
	jsr	_UCoutput		/* load command and execute */
	addl	#8,sp			/* level stack */
	clrb	UCclipon		/* flag clipping off */
	unlk	a6			/* unlink stack frame */
#endif UCODE_CLIP

manual:	rts
