#include "../h/ucode.h"
/******************************************************************************
* InvertArea(x, y, w, h)
*
* Inverts the rectangular area of width "w" and height "h" located at
* ("x", "y") on the screen.  No clipping is done.
*
* C Interface:
*
*	InvertArea(x, y, w, h)
*	int x, y, w, h;
*
* Assembly Interface:
*
*	+---------------------------------+
*	|////////////////| x              |  2 (W)
*	+---------------------------------+
*	|////////////////| y              |  6 (W)
*	+---------------------------------+
*	|////////////////| w              | 10 (W)
*	+---------------------------------+
*	|////////////////| h              | 14 (W)
*	+---------------------------------+
*
******************************************************************************/
	.set	x,	2
	.set	y,	6
	.set	w,	10
	.set	h,	14

	.text
	.globl	_InvertArea
_InvertArea:
	link	a6,#0			/* establish stack frame */
	moveml	#<d2-d3>,sp@-		/* save working registers */

	/* Get and clip area to be inverted */
	movw	a6@(x+8),d0		/* get x coordinate */
	movw	a6@(y+8),d1		/* get y coordinate */
	movw	a6@(w+8),d2		/* get width */
	movw	a6@(h+8),d3		/* get height */

	jsr	RClip			/* clip to clipping bounds */
	ble	return			/* return if nothing visible */

	/* Invert the clipped area */
	movl	d3,sp@-			/* pass width */
	movl	d2,sp@-			/* pass height */
	movl	d1,sp@-			/* pass y */
	movl	d0,sp@-			/* pass x */
	movl	#_screen,sp@-		/* pass screen raster descriptor */

	jsr	_InvertRaster		/* invert the area */

	addl	#20,sp			/* clean off parameters */

	/* Clean up stack and return */
return:	moveml	sp@+,#<d2-d3>		/* restore working registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
