/******************************************************************************
* CharacterHeight(font, character)
*
* Returns the height in pixels of "character" in "font".
*
* C Interface:
*
*	int CharacterHeight(font, character)
*	FONT font;
*	char character;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| font                            |  0 (L)
*	+---------------------------------+
*	|////////////////| character      |  6 (W)
*	+---------------------------------+
*
******************************************************************************/
	.text
	.globl	_CharacterHeight
_CharacterHeight:
	movl	sp@(4),a0		/* get font address */
	movb	sp@(7+4),d0		/* get character code */
	movb	a0@(6),d0		/* retrieve the height */
	extw	d0			/* extend to word */
	extl	d0			/* extend to long for C */
	rts				/* return */
