/******************************************************************************
* CharacterBaseline(font, character)
*
* Returns the baseline in pixels of "character" in "font".  This is the number
* of pixels from the top of the character cell to the baseline.
*
* C Interface:
*
*	int CharacterBaseline(font, character)
*	FONT font;
*	char character;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| font                            |  0 (L)
*	+---------------------------------+
*	|////////////////| character      |  6 (W)
*	+---------------------------------+
*
******************************************************************************/
	.text
	.globl	_CharacterBaseline
_CharacterBaseline:
	movl	sp@(4),a0		/* get font address */
	movb	sp@(7+4),d0		/* get character code */
	movb	a0@(7),d0		/* retrieve the y reference point */
	negb	d0			/* make positive */
	extw	d0			/* extend to word */
	extl	d0			/* extend to long for C */
	rts				/* return */
