/*
 * This file declares all of the needed space for variables used with 
 * virtual terminals.
 */
 
#include "types.h"		/* kernel type defs */
#include "errno.h"		/* error defines */
#include "../vt/vt_hdrs.h"	/* virtual terminal parameters */
#include "../vt/vt_output.h"	/* vt output defines */
#include "../vt/vt_kernel.h"	/* kernel only vt defines */
#include "../vt/vt_key.h"	/* external virtual key names */

short		globallut[LUTSIZE];	/* global lookup table */
char 		*copybuf;		/* pointer to copy/insert buffer */
char 		*vtpool;		/* pointer to freespace vt pool */
struct	tty	vt_tty[NVT+1];		/* virtual terminal array for sys */
struct	mark	vt_marks[NVT+1];	/* mark structures */
char		markneeded;
int		mactive, kactive; 	/* vtty that has mouse/keyboard */
int		*v_color[NCOLOR] =	/* system loaded colors/color table */
			{ white,black,gray50,gray25,gray75,gray12,gray87,
			gray37,gray62,invert };

int		iconf[NISTYLES][128];	/* storage for icon pixel maps faces */
int		iconm[NISTYLES][128];	/* storage for icon pixel maps masks */
int *		v_icon[] =		/* system loaded icon table */
			{0, 0, uarrow, darrow, larrow, rarrow, ulcorner, smooth,
			blast, lrcorner, };

struct itable	v_itable[NICON];
struct statline	v_status;		/* structure for status line */
struct popquiz	popquiz;		/* structure for popup menus */
struct trackcursor trackcursor;		/* structure for cursor tracking box */
unsigned char	Mdelta		= 1; 	/* Mouse response curve */
#ifdef	ZIPPYMOUSE
unsigned char	mousetab[VT_MTABSIZE+1] =
			{ 0, 1,  2,  3,  4,  7, 10, 13, 16, 19, 22, 25, 28, 
			31, 34, 37, 40, 43, 46, 49, 52, 55, 58, 61, 65, 69, 73,
			77, 81, 85, 87, 93,
			/* multiply all larger deltas by */ 4 };
#else	ZIPPYMOUSE
unsigned char	mousetab[VT_MTABSIZE+1] =
			{ 0, 1,  2,  3,  4,  5, 6, 7, 8, 9, 10, 11, 12, 
			13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
			27, 28, 29, 30, 31,
			/* multiply all larger deltas by */ 0 };
#endif	ZIPPYMOUSE
