#ifndef _VT_HDRS
#define _VT_HDRS

#ifdef KERNEL
#include "../machine/defs.h"		/* get macro definition */
#else					/**/
#include <machine/defs.h>		/* get macro definition */
#endif

/*
 *	Size defines needed for virtual terminals
 */
#define	VT_NNOTE	8	/* Number of notes in a vt */
#define	VT_NLEDS	4	/* Number of leds in a vt */
#define	VT_NSOFT	10	/* Number of soft funciton keys */
#define VT_SCHARS	16	/* Number chars in one soft key line */
#define VT_NCHOICES	20	/* Number of choices in popup menu */
#define VT_MTABSIZE	32	/* Size of the mouse response table */
#define VT_MAXTITLE	32	/* Number of characters in title */

#ifdef KERNEL
/* kernel mode typedefs and defines */

/* fonts, colors, windows, patterns and panes */
typedef unsigned short	Font;
typedef struct window * WINDOW;
typedef int	    	PANE;
typedef	int	    *	PATTERN;
typedef int	    	COLORT;

/* structure to hold pixels */
typedef struct
{
    short    width;
    short   *address;
} RASTER;

/* addressing values */
#define RELATIVE	0
#define ABSOLUTE	1

/* justification values */
#define	FLUSHLEFT	0
#define FLUSHRIGHT	1
#define CENTER		2

/* orientation/direction values */
#define	LEFT		0
#define RIGHT		1
#define UP		2
#define DOWN		3

/* Pane names */
#define	DISPLAY	    0
#define TITLE	    1
#define	TEDGE	    2		/* not used */
#define BEDGE	    3		/* not used */
#define	LEDGE	    4		/* not used */
#define REDGE	    5		/* not used */
#define	TLCORNER    6
#define	TRCORNER    7
#define BLCORNER    8		/* not used */
#define BRCORNER    9		/* not used */

/* Window types */
#define NOSHOW 		0
#define QUIZ		1
#define	NORMAL		2

/* Character attributes */
#define ULINE		0x01
#define CLEARBACK 	0x02
#define BOLD		0x04
#define RVIDEO		0x08

/* String position attributes */
#define STREND		-2
#define STRBEG		-1

/* Window Management Primitives */
extern WINDOW	    CreateWindow();
extern		    DestroyWindow();
extern		    ChangeWindowPosition();
extern		    GetWindowPosition();
extern		    ChangeWindowSize();
extern		    GetWindowSize();
extern		    ChangeWindowDepth();
extern		    GetWindowDepth();
extern WINDOW	    DesktopWindow();

/* Pane primitives */
extern		    SetWindowTitle();
extern		    SetPaneColors();
extern		    SetPaneGlyph();

/* Mapping Primitives */
extern bool	    WithinWindow();
extern		    ContainingWindow();
extern bool	    WithinPane();
extern		    ContainingPane();
extern		    MapCoordinates();

/* Position Pointer Primitives */
extern		    SetPosition();
extern		    SetXPosition();
extern		    SetYPosition();
extern		    BumpPosition();
extern		    BumpXPosition();
extern		    BumpYPosition();

/* Attribute Control Primitives */
extern		    SetAddressing();
extern		    SetColor();
extern		    SetBColor();
extern		    SetPattern();
extern		    SetBPattern();
extern		    SetPhase();
extern		    SetFont();
extern		    SetJustification();
extern		    SetThickness();

/* Painting Primitives */
extern		    PaintString();
extern		    PaintRectangleInterior();
extern		    PaintRectangleBorder();
extern		    PaintIcon();
extern		    PaintPolygonInterior();
extern		    PaintLine();
extern		    PaintCircleBorder();
extern		    PaintCircleInterior();
extern		    PaintArcBorder();
extern		    PaintArcInterior();

/* Region Primitives */
extern 		    CopyRegion();
extern		    InvertRegion();

/* Cursor Primitives */
extern		    DefineGlobalCursor();
extern		    DefineLocalCursor();
extern		    MoveGlobalCursor();
extern		    MoveLocalCursor();
extern		    HideGlobalCursor();
extern		    ShowGlobalCursor();
extern		    HideLocalCursor();
extern		    ShowLocalCursor();
extern		    DisplayGlobalRubberBox();
extern		    RemoveGlobalRubberBox();

/* Font Primitives */
extern int 	    CharacterWidth();
extern int	    CharacterHeight();
extern int	    CharacterBaseline();
extern int	    SetCharacterAttributes();

/* Get state primatives */
extern	int	    GetCurrentPosition();
extern  int	    GetCurrentAddressing();
extern	int	    GetCurrentPhase();
extern  int 	    GetCurrentFont();
extern  int	    GetCurrentColors();
extern	int	    GetStringAttributes();
extern	int	    GetLineAttributes();
extern	int 	    GetCharacterAttributes();
extern	int	    GetPermanentClipping();
extern	int	    GetTemporaryClipping();

/* Internal routines */
extern		    InitializeScreen();
extern		    TerminateScreen();
extern		    SetClipping();
extern		    ClearArea();
extern		    InvertArea();
extern		    CopyArea();

/* Internal Draw primatives */
extern		    DrawCharacter();
extern		    DrawRectangleInterior();
extern		    DrawRectangleBorder();

extern		    Sendtones();

/* Colors */
extern	int	    black[];
extern	int	    gray12[];
extern	int	    gray25[];
extern	int	    gray37[];
extern	int	    gray50[];
extern	int	    gray62[];
extern	int	    gray75[];
extern	int	    gray87[];
extern	int	    white[];
extern	int	    solid[];
extern	int	    invert[];

#define	BLACK	    0
#define WHITE	    1
#define GRAY50	    2

/* glyphs */
extern	int	    rarrow[];
extern	int	    larrow[];
extern	int	    uarrow[];
extern	int	    darrow[];
extern	int	    cloud[];
extern	int	    smooth[];
extern	int	    blast[];
extern	int	    lrcorner[];
extern	int	    ulcorner[];

/* Screen dimensions */
extern	int	    SCREENX;
extern	int	    SCREENY;
extern	int	    SCREENW;
extern	int	    SCREENH;

/* Physical screen */
extern RASTER screen;
extern RASTER screen0;
extern RASTER screen1;
extern RASTER screen2;
extern RASTER screen3;
#define SCREEN	(&screen)

/* offset to end of visable screen, and length of non-visiable memory */
extern int offscreen_off;
extern int offscreen_len;

/* Video Colors */

/* Size defines for vts */
#define	    NVT	    17	    /* Number of windows allowed */
#define     NCOLOR  16	    /* Number of system loaded colors, 9 predefined */
#define	    NISTYLES 64	    /* Number of unique icon styles */
#define	    NICON   128	    /* Number of system loaded icons, 9 predefined  */
#define	    ACTSIZ  32	    /* Size of an action table in bytes */
			    /* Size of freespace pool for screen display    */
#define     VTSIZE  ((1024*24)+(NVT*4096))

#define	    LUTSIZE 16	    /* size of color lookup table */
#define     NFONT   4	    /* Number of system loaded fonts, 4 predefined  */
#else
/* non kernel typedefs and defines */

/* fonts, colors, windows, patterns and panes */
typedef unsigned short	VT_FONTID;	    /* ID for a particular font */
typedef	int		VT_WINDOW;	    /* window = file descriptor */
typedef	unsigned char	VT_PANEID;	    /* pane window, same as kernel */
typedef	long		*VT_PATTERN;	    /* pointer to bit pattern */
typedef short		VT_COLOR;	    /* index for a particular color */
typedef	short		VT_NOTE;	    /* speaker note */

/* size of a bit pattern in bits */
#define	VT_PATTERNSIZE	32

/* structure to hold pixels */
typedef struct
{
    short    width;
    short   *address;
} RASTER;

/* addressing values */
#define VT_RELATIVE	0
#define VT_ABSOLUTE	1

/* justification values */
#define	VT_FLUSHLEFT	0
#define VT_FLUSHRIGHT	1
#define VT_CENTER	2

/* orientation/direction values */
#define	VT_FACELEFT	0
#define VT_FACERIGHT	1
#define VT_FACEUP	2
#define VT_FACEDOWN	3

#define	VT_MOVELEFT	0
#define VT_MOVERIGHT	1
#define VT_MOVEUP	2
#define VT_MOVEDOWN	3

/* Pane names */
#define	VT_DISPLAY	0
#define VT_TITLE	1
#define	VT_TEDGE	2
#define VT_BEDGE	3
#define	VT_LEDGE	4
#define VT_REDGE	5
#define	VT_TLCORNER	6
#define	VT_TRCORNER     7
#define VT_BLCORNER     8
#define VT_BRCORNER     9

/* Character attributes */
#define VT_ULINE	0x01	/* start underline */
#define VT_CLEARBACK 	0x02	/* clear out background */
#define VT_BOLD		0x04	/* bold */
#define VT_RVIDEO	0x08	/* reverse video */

/* String position attributes */
#define VT_STREND	-2	/* move pointer to end of string after write */
#define VT_STRBEG	-1	/* do not move pointer after write */

#endif

/* Color names */
#define VT_Black	0
#define VT_White	1
#define VT_Gray50	(-2)
#define VT_Gray25	(-3)
#define VT_Gray75	(-4)
#define VT_Gray12	(-5)
#define VT_Gray87	(-6)
#define VT_Gray37	(-7)
#define VT_Gray62	(-8)
#define VT_Invert	(-9)

#endif
