/*
 * This file contains all the templates for the 64-byte WIPC request/reply
 *  messages.  The contents of all the structures are aligned such that
 *  the offsets of the elements should be the same for the 68K or the VAX.
 *  Make sure all 32-bit elements remain aligned on quad boundries!
 *  Otherwise we'll never be able to talk to the VAX.
 *  The first element of each message structure is an 8-bit rcode,
 *  which is used to determine which structure template to use to
 *  decipher the rest of the message.
 */

/*
 * Request numbers
 */
#define	RQ_CONNECT	1
#define	RQ_DISCONNECT	2
#define	RQ_GET_IN_ADDR	3
#define	RQ_ALIVE	4

#define	RQ_SWAP		9

#define	RQ_FORK		10
#define	RQ_EXIT		11
#define	RQ_CHEXEC	12
#define	RQ_LOAD		13
#define	RQ_OPEN		14
#define	RQ_CLOSE	15
#define	RQ_RW		16
#define	RQ_SEEK		18
#define	RQ_STAT		19
#define	RQ_ACCESS	20
#define	RQ_IOCTL	21
#define	RQ_SELECT	22
#define	RQ_CHDIR	23
#define	RQ_LINK		25
#define	RQ_UNLINK	26
#define	RQ_RDLINK	27
#define	RQ_RENAME	28
#define	RQ_MKNOD	29
#define	RQ_MKDIR	30
#define	RQ_RMDIR	31
#define	RQ_CHOWN	32
#define	RQ_CHMOD	33
#define	RQ_TRUNC	34
#define	RQ_TIMES	35
#define	RQ_FSYNC	36
#define	RQ_FLOCK	37
#define	RQ_LOCKF	38
#define	RQ_GETDIR	39		/* NFS: */
#define	RQ_STATFS	40		/* NFS: */
#define	RQ_UNP_BIND	41
#define	RQ_UNP_CONNECT	42
#define	RQ_UNP_DETACH	43
#define	RQ_CORE		44

#define	RQ_SYSV_STATFS	45		/* SYSV: */
#define	RQ_GETDENTS	46		/* SYSV: */
#define	RQ_FCNTL	47		/* NFS: SYSV: */
#define	RQ_SYSV_IOCTL	48		/* SYSV: */
#define	RQ_SYSV_LSEEK	49		/* SYSV: */
#define	RQ_PLOAD	50		/* SYSV: */
#define	RQ_GETHEAD	51		/* SYSV: */
#define	RQ_GETLINK	52
#define	RQ_SYSV_STAT	53		/* SYSV: */

/* NOTE: this structure has the same format as u.u_cred!! */
struct	user_id {			/* id info provided with pathnames */
	uid_t	uid;			/* current effective user id */
	gid_t	gid;			/* current effective group id */
	uid_t	ruid;			/* real user id */
	gid_t	rgid;			/* real group id */
#define	TRFS_NGROUPS	NGROUPS		/* NOTE: if TRFS_NGROUPS != NGROUPS */
					/* then some repairs are in order!! */
	gid_t	groups[TRFS_NGROUPS];	/* group list */
};

uid_t trfs_rootuid;

struct msg_connect {			/* also used for disconnect messages */
	struct wmsg_hdr	h;
	unsigned long	rmid;
	unsigned short	pklen;
	unsigned char	pkburst;
	unsigned char	ix;		/* filled in by receiver */
	long		sec;
	long		usec;
	char		naddr[8];	/* filled in by receiver */
	char		mname[WMSG_SZ - sizeof(struct wmsg_hdr) - 24];
};

struct	rq_get_in_addr {
	struct wmsg_hdr	h;
	char		mname[32];
	char		addbuf[24];	/* ret: internet address string */
};

struct	rq_swap {
	struct wmsg_hdr	h;
	struct wmsg_seg	buf;
	unsigned long	blkno;
	unsigned short	devx;
};

struct	rq_fork {
	struct wmsg_hdr	h;
	unsigned short	cdirmid;
	unsigned short	rdirmid;
	unsigned long	rpid;		/* ret: rpid of cousin server */
};

struct	rq_chexec {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct wmsg_seg	exbuf;
	struct user_id	id;
	short		newimage;
};

struct	rq_load {
	struct wmsg_hdr	h;
	struct wmsg_seg	buf;
	unsigned long	offset;
};

struct	rq_open {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	union {
	    struct user_id	id;
	    struct {
		unsigned long	dev;
		unsigned long	inum;
		unsigned long	rdev;
		unsigned long	mode;
	   }			is;
	} rq_u;
	unsigned short	accessmode;
	unsigned short	createmode;
	short		rfd;		/* ret: cousin's file descriptor */
};

struct	rq_close {
	struct wmsg_hdr	h;
	short		rfd;
};

struct	rq_exit {
	struct wmsg_hdr	h;
	long		rval;
};

struct	rq_rw {
	struct wmsg_hdr	h;
	struct wmsg_seg	buf;
	long		offset;
	long		maxfsize;
	short		rfd;
};

struct	rq_ioctl {
	struct wmsg_hdr	h;
	struct wmsg_seg	buf;
	struct user_id	id;
	long		com;
	short		rfd;
};

struct	rq_select {
	struct wmsg_hdr	h;
	short		rfd;
	short		flag;
};

struct	rq_stat {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct wmsg_seg	buf;
	struct user_id	id;
	short		rfd;
	short		follow;
};

struct	rq_access {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct user_id	id;
	unsigned short	mode;
};

struct	rq_chdir {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct user_id	id;
	unsigned short	onoff;
};

struct	rq_unlink {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct user_id	id;
};

struct	rq_link {
	struct wmsg_hdr	h;
	struct wmsg_seg	target;
	struct wmsg_seg	linkname;
	struct user_id	id;
};

struct	rq_readlink {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct wmsg_seg	buf;
	struct user_id	id;
};

struct	rq_rename {
	struct wmsg_hdr	h;
	struct wmsg_seg	from;
	struct wmsg_seg	to;
	struct user_id	id;
};

struct	rq_mknod {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct user_id	id;
	unsigned short	mode;
	unsigned short	dev;
};

struct	rq_mkdir {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct user_id	id;
	unsigned short	mode;
};

struct	rq_rmdir {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct user_id	id;
};

struct	rq_chmod {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct user_id	id;
	short		rfd;
	unsigned short	mode;
};

struct	rq_chown {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct user_id	id;
	short		rfd;
	uid_t		uid;
	gid_t		gid;
};

struct	rq_truncate {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct user_id	id;
	long		len;
	short		rfd;
};

struct	rq_times {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct wmsg_seg	tv;
	struct user_id	id;
};

struct	rq_fsync {
	struct wmsg_hdr	h;
	short		rfd;
};

struct	rq_flock {
	struct wmsg_hdr	h;
	long		how;
	short		rfd;
};

struct	rq_lockf {
	struct wmsg_hdr	h;
	long		flag;
	unsigned long	size;
	off_t 		offset;
	short		rfd;
};

struct	rq_getdir {
	struct wmsg_hdr	h;
	struct wmsg_seg	buf;
	struct wmsg_seg	basep;
	long		offset;
	long		rval;
	short		rfd;
};

struct	rq_statfs {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct wmsg_seg	buf;
	struct user_id	id;
	short		rfd;
};

struct	rq_fcntl {
	struct wmsg_hdr	h;
	struct wmsg_seg	buf;
	int		cmd;
	int		arg;
	off_t		offset;
	short		rfd;
};

struct	rq_unp_bind {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct user_id	id;
	unsigned long	so;
	short		rfd;
};

struct	rq_unp_connect {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct user_id	id;
	unsigned long	so;
};

struct	rq_unp_detach {
	struct wmsg_hdr	h;
	short		rfd;
};

struct	rq_core {
	struct wmsg_hdr	h;
	struct wmsg_seg	buf;
	long		offset;
};

#ifdef	SYSV

struct	rq_sysv_statfs {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct wmsg_seg	buf;
	struct user_id	id;
	u_short		len;
	u_char		fstyp;		/* always 0 now */
	u_char		rfd;		/* precludes > 256 open files */
};

struct	rq_getdents {
	struct wmsg_hdr	h;
	struct wmsg_seg	buf;
	long		offset;
	long		rval;
	short		rfd;
};

struct	rq_sysv_ioctl {
	struct wmsg_hdr	h;
	struct user_id	id;
	int		cmd;
	long		arg;
	short		rfd;
};

struct	rq_sysv_lseek {
	struct wmsg_hdr	h;
	off_t		off;
	int		sbase;
	off_t		voffset;
	off_t		foffset;
	short		rfd;
};

struct	rq_pload {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct wmsg_seg	buf;
	off_t		offset;
};

struct	rq_gethead {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct wmsg_seg	buf;
};

#endif	SYSV

struct	rq_getlink {
	struct wmsg_hdr	h;
	struct wmsg_seg	path;
	struct wmsg_seg	buf;
	struct user_id	id;
	short		follow;
	short		cindex;
};
