/*
 *	For RFS loop back driver
 *		3/27/87
 */


#define	LOOP_MAXTSDUSIZE	4096
					/* max TSDU size         */
#define	LOOP_MAXETSDUSIZE	4096
					/* max ETSDU size        */
#define	LOOP_MAXCDATASIZE	-2
					/* max connect data size */
#define	LOOP_MAXDDATASIZE	-2
					/* max discon data size  */
#define	LOOP_MAXADDRSIZE	8
					/* address size, basically two ints */
#define	LOOP_MAXOPTSIZE		-2
					/* options size	not supported */
#define	LOOP_MAXTIDUSIZE	4096
					/* max TIDU size         */
#define	LOOP_SERVTYPE		T_COTS_ORD
					/* provider service type */

struct loop {
	int	lup_flags;
	uint	lup_state;	/* TI state */
	uint	lup_baddr[2];	/* address that is bound */
#define	NETADDR		0
#define	PORTADDR	1
	int	lup_qlen;	/* #of outstanding connects */
	int	lup_aqlen;	/* #of outstanding connects allowed */
	queue_t	*qptr; /* back ptr to write queue */
	queue_t	*oqptr; /* pointer to connected read queue */
};

/* Minimum and Maximum port numbers when the provider has to search
 * for an address for binding. These two numbers just random choice.
 * May either change later or disappear altogether.
 */
#define	LOOP_MINPORTNO	10
#define	LOOP_MAXPORTNO	1024

/* flags */
#define	LOOP_INUSE	(1<<0)
#define	LOOP_CHST	(1<<1)
#define	LOOP_BOUND	(1<<2)
#define	LOOP_CONNECTED	(1<<3)
#define	LOOP_DISCONNECTED	(1<<4)

#define	MAX_REPLYSIZ	(sizeof(union T_primitives)+LOOP_MAXADDRSIZE)
				/* As options are unsupported */
#define	makerr(x,y)	((x<<16)|y)
#define	PLOOP		(PZERO+2)	/* Priority for sleeping */
