
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)file.h	7.1 (Berkeley) 6/4/86
 */

#ifdef KERNEL
#include "../h/fcntl.h"
#else KERNEL
#include <sys/fcntl.h>
#endif KERNEL

#ifdef KERNEL
/*
 * Descriptor table entry.
 * One for each kernel object.
 */
struct	file {
#ifdef vax
	int	f_flag;		/* see below */
	short	f_type;		/* descriptor type */
#endif vax
#ifdef is68k
	short	f_flag;		/* see below */
	char	f_type;		/* descriptor type */
	char	f_rfdes;	/* ISI: TRFS: remote cousin's file descriptor */
	u_short	f_mid;		/* ISI: TRFS: machine id */
#endif is68k
	short	f_count;	/* reference count */
	short	f_msgcount;	/* references from message queue */
	struct	fileops {
		int	(*fo_rw)();
		int	(*fo_ioctl)();
		int	(*fo_select)();
		int	(*fo_close)();
	}	*f_ops;
	caddr_t	f_data;		/* ptr to file specific struct (vnode/socket) */
	off_t	f_offset;
#ifdef is68k
	struct ucred	*f_cred;/* ISI: NFS: credentials of who opened file */
	u_long 	f_rmid;		/* ISI: TRFS: remote machine id */
	int	f_offset_sysv;	/* ISI: SYSV: */
	int	f_offset_buf;	/* ISI: SYSV: */
#endif is68k
};

struct	file *file, *fileNFILE;
int	nfile;
struct	file *getf();
struct	file *falloc();
#endif

/*
 * flags- also for fcntl call.
 */
#define	FOPEN		(-1)
#define	FREAD		00001		/* descriptor read/receive'able */
#define	FWRITE		00002		/* descriptor write/send'able */
#ifndef	FNDELAY
#define	FNDELAY		00004		/* no delay */
#define	FAPPEND		00010		/* append on each write */
#endif
#define	FMARK		00020		/* mark during gc() */
#define	FDEFER		00040		/* defer for next gc pass */
#ifndef	F_DUPFD
#define	FASYNC		00100		/* signal pgrp when data ready */
#endif
#define	FSHLOCK		00200		/* shared lock present */
#define	FEXLOCK		00400		/* exclusive lock present */
#define	FNONIDEM	020000		/* ISI: TRFS: io is nonidempotent */
#define	FSELTRUE	040000		/* ISI: select always returns true */

/* bits to save after open */
#define	FMASK		00113
#define	FCNTLCANT	(FREAD|FWRITE|FMARK|FDEFER|FSHLOCK|FEXLOCK|FSELTRUE)

/* open only modes */
#define	FCREAT		01000		/* create if nonexistant */
#define	FTRUNC		02000		/* truncate to zero length */
#define	FEXCL		04000		/* error if already created */

/*
 * Flock call.
 */
#define	LOCK_SH		1	/* shared lock */
#define	LOCK_EX		2	/* exclusive lock */
#define	LOCK_NB		4	/* don't block when locking */
#define	LOCK_UN		8	/* unlock */

/*
 * ISI: LOCKF call.
 */
#define	LOCKF_UNLOCK	0	/* unlock a region */
#define	LOCKF_LOCK	1	/* lock a region */
#define	LOCKF_TLOCK	2	/* test and lock a region */
#define	LOCKF_TEST	3	/* test a region */

/*
 * Access call.
 */
#define	F_OK		0	/* does file exist */
#define	X_OK		1	/* is it executable by caller */
#define	W_OK		2	/* writable by caller */
#define	R_OK		4	/* readable by caller */

/*
 * Lseek call.
 */
#define	L_SET		0	/* absolute offset */
#define	L_INCR		1	/* relative to current offset */
#define	L_XTND		2	/* relative to end of file */

#ifdef	is68k
/* System-V record-locking options */
/* lockf(2) requests */
#define F_ULOCK 0       /* Unlock a previously locked region */
#define F_LOCK  1       /* Lock a region for exclusive use */ 
#define F_TLOCK 2       /* Test and lock a region for exclusive use */
#define F_TEST  3       /* Test a region for other processes locks */

/* file locking structure (connected to inode) */

#define NRLOCKS	192			/* number of locks in system */
#define l_end 		l_len
#define MAXEND  	017777777777

struct	filock	{
	struct	flock set;	/* contains type, start, and end */
	union	{
		int wakeflg;	/* for locks sleeping on this one */
		struct {
			short sysid;
			short pid;
		} blk;			/* for sleeping locks only */
	}	stat;
	struct	filock *prev;
	struct	filock *next;
};
#endif	is68k

#ifdef KERNEL
#define	GETF(fp, fd) { \
	if ((unsigned)(fd) >= NOFILE || ((fp) = u.u_ofile[fd]) == NULL) { \
		u.u_error = EBADF; \
		return; \
	} \
}

#define	DTYPE_VNODE	1	/* file */
#define	DTYPE_SOCKET	2	/* communications endpoint */
#define	DTYPE_TRFS	3	/* ISI: TRFS: remote file */
#endif
