#ifdef	SYSV
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/


#include "../h/types.h"

#include	"../h/param.h"
#include	"../h/user.h"
#include 	"../h/systm.h"
#include 	"../h/dir.h"
#include 	"../h/kernel.h"
#include 	"../h/proc.h"
#include 	"../h/vnode.h"
#include 	"../h/file.h"
#include 	"../h/stat.h"
#include	"../h/ioctl.h"
#undef	NFS
#include 	"../h/mount.h"

#include "../h/uio.h"
#include "../h/vfs.h"
#include "../h/pathname.h"

#include	"../sysv/sys/filehdr.h"
#include 	"../sysv/sys/stat.h"
#include 	"../sysv/sys/statfs.h"
#include 	"../sysv/sys/ttold.h"
#include 	"../sysv/sys/fcntl.h"
#include 	"../sysv/sys/message.h"
#include 	"../sysv/sys/errno.h"

/*
 * Oh, how backwards compatibility is ugly!!!
 */
sysv_fstat(uap)
	register struct a {
		int	fd;
		struct sysv_stat *sb;
	} *uap;
{
	register struct file *fp;
	struct stat ub;
	struct sysv_stat sub;
	struct vnode *vp;

	GETF(fp, uap->fd);
	switch (fp->f_type) {

	case DTYPE_VNODE:
		u.u_error = vno_stat((struct vnode *)fp->f_data, &ub);
		break;

	case DTYPE_SOCKET:
		u.u_error = soo_stat((struct socket *)fp->f_data, &ub);
		break;

	default:
		panic("sysv_fstat");
		/*NOTREACHED*/
	}
	if (u.u_error == 0) {
		sub.st_dev = ub.st_dev;
		sub.st_ino = (ushort)ub.st_ino;
		sub.st_mode = ub.st_mode;
		sub.st_nlink = ub.st_nlink;
		sub.st_uid = ub.st_uid;
		sub.st_gid = ub.st_gid;
		sub.st_rdev = ub.st_rdev;
		sub.st_atime = ub.st_atime;
		sub.st_mtime = ub.st_mtime;
		sub.st_ctime = ub.st_ctime;
		sub.st_size = ub.st_size;
		if (fp->f_type == DTYPE_VNODE) {
			vp = (struct vnode *)fp->f_data;
			if (vp->v_type == VDIR) {
				VN_HOLD(vp);
				u.u_error = bsd_to_sysv(vp, ub.st_size,
					&sub.st_size);
				VN_RELE(vp);
			} else if (vp->v_type == VCHR)
				sub.st_rdev = vp->v_rdev;
		}
		if (u.u_error == 0) 
			u.u_error = copyout((caddr_t)&sub, (caddr_t)uap->sb,
			    sizeof (sub));
	}
}


/*
 * Old stat system call.  This version follows links.
 */
sysv_stat(uap)
	register struct a {
		char	*fname;
		struct sysv_stat *sb;
	} *uap;
{
	struct vnode *vp = 0;

	u.u_error =
	    lookupname(uap->fname, UIOSEG_USER, FOLLOW_LINK,
		(struct vnode **)0, &vp);
	if (u.u_error)
		return;
	u.u_error = sysv_stat1(vp, uap->sb);
	VN_RELE(vp);
}

int
sysv_stat1(vp, ub)
	register struct vnode *vp;
	struct sysv_stat *ub;
{
	struct sysv_stat ds;
	struct vattr vattr;
	register int error;

	error = VOP_GETATTR(vp, &vattr, u.u_cred);
	if (error)
		return(error);
	/*
	 * Copy from inode table
	 */
	ds.st_dev = vattr.va_fsid;
	ds.st_ino = (short)vattr.va_nodeid;
	ds.st_mode = (u_short)vattr.va_mode;
	ds.st_nlink = vattr.va_nlink;
	ds.st_uid = (short)vattr.va_uid;
	ds.st_gid = (short)vattr.va_gid;
	ds.st_rdev = (dev_t)vattr.va_rdev;
	ds.st_atime = (int)vattr.va_atime.tv_sec;
	ds.st_mtime = (int)vattr.va_mtime.tv_sec;
	ds.st_ctime = (int)vattr.va_ctime.tv_sec;
	if (vp->v_type == VDIR)
		error = bsd_to_sysv(vp, (int)vattr.va_size, &ds.st_size);
	else
		ds.st_size = (int)vattr.va_size;
	if (error == 0)
		error = copyout((caddr_t)&ds, (caddr_t)ub, sizeof(ds));
	return(error);
}

/*
 * the fstatfs system call.
 */
sysv_fstatfs(uap)
	register struct a {
		int	fdes;
		struct	sysv_statfs *sb;
		int	len;
		int	fstyp;
	} *uap;
{
	struct file *fp;

	u.u_error = getvnodefp(uap->fdes, &fp);
	if (u.u_error == 0)
		statfs1(((struct vnode *)fp->f_data), uap->sb, uap->len,
				uap->fstyp);
}

/*
 * the statfs system call.
 */
sysv_statfs(uap)
	register struct a {
		char	*fname;
		struct	sysv_statfs *sb;
		int	len;
		int	fstyp;
	} *uap;
{
	struct vnode *vp;

	u.u_error =
	    lookupname(uap->fname, UIOSEG_USER, FOLLOW_LINK,
		(struct vnode **)0, &vp);
	if (u.u_error)
		return;
	statfs1(vp, uap->sb, uap->len, uap->fstyp);
	VN_RELE(vp);
}

/*
 * Common routine for fstatfs and statfs. (System V)
 */
statfs1(vp, ub, len, fstyp)
	register struct vnode *vp;
	register struct sysv_statfs *ub;
	int len, fstyp;
{
	struct statfs sb;
	struct sysv_statfs sv;

	bzero (&sb, sizeof (sb)); /* clear out the garbage */
	bzero (&sv, sizeof (sv));

	if (!vp || !vp->v_vfsp)
	  u.u_error = EINVAL;
	else if ((u.u_error = VFS_STATFS((vp->v_vfsp), &sb)) == 0) {
		sv.f_fstyp = sb.f_type;
		sv.f_bsize = sb.f_bsize;
		sv.f_blocks = sb.f_blocks;
		sv.f_bfree = sb.f_bavail;
		sv.f_files = sb.f_files;
		sv.f_ffree = sb.f_ffree;
		u.u_error = copyout ((caddr_t)&sv, (caddr_t)ub, len);
	}
}

/*
 * the dup system call.
 * Calls 4.3 logic to duplicate file descriptor
 */
sysv_dup(uap)
	register struct a {
		int	fdes;
	} *uap;
{

	uap->fdes &= 077;	/* There's no dup2 */
	dup(uap);
}

char sysv_mapfcntl[] = {		/* map system 5 fcntl's to BSD */
	F_DUPFD,
	F_GETFD,
	F_SETFD,
	F_GETFL,
	F_SETFL,
	F_GETLK,
	F_SETLK,
	F_SETLKW,
	F_CHKFL,
};

/*
 * the file control system call.
 */
sysv_fcntl(uap)
	register struct a {
		int	fdes;
		int	cmd;
		int	arg;
	} *uap;
{
	
	uap->cmd = sysv_mapfcntl[uap->cmd];
	switch (uap->cmd) {

	case F_DUPFD:
	case F_GETFD:
	case F_SETFD:
	case F_GETFL:
	case F_SETFL:
	case F_GETLK:
	case F_SETLK:
	case F_SETLKW:
		fcntl(uap);
		if (u.u_error == EDEADLK)
			u.u_error = EDEADLK_SV;
		else if (u.u_error == ENOLCK)
			u.u_error = ENOLCK_SV;
		break;

	default:
		u.u_error = EINVAL;
	}
}

/*
 * character special i/o control
 */
sysv_ioctl(uap)
	register struct a {
		int	fdes;
		int	cmd;
		int	arg;
	} *uap;
{
	register struct file *fp;
	int com = uap->cmd, size;
	char data[128];

	GETF(fp, uap->fdes);

	if (com & (IOC_INOUT|IOC_VOID)) { /* BSD ioctl comming from System V */
		/*
		 * Interpret high order word to find
		 * amount of data to be copied to/from the
		 * user's address space.
		 */
		size = (com &~ (IOC_INOUT|IOC_VOID)) >> 16;
		if (size > sizeof (data)) {
			u.u_error = EFAULT;
			return;
		}
		if (com&IOC_IN) {
			if (size == sizeof (int) && uap->arg == NULL)
			  *(int *)data = 0;
			else if (size > 0) {
				u.u_error =
				  copyin(uap->arg, (caddr_t)data, (u_int)size);
				if (u.u_error)
				  return;
			} else
			  *(caddr_t *)data = (caddr_t *)uap->arg;
		} else if ((com&IOC_OUT) && size)
		  	/*
		   	* Zero the buffer on the stack so the user
		   	* always gets back something deterministic.
		   	*/
		  	bzero((caddr_t)data, size);
		else if (com&IOC_VOID)
		  	*(caddr_t *)data = (caddr_t *)uap->arg;
		u.u_error = (*fp->f_ops->fo_ioctl)(fp, com, data);
		/*
		 * Copy any data to user, size was
		 * already set and checked above.
		 */
		if (u.u_error == 0 && (com&IOC_OUT) && size)
		  	u.u_error = copyout(data, uap->arg, (u_int)size);
	}
	else
	  	u.u_error = (*fp->f_ops->fo_ioctl)(fp, uap->cmd, uap->arg);
}

/*
 * old stty and gtty
 */
stty(uap)
	register struct a {
		int	fdes;
		int	arg;
		int	narg;
	} *uap;
{
	uap->narg = uap->arg;
	uap->arg = TIOCSETP;
	u.u_procp->p_systemcall = DUIOCTL;
	sysv_ioctl(uap);
}

gtty(uap)
	register struct a {
		int	fdes;
		int	arg;
		int	narg;
	} *uap;
{
	uap->narg = uap->arg;
	uap->arg = TIOCGETP;
	u.u_procp->p_systemcall = DUIOCTL;
	sysv_ioctl(uap);
}

/*
 * the mount system call.
 */
sysv_smount(uap)
	register struct a {
		char	*fspec;
		char	*freg;
		int	flags;
		int	fstyp;
	} *uap;
{
	register struct b {
		int	type;
		char	*dir;
		int	flags;
		caddr_t	data;
	} *nuap;
	struct	b b;

	/*
	 * The order of args for Bsd and System V are different
	 * Here we just change these orders and call Bsd.
	 */
	/*
	 * Backward compatibility: require the user program to
	 * supply a flag indicating a new-style mount, otherwise
	 * assume the fstyp of the root file system.
	 */
	/* Don't accept any types for now
	if ((uap->flags & MS_FSS) == 0)
		fstyp = mount[0].m_fstyp;
	else if ((fstyp = uap->fstyp) <= 0 || fstyp >= nfstyp) {
		u.u_error =  EINVAL;
		goto out;
	}
	******************************/

	nuap = &b;
	nuap->type = MOUNT_UFS;	/* Always?! */
	nuap->dir = uap->freg;
	nuap->flags = uap->flags;
	nuap->data = (caddr_t)uap->fspec;
	mount(nuap);
}

/* 
 * hack to check the validity of the special to be mounted upon BEFORE
 * the mount point is locked (temp., for the validation suite)
 */
sysv_checkmount(fspec)
char *fspec;
{
	dev_t dev;

	return getmdev(fspec, &dev);
}



/*
 * Seek on file.  Only hard operation
 * is seek relative to end which must
 * apply to vnode for current file size.
 * 
 * Note: lseek(0, 0, L_XTND) costs much more than it did before.
 */
sysv_lseek(uap)
	register struct a {
		int	fd;
		off_t	off;
		int	sbase;
	} *uap;
{
	struct file *fp;
	off_t	voffset, foffset;
	register struct vnode *vp;

	u.u_error = getvnodefp(uap->fd, &fp);
	if (u.u_error) {
		if (u.u_error == EINVAL)
			u.u_error = ESPIPE;	/* be compatible */
		return;
	}

	vp = (struct vnode *)fp->f_data;
	if (vp->v_type == VFIFO) {
		u.u_error = ESPIPE;
		return;
	}

	if (vp->v_type == VDIR) {
		switch (uap->sbase) {

		case L_INCR:
			if (vp->v_flag & VRFSNODE)
			  voffset = fp->f_offset + uap->off;
			else
			  voffset = fp->f_offset_sysv + uap->off;
			break;

		case L_XTND: {
			struct vattr vattr;
			u.u_error = VOP_GETATTR((struct vnode *)fp->f_data,
					&vattr, u.u_cred);
			if (u.u_error)
				return;
			u.u_error = bsd_to_sysv(vp, fp->f_offset, &voffset);
			voffset += uap->off;
			break;
		}

		case L_SET:
			voffset = uap->off;
			break;

		default:
			u.u_error = EINVAL;
		}
		if (u.u_error)
			return;
		u.u_error = sysv_to_bsd(vp, voffset, fp);
		u.u_r.r_off = voffset;
	} else {
		switch (uap->sbase) {

		case L_INCR:
			fp->f_offset += uap->off;
			break;

		case L_XTND: {
			struct vattr vattr;
			u.u_error = VOP_GETATTR((struct vnode *)fp->f_data,
					&vattr, u.u_cred);
			if (u.u_error)
				return;
			fp->f_offset = uap->off + vattr.va_size;
			break;
		}

		case L_SET:
			fp->f_offset = uap->off;
			break;

		default:
			u.u_error = EINVAL;
		}
		u.u_r.r_off = fp->f_offset;
	}
}

/*
 * NCR/UNIFY will call one of the Safari system calls.  I believe this
 * system call to be the old fsync() which we can nop.  Anyone else who
 * calls this routine should call nosys().
 */
ncrnullsys()
{
	if (u.u_filemagic != NCRMAGIC)
	  nosys();
}
#endif	SYSV
