/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
#ident	"@(#)kern-port:os/exec.c	10.19"
*/

#include "../h/types.h"
#include "../h/exec.h"
#include "../h/uio.h"
#include "../h/param.h"
#include "../sysv/sys/sbd.h"
#include "../sysv/sys/systm.h"
#include "../sysv/sys/map.h"
#include "../sysv/sys/psw.h"
#include "../h/user.h"
#include "../h/errno.h"
#include "../sysv/sys/errno.h"
#include "../sysv/sys/file.h"
#include "../sysv/sys/buf.h"
#include "../sysv/sys/fstyp.h"
#include "../sysv/sys/acct.h"
#include "../sysv/sys/sysinfo.h"
#include "../sysv/sys/reg.h"
#include "../sysv/sys/var.h"
#include "../sysv/sys/immu.h"
#include "../sysv/sys/region.h"
#include "../sysv/sys/proc.h"
#include "../sysv/sys/tuneable.h"
#include "../sysv/sys/cmn_err.h"
#include "../sysv/sys/debug.h"
#include "../sysv/sys/message.h"
#include "../sysv/sys/conf.h"

#include "../h/vnode.h"
#include "../h/pathname.h"

/*
 * Read the a.out headers.  There must be at least three sections,
 * and they must be .text, .data and .bss (although not necessarily
 * in that order).
 *
 * Possible magic numbers are 0410, 0411 (treated as 0410), and
 * 0413.  If there is no optional UNIX header then magic number
 * 0410 is assumed.
 */

#define	F_BM32ID  	0160000
#define	F_BM32B 	0020000
#define	F_BM32MAU	0040000
#define F_BM32RST	0010000 /* bit indicates a.out contains restore fix */

/*
 *   Common object file header
 */

/* f_magic (magic number)
 *
 *   NOTE:   For 3b-5, the old values of magic numbers
 *           will be in the optional header in the
 *           structure "aouthdr" (identical to old
 *           unix aouthdr).
 */

#define  M32MAGIC	0560

/* f_flags
 *
 *	F_EXEC  	file is executable (i.e. no unresolved 
 *	        	  externel references).
 *	F_AR16WR	this file created on AR16WR machine
 *	        	  (e.g. 11/70).
 *	F_AR32WR	this file created on AR32WR machine
 *	        	  (e.g. vax).
 *	F_AR32W		this file created on AR32W machine
 *	        	  (e.g. 3b,maxi).
 */
#define  F_EXEC		0000002
#define  F_AR16WR	0000200
#define  F_AR32WR	0000400
#define  F_AR32W	0001000

struct filehdr {
	ushort	f_magic;	
	ushort	f_nscns;	/* number of sections */
	long	f_timdat;	/* time & date stamp */
	long	f_symptr;	/* file pointer to symtab */
	long	f_nsyms;	/* number of symtab entries */
	ushort	f_opthdr;	/* sizeof(optional hdr) */
	ushort	f_flags;
};

/*
 *  Common object file section header
 */

/*
 *  s_name
 */
#define _TEXT ".text"
#define _DATA ".data"
#define _BSS  ".bss"
#define _LIB  ".lib"

/*
 * s_flags
 */
#define	STYP_TEXT	0x0020	/* section contains text only */
#define STYP_DATA	0x0040	/* section contains data only */
#define STYP_BSS	0x0080	/* section contains bss only  */
#define STYP_LIB	0x0800	/* section contains lib only  */

struct scnhdr {
	char	s_name[8];	/* section name */
	long	s_paddr;	/* physical address */
	long	s_vaddr;	/* virtual address */
	long	s_size;		/* section size */
	long	s_scnptr;	/* file ptr to raw	*/
				/* data for section	*/
	long	s_relptr;	/* file ptr to relocation */
	long	s_lnnoptr;	/* file ptr to line numbers */
	ushort	s_nreloc;	/* number of relocation	*/
				/* entries		*/
	ushort	s_nlnno;	/* number of line	*/
				/* number entries	*/
	long	s_flags;	/* flags */
};

/*
 * Common object file optional unix header
 */

struct aouthdr {
	short	o_magic;	/* magic number */
	short	o_stamp;	/* stamp */
	long	o_tsize;	/* text size */
	long	o_dsize;	/* data size */
	long	o_bsize;	/* bss size */
	long	o_entloc;	/* entry location */
	long	o_tstart;
	long	o_dstart;
};


sysv_gethead(vp, execp, exec_data)
struct   vnode  *vp;
register struct exec *execp;
register struct sysv_exdata *exec_data;
{
	struct filehdr filhdr;
	struct aouthdr aouthdr;
	struct scnhdr  scnhdr;
	int    opt_hdr = 0;
	int    scns    = 0;
	int    offset ;  /* Current offset in file when reading 
			    section headers */


	exec_data->vp = NULL;

	/*
	 * First, read the file header
	 */

	vn_rdwr(UIO_READ,vp,(caddr_t)&filhdr,sizeof(filhdr),
		0,UIOSEG_KERNEL,IO_UNIT,(int *)0);
	/*
	 * Next, read the optional unix header if present; if not,
	 * then we will assume the file is a 410.
	 */

	if (filhdr.f_opthdr >= sizeof(aouthdr)) {
		if (vn_rdwr(UIO_READ,vp,(caddr_t)&aouthdr,sizeof(aouthdr),
			sizeof(filhdr),UIOSEG_KERNEL,IO_UNIT,(int *)0)) {
				u.u_error = ENOEXEC;
				goto bad;

		};
		

		opt_hdr = 1;
		exec_data->a_mag = execp->a_magic= aouthdr.o_magic;
		execp->a_entry= aouthdr.o_entloc;
	};

	/*
	 * Next, read the section headers; there had better be at
	 * least three: .text, .data and .bss. The shared library
	 * section is optional, initialize the number needed to 0.
	 */

	exec_data->a_nshlibs = 0;
	offset = sizeof(filhdr) + filhdr.f_opthdr ;
	while (filhdr.f_nscns-- > 0) {

		if (vn_rdwr(UIO_READ,vp,(caddr_t)&scnhdr,sizeof(scnhdr),
			offset,UIOSEG_KERNEL,IO_UNIT,(int *)0)) {

			u.u_error = ENOEXEC;
			goto bad;
		}

		offset += sizeof(scnhdr);
		switch ((int) scnhdr.s_flags) {

		case STYP_TEXT:
			scns |= STYP_TEXT;

			if (!opt_hdr) {
				execp->a_magic= 0410;
				execp->a_entry= scnhdr.s_vaddr;
			}
			exec_data->a_txtorg = scnhdr.s_vaddr;
			exec_data->a_toffset = scnhdr.s_scnptr;
			exec_data->a_tsize = execp->a_text = scnhdr.s_size ;
			break;

		case STYP_DATA:
			scns |= STYP_DATA;
			exec_data->a_datorg = scnhdr.s_vaddr;
			exec_data->a_doffset = scnhdr.s_scnptr;
			exec_data->a_dsize = execp->a_data = scnhdr.s_size ;
			break;

		case STYP_BSS:
			scns |= STYP_BSS;
			exec_data->a_bssorg = scnhdr.s_vaddr;
			exec_data->a_bsize = execp->a_bss = scnhdr.s_size ;
			break;

		case STYP_LIB:
			++shlbinfo.shlblnks;

			if ((exec_data->a_nshlibs = scnhdr.s_paddr) > shlbinfo.shlbs) {
				++shlbinfo.shlbovf;
				u.u_error = ELIBMAX;
				goto bad;
			}

			exec_data->a_lsize = scnhdr.s_size;
			exec_data->a_loffset = scnhdr.s_scnptr;
			break;
		}
	}

	if (scns != (STYP_TEXT|STYP_DATA|STYP_BSS)) {
		u.u_error = ENOEXEC;
		goto bad;
	}
	exec_data->vp = vp;
	return(0);
bad:
	return(-1);
}

sysv_getshlibs(bp, dat_start, svep)
unsigned *bp;
struct sysv_exdata *dat_start;
struct sysv_exdata *svep;

{
	struct   vnode  *vp  = svep->vp, *lbvp= NULL;
	struct   sysv_exdata *dat = dat_start;
	unsigned nlibs = svep->a_nshlibs;
	unsigned rem_wrds;
	unsigned n = 0;
	struct exec exec_data;
	struct pathname pn;
	struct pathname *pnp = &pn;

	if (u.u_error = vn_rdwr(UIO_READ, vp, (caddr_t)bp, svep->a_lsize,
		svep->a_loffset,UIOSEG_KERNEL,IO_UNIT,(int *)0)) 
		goto bad;

	while ((bp < (unsigned int *)dat) && (n < nlibs)) {

		/* Check the validity of the shared lib entry. */

		if ((bp[0] > (rem_wrds = (unsigned int *)dat_start - bp)) ||
		    (bp[1] > rem_wrds) || (bp[0] < 3)) {
			u.u_error = ELIBSCN;
			goto bad;
		}

		/* Locate the shared lib and get its header info.  */
		if (u.u_error = pn_get(bp + bp[1], UIOSEG_KERNEL, pnp))
			goto bad;

		u.u_error = lookuppn(pnp, FOLLOW_LINK, 
					(struct vnode **)0, &lbvp);

		pn_free(pnp);
		if (u.u_error) {
			u.u_error = ELIBACC;
			goto bad;
		}

		if (sysv_gethead(lbvp, &exec_data, dat)) {
			if (u.u_error == EACCES)
				u.u_error = ELIBACC;
			else if (u.u_error != ENOMEM)
				u.u_error = ELIBBAD;
			VN_RELE(lbvp);
			goto bad;
		}

		if (dat->a_mag != 0443) {
			u.u_error = ELIBBAD;
			VN_RELE(lbvp);
			goto bad;
		}

		bp += bp[0];
		++dat;
		++n;
	}

	if (n != nlibs) {
		u.u_error = ELIBSCN;
		goto bad;
	}

	return(0);
bad:
	while (n--) {
		VN_RELE(dat_start->vp);
		dat_start++->vp = NULL;
	}
	return(-1);
}


sysv_loadshlibs(bp, dat, ep)
unsigned *bp;
struct sysv_exdata *dat;
struct sysv_exdata *ep;
{
	return loadshlibs(bp, dat, ep, 0);
}

loadshlibs(bp, dat, ep, rpid)
unsigned *bp;
struct sysv_exdata *dat;
struct sysv_exdata *ep;
int rpid;				/* TRFS: remote machine id */
{
	unsigned nlibs = ep->a_nshlibs;

	if (u.u_procp->p_region = preg_alloc()) {
		while (nlibs) {
#ifdef	TRFS
			if (rpid) {
				if (trfs_preg_getxfile(rpid, bp + bp[1], dat))
					return -1;
				bp += bp[0];
			} else
#endif	TRFS
			if (preg_getxfile(dat))
				return(-1);
			dat++;
			nlibs--;
		}
		return(0);
	} else {
		return(-1);
	}
}

#ifdef	TRFS
trfs_getshlibs(rpid, path, bp, dat_start, svep)
unsigned long rpid;
char *path;
unsigned *bp;
struct sysv_exdata *dat_start;
struct sysv_exdata *svep;

{
	struct   sysv_exdata *dat = dat_start;
	unsigned nlibs = svep->a_nshlibs;
	unsigned rem_wrds;
	unsigned n = 0;
	struct exec exec_data;
	struct pathname pn, *pnp;

	if (u.u_error = pn_get(path, UIOSEG_USER, &pn))
		return -1;
	pnp = u.u_tpnp;
	u.u_tpnp = (struct pathname *)0;
	if (u.u_tok = (setjmp(&u.u_tsave) == 0)) {
		lookuppn(&pn, FOLLOW_LINK, 
				(struct vnode **)0, (struct vnode **)0);
		u.u_error = ENOEXEC;
		pn_free(&pn);
		u.u_tpnp = pnp;
		u.u_tok = 0;
		return -1;
	}
	if (u.u_error = ClPload(rpid, pn.pn_path, (caddr_t)bp,
			svep->a_lsize, svep->a_loffset, UIOSEG_KERNEL)) {
		pn_dfree(u.u_tpnp);
		u.u_tpnp = pnp;
		return -1;
	}
	pn_dfree(u.u_tpnp);
	u.u_tpnp = pnp;
	while ((bp < (unsigned int *)dat) && (n < nlibs)) {

		/* Check the validity of the shared lib entry. */

		if ((bp[0] > (rem_wrds = (unsigned int *)dat_start - bp)) ||
		    (bp[1] > rem_wrds) || (bp[0] < 3)) {
			u.u_error = ELIBSCN;
			return -1;
		}

		/* Locate the shared lib and get its header info.  */
		if (u.u_error = ClGethead(rpid, bp + bp[1], &exec_data, dat)) {
			if (u.u_error == EACCES)
				u.u_error = ELIBACC;
			else if (u.u_error != ENOMEM)
				u.u_error = ELIBBAD;
			return -1;
		}

		if (dat->a_mag != 0443) {
			u.u_error = ELIBBAD;
			return -1;
		}

		bp += bp[0];
		++dat;
		++n;
	}

	if (n != nlibs) {
		u.u_error = ELIBSCN;
		return -1;
	}

	return(0);
}

trfs_loadshlibs(rpid, bp, dat, ep)
unsigned long rpid;
unsigned *bp;
struct sysv_exdata *dat;
struct sysv_exdata *ep;
{
	return loadshlibs(bp, dat, ep, rpid);
}
#endif	TRFS
