/*
 * rfs_subr.c	87/02/23
 */

#if	defined(SYSV) && defined(RFS)
#include "../h/param.h"
#include "../h/user.h"
#include "../h/vfs.h"
#include "../h/vnode.h"
#include "../h/proc.h"
#include "../ufs/inode.h"
#include "../ufs/fs.h"
#include "../h/uio.h"
#include "../sysv/sys/sema.h"
#include "../sysv/sys/comm.h"
#include "../sysv/sys/rfsnode.h"
#include "../sysv/sys/mount.h"
#include "../sysv/sys/rdebug.h"
/*************************
#include "../h/systm.h"
#include "../h/kernel.h"
#include "../h/buf.h"
#include "../h/socket.h"
#include "../h/socketvar.h"
#include "../net/if.h"
#include "../netinet/in.h"
#include "../h/stat.h"
#include "../h/uio.h"
#include "../net/if.h"
#include "../netinet/in.h"
*********************************/

extern struct vnodeops rfs_vnodeops;
struct rfsnode *rfsfind();
extern caddr_t	kmem_alloc();

/*
 * Routines here are modelled on corresponding NFS routines
 */

/*
 * return a vnode for the given rfs vfs.
 * If no rfsnode exists create one and put it
 * in a table hashed by ino.  If the rfsnode
 * is already in the table return it (ref count is
 * incremented by rfsfind.  The rfsnode will be flushed from the
 * table when rfs_inactive calls runsave.
 */
struct vnode *
makerfsnode(mp, ino)
struct rfsmount *mp;
{
	register struct rfsnode *rp;
	register struct vnode *vp;

	DUPRINT3(DB_RFSNODE, "makerfsnode: mp = %x, ino = %x\n", mp, ino);
	if ((rp = rfsfind(mp, ino)) == NULL) {
		rp = (struct rfsnode *)kmem_alloc((u_int)sizeof(*rp));
		bzero((caddr_t)rp, sizeof(*rp));
		vp = RFSTOV(rp);
		vp->v_count = 1;
		vp->v_op = &rfs_vnodeops;
		vp->v_data = (caddr_t)rp;
		vp->v_vfsp = mp->m_vfsp;
		vp->v_flag = VRFSNODE;
		VTOI(vp)->i_dev = NODEV;
		rp->rf_mntdev = mp;
		rp->rf_number = ino;
		rp->rf_cred = crdup(u.u_cred);
		rp->rf_fsptr = (sndd_t) NULL;
		rfsave(rp, ino);
		DUPRINT2(DB_RFSNODE, "makerfsnode: created a new node rp = %x\n", rp);
	}
	return (RFSTOV(rp));
}

/*
 * Rfsnode lookup stuff.
 * These routines maintain a table of rfsnodes hashed by ino so
 * that the rfsnode for an ino can be found if it already exists.
 * NOTE: RTABLESIZE must be a power of 2 for rtablehash to work!
 */

#define	RTABLESIZE	16
#define	rfstablehash(ino)	(ino & (RTABLESIZE-1))

struct rfsnode *rfstable[RTABLESIZE];

/*
 * Put a rnode in the table
 */
rfsave(rp, ino)
struct rfsnode *rp;
{

	rp->rf_next = rfstable[rfstablehash(ino)];
	rfstable[rfstablehash(ino)] = rp;
}

/*
 * Remove a rfsnode from the table
 */
rfsunsave(rp)
register struct rfsnode *rp;
{
	register struct rfsnode *rt;
	register struct rfsnode *rtprev = NULL;

	rt = rfstable[rfstablehash(rp->rf_number)]; 
	while (rt != NULL) { 
		if (rt == rp) { 
			if (rtprev == NULL) {
				rfstable[rfstablehash(rp->rf_number)] = rt->rf_next;
			} else {
				rtprev->rf_next = rt->rf_next;
			}
			DUPRINT2(DB_RFSNODE, "rfsunsave: removed from hashtable rp %x\n", rt);
			return; 
		}	
		rtprev = rt;
		rt = rt->rf_next;
	}	
}

/*
 * Lookup a rfsnode
 */
struct rfsnode *
rfsfind(mp, ino)
struct rfsmount *mp;
{
	register struct rfsnode *rt;

	rt = rfstable[rfstablehash(ino)]; 
	while (rt != NULL) { 
		if(rt->rf_number == ino && rt->rf_mntdev == mp) {
			RFSTOV(rt)->v_count++; 
			return (rt); 
		}	
		rt = rt->rf_next;
	}	
	return (NULL);
}

extern int rndebug;
int rfslockcount;
struct {
    int ll_pid;
    int ll_addr;
    int lr_pid;
    int lr_addr;
} rfs_lock_ctl;

/*
 * Lock and unlock rfsnodes
 */
rfslock(rp)
    struct rfsnode *rp;
{
    int s = spl6();

    while (rp->rf_flags & RLOCKED) {
	rp->rf_flags |= RWANT;	
	sleep((caddr_t)rp, PINOD);
    }
    rfs_lock_ctl.ll_pid = u.u_procp->p_pid;
    rfs_lock_ctl.ll_addr = (int)rp;
    rfslockcount++;
    rp->rf_flags |= RLOCKED;
    splx(s);
}

rfsunlock(rp) 
    struct rfsnode *rp;
{
    int s = spl6();
    rp->rf_flags &= ~RLOCKED;
    if (rp->rf_flags&RWANT) {
	rp->rf_flags &= ~RWANT;
	wakeup((caddr_t)rp);
    }
    rfs_lock_ctl.lr_pid = u.u_procp->p_pid;
    rfs_lock_ctl.lr_addr = (int)rp;
    rfslockcount--;
    splx(s);
}

struct rt_s {
    int rt_pid;
    int rt_logpt;
    int rt_ret;
    int rt_sec;
    int rt_usec;
    int rt_systemcall;
    int filler[2];
} rtstruct[20];

int rtenable, rtindex;
extern struct timeval time;

rfs_trace(logpt, ret)
    int logpt, ret;
{
    register struct rt_s *rp;
    
    if (!rtenable)
      return;
    if (rtindex > (sizeof (rtstruct) / sizeof (rtstruct[0]))) {
	printf ("rfs trace struct is full\n");
	return;
    }

    rp = &rtstruct[rtindex++];
    rp->rt_pid = u.u_procp->p_pid;
    rp->rt_logpt = logpt;
    rp->rt_ret = ret;
    rp->rt_systemcall = u.u_procp->p_systemcall;
    rp->rt_sec = time.tv_sec;
    rp->rt_usec = time.tv_usec;
}
    
#endif	defined(SYSV) && defined(RFS)
