#include "../h/types.h"
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/user.h"
#include "../h/errno.h"
#include "../h/proc.h"
#include "../h/tty.h"
#include "../sysv/sys/termio.h"

#define	NSV_STATES	16
static int to43_tab[NSV_STATES] = {
	TS_TIMEOUT,
	TS_WOPEN,
	TS_ISOPEN,
	TS_TBLOCK,
	TS_CARR_ON,
	TS_BUSY,
	TS_ASLEEP,
	0,
	TS_TTSTOP,
	0,
	0,
	0,
	0,
	TS_NBIO,
	0,
	0,
};

#define	N43_STATES	21
static short tosv_tab[N43_STATES] = {
	TIMEOUT,
	WOPEN,
	ISOPEN,
	0,
	CARR_ON,
	BUSY,
	OASLP,
	0,
	TTSTOP,
	0,
	TBLOCK,
	0,
	0,
	NBIO,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
};

map_state(tp, cmd)
register struct tty *tp;
int cmd;
{
	register int i;
	register int s = spltty();

	switch (cmd) {

	    case TO43:
		for(i = 0; i < NSV_STATES; i++) {
			if (tp->svt_state & (1 << i))
				tp->t_state |= to43_tab[i];
			else
				tp->t_state &= ~to43_tab[i];
		}
		break;

	    case TOSV:
		for(i = 0; i < N43_STATES; i++) {
			if (tp->t_state & (1 << i))
				tp->svt_state |= tosv_tab[i];
			else
				tp->svt_state &= ~tosv_tab[i];
		}
		break;

	  default:
		splx(s);
		panic("map_state");
	}
	splx(s);
}

#define	CNUL	0

map_chars(tp, cmd)
register struct tty *tp;
int cmd;
{
	register int s = spltty();

	switch (cmd) {

	    case TO43:
		if ((tp->t_erase = tp->svt_cc[VERASE]) == CNUL)
			tp->t_erase = (char)-1;
		if ((tp->t_kill = tp->svt_cc[VKILL]) == CNUL)
			tp->t_kill = (char)-1;
		if ((tp->t_eofc = tp->svt_cc[VEOF]) == CNUL)
			tp->t_eofc = (char)-1;
		if ((tp->t_brkc = tp->svt_cc[VEOL]) == CNUL)
			tp->t_brkc = (char)-1;
		if ((tp->t_intrc = tp->svt_cc[VINTR]) == CNUL)
			tp->t_intrc = (char)-1;
		if ((tp->t_quitc = tp->svt_cc[VQUIT]) == CNUL)
			tp->t_quitc = (char)-1;
		if ((tp->t_suspc = tp->svt_cc[VSWTCH]) == CNUL)
			tp->t_suspc = (char)-1;
		break;					

	    case TOSV:
		if ((tp->svt_cc[VERASE] = tp->t_erase) == (char)-1)
			tp->svt_cc[VERASE] = CNUL;
		if ((tp->svt_cc[VKILL] = tp->t_kill) == (char)-1)
			tp->svt_cc[VKILL] = CNUL;
		if ((tp->svt_cc[VEOF] = tp->t_eofc) == (char)-1)
			tp->svt_cc[VEOF] = CNUL;
		if ((tp->svt_cc[VEOL] = tp->t_brkc) == (char)-1)
			tp->svt_cc[VEOL] = CNUL;
		if ((tp->svt_cc[VINTR] = tp->t_intrc) == (char)-1)
			tp->svt_cc[VINTR] = CNUL;
		if ((tp->svt_cc[VQUIT] = tp->t_quitc) == (char)-1)
			tp->svt_cc[VQUIT] = CNUL;
		break;

	  default:
		panic("map_chars");
	}
	splx(s);
}

map_flags(tp, cmd)
register struct tty *tp;
int cmd;
{
	register int s = spltty();

	switch (cmd) {

	    case TO43: {

		register int flags = tp->t_flags;
							/* bits we know about */
		flags &= ~(ODDP | EVENP | NOHANG | MDMBUF | ECHO
#ifdef	NOMDM
				| NOMDM
#endif	NOMDM
				| RAW | LCASE |CRTBS | CRTERA | CRTKIL
				| PRTERA | NOFLSH | ECHO | CRMOD
				| BSDELAY | VTDELAY | CRDELAY | TBDELAY 
				| NLDELAY | LCASE | LITOUT | DECCTQ
				| TANDEM | CRMOD | PASS8);

							/* cflag */
		if (!(tp->svt_cflag & SV_HUPCL))
			tp->t_state |= TS_HUPCLS;
		else
			tp->t_state &= ~TS_HUPCLS;
		if ((tp->svt_iflag & SV_IGNPAR) == 0)
			flags |= (ODDP|EVENP);
		else if (tp->svt_cflag & SV_PARENB) {
			if (tp->svt_cflag & SV_PARODD)
				flags |= ODDP;
			else
				flags |= EVENP;
		}
		if (tp->svt_cflag & SV_CLOCAL)
			flags |= (NOHANG 
#ifdef	NOMDM
				| NOMDM 
#endif	NOMDM
				| MDMBUF);
		tp->t_ospeed = tp->t_ispeed = tp->svt_cflag & SV_CBAUD;

							/* lflag */
		if (!(tp->svt_lflag & SV_ICANON))
			flags |= RAW;
		if (tp->svt_lflag & SV_XCASE)
			flags |= LCASE;
		if (tp->svt_lflag & SV_ECHO)
			flags |= ECHO;
		if (tp->svt_lflag & SV_ECHOE)
			flags |= (CRTBS | CRTERA | CRTKIL);
		else
			flags |= PRTERA;
		if (tp->svt_lflag & SV_NOFLSH)
			flags |= NOFLSH;

							/* oflag */
		if (tp->svt_oflag & SV_ONLCR)  /* CRMOD a superset */
			flags |= CRMOD;
		if (tp->svt_oflag & SV_CR1)
			flags |= CR1;
		if (tp->svt_oflag & SV_CR2)
			flags |= CR2;
		if (tp->svt_oflag & SV_CR3)
			flags |= CR3;
		if (tp->svt_oflag & SV_NL1)
			flags |= NL1;
		if (tp->svt_oflag & SV_NL1) { 	/* can't handle ONLRET right */
			if (tp->svt_oflag & SV_NL1)
				flags |= CR1;
		}
		if ((tp->svt_oflag & SV_TABDLY) == SV_TAB3)
			flags |= XTABS;
		else if (tp->svt_oflag & SV_TAB1)
			flags |= TAB1;
		else if (tp->svt_oflag & SV_TAB2)
			flags |= TAB2;
		if (tp->svt_oflag & (SV_FFDLY | SV_VTDLY))
			flags |= FF1;
		if (tp->svt_oflag & SV_BSDLY)
			flags |= BS1;
		if (tp->svt_oflag & SV_OLCUC)		/* LCASE a superset */
			flags |= LCASE;
		if (!(tp->svt_oflag & SV_OPOST))
			flags |= LITOUT;

							/* iflag */
		if (tp->svt_iflag & SV_IXON) {
			flags |= DECCTQ;
			tp->t_startc = CSTART;
			tp->t_stopc = CSTOP;
		}
		if (tp->svt_iflag & SV_IXOFF)
			flags |= TANDEM;
		if (tp->svt_iflag & SV_ICRNL)		/* CRMOD a superset */
			flags |= CRMOD;
		if (tp->svt_iflag & SV_IUCLC)		/* LCASE a superset */
			flags |= LCASE;
		if (!(tp->svt_iflag & SV_ISTRIP))
			flags |= PASS8;
		
		tp->t_flags = flags;
		break;
		}

	    case TOSV: {
		register int flags; 
		register u_short iflag, oflag, lflag, cflag;

		flags = tp->t_flags;
		iflag = tp->svt_iflag;
		oflag = tp->svt_oflag;
		lflag = tp->svt_lflag;
		cflag = tp->svt_cflag;
					/*
					 * mask out bits we will be mapping to
					 */
		oflag &= ~(SV_TAB3|SV_BS1|SV_OLCUC|SV_FF1|SV_VT1|SV_ONLCR|
				SV_CRDLY|SV_NLDLY|SV_CLOCAL|SV_OPOST);

		cflag &= ~(SV_CBAUD|SV_CSIZE|SV_PARENB|SV_HUPCL|SV_PARODD);

		iflag &= ~(SV_IUCLC|SV_ICRNL|SV_INLCR|SV_ISTRIP|
					SV_IGNPAR|SV_INPCK|SV_IXANY|SV_IXOFF);

		lflag &= ~(SV_ECHO|SV_NOFLSH|SV_ISIG|SV_ICANON|SV_ECHOE);

		cflag |= tp->t_ospeed | SV_CREAD;
		if ((cflag & SV_CBAUD) == B110)
			cflag |= SV_CSTOPB;
		if (tp->t_state & TS_HUPCLS)
			cflag |= SV_HUPCL;
		if (flags & BS1)
			oflag |= SV_BS1;
		if ((flags & XTABS) == XTABS)
			oflag |= SV_TAB3;
		else if (flags & TAB1)
			oflag |= SV_TAB1;
		else if (flags & TAB2)
			oflag |= SV_TAB2;
		if (flags & VTDELAY)
			oflag |= SV_FF1 | SV_VT1;
		if (flags & LCASE) {
			iflag |= SV_IUCLC;
			oflag |= SV_OLCUC;
		}
		if (flags & ECHO)
			lflag |= SV_ECHO;
		if (flags & NOFLSH)
			lflag |= SV_NOFLSH;
		if (flags & CRMOD) {
			iflag |= SV_ICRNL;
			oflag |= SV_ONLCR;
		}
		if (flags & CR1)
			oflag |= SV_CR1;
		if (flags & CR2)
			oflag |= SV_CR2;
		if (flags & NL1)
			oflag |= SV_NL1;
		if (flags & (NOHANG
#ifdef	NOMDM
				| NOMDM
#endif	NOMDM
				| MDMBUF))
			oflag |= SV_CLOCAL;
		if (flags & (RAW|LITOUT))	/* see device param routines */
			cflag |= SV_CS8;
		else
			cflag |= SV_CS7;
		if (flags & RAW) {
			tp->svt_cc[VTIME] = 1;
			tp->svt_cc[VMIN] = 6;
		} else {
			tp->svt_cc[VEOF] = SV_CEOF;
			tp->svt_cc[VEOL] = 0;
			tp->svt_cc[VEOL2] = 0;
			iflag |= (SV_BRKINT|SV_IXON|SV_IXANY);
			lflag |= (SV_ICANON|SV_ISIG);
			cflag |= SV_PARENB;
		}
		if (!(flags & LITOUT))
			oflag |= SV_OPOST;
		if (!(flags & DECCTQ))
			iflag |= SV_IXANY;
		if (((flags & (ODDP|EVENP)) == ODDP) || 
				(flags & (ODDP|EVENP)) == EVENP) {
			iflag |= SV_INPCK|SV_IGNPAR;
			if (!(flags & EVENP))
				cflag |= SV_PARODD;
		}
		if (flags & (CRTBS|CRTERA|CRTKIL))
			lflag |= SV_ECHOE;
		if (!(flags & PASS8))
			iflag |= SV_ISTRIP;
		if (flags & TANDEM)
			lflag |= SV_IXOFF;
		tp->svt_iflag = iflag;
		tp->svt_oflag = oflag;
		tp->svt_cflag = cflag;
		tp->svt_lflag = lflag;
	    }
	}
	splx(s);
}

map_tty(tp, cmd)
register struct tty *tp;
int cmd;
{
	map_state(tp, cmd);
	map_chars(tp, cmd);
	map_flags(tp, cmd);
}
