/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
#ident	"@(#)kern-port:io/tty.c	10.7"
/*
 * general TTY subroutines
 */

#include "../h/types.h"
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/user.h"
#include "../h/errno.h"
#include "../h/proc.h"
#include "../h/tty.h"
#include "../h/file.h"
#include "../h/kernel.h"
#include "../h/conf.h"
#include "../sysv/sys/termio.h"
#include "../sysv/sys/ttold.h"


char	sv_ttcchar[NCC] = {
	CINTR,
	CQUIT,
	CERASE,
	CKILL,
	CEOF,
	0,
	0,
	0
};

/* null clist header */
struct clist ttnulq;

/* canon buffer */
char	canonb[CANBSIZ];
extern char maptab[];

char sv_partab[] = {
	0001,0201,0201,0001,0201,0001,0001,0201,
	0202,0004,0003,0205,0007,0206,0201,0001,
	0201,0001,0001,0201,0001,0201,0201,0001,
	0001,0201,0201,0001,0201,0001,0001,0201,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0000,0200,0200,0000,0200,0000,0000,0200,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0200,0000,0000,0200,0000,0200,0200,0000,
	0000,0200,0200,0000,0200,0000,0000,0201,

	/*
	 * 7 bit ascii ends with the last character above,
	 * but we contine through all 256 codes for the sake
	 * of the tty output routines which use scanc call
	 * which need a 256 character table.
	 */

	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007,
	0007,0007,0007,0007,0007,0007,0007,0007
};

/*
 * common ioctl tty code
 */
sv_ttiocom(tp, cmd, arg)
register struct tty *tp;
{
	register flag;
	struct termio cb;
	struct sgttyb tb;
	register int error = 0;

	switch (cmd) {
	case IOCTYPE:
		u.u_r.r_val1 = TIOC;
		break;

	case TCSETAW:
	case TCSETAF:
		sv_ttywait(tp);
		if (cmd == TCSETAF)
			sv_ttyflush(tp, (FREAD|FWRITE));
	case TCSETA:
		if (copyin(arg, &cb, sizeof cb)) {
			error = EFAULT;
			break;
		}
		if (tp->svt_line != cb.c_line) {
			if (cb.c_line < 0 || cb.c_line >= sv_linecnt) {
				error = EINVAL;
				break;
			}
			(*sv_linesw[tp->svt_line].l_ioctl)(tp, LDCLOSE, 0);
		}
		flag = tp->svt_lflag;
		tp->svt_iflag = cb.c_iflag;
		tp->svt_oflag = cb.c_oflag;
		tp->svt_cflag = cb.c_cflag;
		tp->svt_lflag = cb.c_lflag;
		bcopy(cb.c_cc, tp->svt_cc, NCC);
		if (tp->svt_line != cb.c_line) {
			tp->svt_line = cb.c_line;
			(*sv_linesw[tp->svt_line].l_ioctl)(tp, LDOPEN, 0);
		} else if (tp->svt_lflag != flag) {
			(*sv_linesw[tp->svt_line].l_ioctl)(tp, LDCHG, flag);
		}
		if ((tp->svt_cflag&SV_CLOCAL) && (tp->svt_state&CARR_ON) == 0) {
			wakeup((caddr_t)&tp->t_rawq);
			tp->svt_state |= CARR_ON;
		}
		map_tty(tp, TO43);
		return error;

	case TCGETA:
		cb.c_iflag = tp->svt_iflag;
		cb.c_oflag = tp->svt_oflag;
		cb.c_cflag = tp->svt_cflag;
		cb.c_lflag = tp->svt_lflag;
		cb.c_line = tp->svt_line;
		bcopy(tp->svt_cc, cb.c_cc, NCC);
		if (copyout(&cb, arg, sizeof cb))
			error = EFAULT;
		break;

	case TCSBRK:
		sv_ttywait(tp);
		if (arg == 0)
			(*tp->svt_proc)(tp, T_BREAK);
		break;

	case TCXONC:
		switch (arg) {
		case 0:
			(*tp->svt_proc)(tp, T_SUSPEND);
			break;
		case 1:
			(*tp->svt_proc)(tp, T_RESUME);
			break;
		case 2:
			(*tp->svt_proc)(tp, T_BLOCK);
			break;
		case 3:
			(*tp->svt_proc)(tp, T_UNBLOCK);
			break;
		default:
			error = EINVAL;
		}
		break;

	case TCFLSH:
		switch (arg) {
		case 0:
		case 1:
		case 2:
			sv_ttyflush(tp, (arg - FOPEN)&(FREAD|FWRITE));
			break;

		default:
			error = EINVAL;
		}
		break;

/* conversion aide only */
	case TIOCSETP:
		sv_ttywait(tp);
		sv_ttyflush(tp, (FREAD|FWRITE));
		if (copyin(arg, &tb, sizeof(tb))) {
			error = EFAULT;
			break;
		}
		tp->svt_iflag = 0;
		tp->svt_oflag = 0;
		tp->svt_lflag = 0;
		tp->svt_cflag = (tb.sg_ispeed&SV_CBAUD)|SV_CREAD;
		if ((tb.sg_ispeed&SV_CBAUD)==B110)
			tp->svt_cflag |= SV_CSTOPB;
		tp->svt_cc[VERASE] = tb.sg_erase;
		tp->svt_cc[VKILL] = tb.sg_kill;
		flag = tb.sg_flags;
		if (flag&O_HUPCL)
			tp->svt_cflag |= SV_HUPCL;
		if (flag&O_XTABS)
			tp->svt_oflag |= SV_TAB3;
		else if (flag&O_TBDELAY)
			tp->svt_oflag |= SV_TAB1;
		if (flag&O_LCASE) {
			tp->svt_iflag |= SV_IUCLC;
			tp->svt_oflag |= SV_OLCUC;
			tp->svt_lflag |= SV_XCASE;
		}
		if (flag&O_ECHO)
			tp->svt_lflag |= SV_ECHO;
		if (!(flag&O_NOAL))
			tp->svt_lflag |= SV_ECHOK;
		if (flag&O_CRMOD) {
			tp->svt_iflag |= SV_ICRNL;
			tp->svt_oflag |= SV_ONLCR;
			if (flag&O_CR1)
				tp->svt_oflag |= SV_CR1;
			if (flag&O_CR2)
				tp->svt_oflag |= SV_ONOCR|SV_CR2;
		} else {
			tp->svt_oflag |= SV_ONLRET;
			if (flag&O_NL1)
				tp->svt_oflag |= SV_CR1;
			if (flag&O_NL2)
				tp->svt_oflag |= SV_CR2;
		}
		if (flag&O_RAW) {
			tp->svt_cc[VTIME] = 1;
			tp->svt_cc[VMIN] = 6;
			tp->svt_iflag &= ~(SV_ICRNL|SV_IUCLC);
			tp->svt_cflag |= SV_CS8;
		} else {
			tp->svt_cc[VEOF] = SV_CEOF;
			tp->svt_cc[VEOL] = 0;
			tp->svt_cc[VEOL2] = 0;
			tp->svt_iflag |=
#ifdef	OLD
				SV_BRKINT|SV_IGNPAR|SV_ISTRIP|SV_IXON|SV_IXANY;
#else	OLD
				SV_BRKINT|SV_ISTRIP|SV_IXON|SV_IXANY;
#endif	OLD
			tp->svt_oflag |= SV_OPOST;
			tp->svt_cflag |= SV_CS7|SV_PARENB;
			tp->svt_lflag |= SV_ICANON|SV_ISIG;
		}
		tp->svt_iflag |= SV_INPCK;
		if (flag&O_ODDP)
			if (flag&O_EVENP)
				tp->svt_iflag &= ~SV_INPCK;
			else
				tp->svt_cflag |= SV_PARODD;
		if (flag&O_VTDELAY)
			tp->svt_oflag |= SV_FFDLY;
		if (flag&O_BSDELAY)
			tp->svt_oflag |= SV_BSDLY;
		map_tty(tp, TO43);
		return error;

	case TIOCGETP:
		tb.sg_ispeed = tp->svt_cflag&SV_CBAUD;
		tb.sg_ospeed = tb.sg_ispeed;
		tb.sg_erase = tp->svt_cc[VERASE];
		tb.sg_kill = tp->svt_cc[VKILL];
		flag = 0;
		if (tp->svt_cflag&SV_HUPCL)
			flag |= O_HUPCL;
		if (!(tp->svt_lflag&SV_ICANON))
			flag |= O_RAW;
		if (tp->svt_lflag&SV_XCASE)
			flag |= O_LCASE;
		if (tp->svt_lflag&SV_ECHO)
			flag |= O_ECHO;
		if (!(tp->svt_lflag&SV_ECHOK))
			flag |= O_NOAL;
		if (tp->svt_cflag&SV_PARODD)
			flag |= O_ODDP;
		else if (tp->svt_iflag&SV_INPCK)
			flag |= O_EVENP;
		else
			flag |= O_ODDP|O_EVENP;
		if (tp->svt_oflag&SV_ONLCR) {
			flag |= O_CRMOD;
			if (tp->svt_oflag&SV_CR1)
				flag |= O_CR1;
			if (tp->svt_oflag&SV_CR2)
				flag |= O_CR2;
		} else {
			if (tp->svt_oflag&SV_CR1)
				flag |= O_NL1;
			if (tp->svt_oflag&SV_CR2)
				flag |= O_NL2;
		}
		if ((tp->svt_oflag&SV_TABDLY)==SV_TAB3)
			flag |= O_XTABS;
		else if (tp->svt_oflag&SV_TAB1)
			flag |= O_TBDELAY;
		if (tp->svt_oflag&SV_FFDLY)
			flag |= O_VTDELAY;
		if (tp->svt_oflag&SV_BSDLY)
			flag |= O_BSDELAY;
		tb.sg_flags = flag;
		if (copyout(&tb, arg, sizeof(tb)))
			error = EFAULT;
		break;

	case FIOASYNC:		/* nop */
		break;

	case FIONBIO:
	    	if (*(int *)arg == O_NDELAY)
			tp->svt_state |= NBIO;
		else
			tp->svt_state &= ~NBIO;
		map_state(tp, TO43);
		break;

	default:
		if ((cmd&IOCTYPE) == LDIOC)
			(*sv_linesw[tp->svt_line].l_ioctl)(tp, cmd, arg);
		else
			error = EINVAL;
		break;
	}
	map_tty(tp, TO43);
	return error;
}

sv_ttinit(tp)
register struct tty *tp;
{
	tp->svt_line = 0;
	tp->svt_iflag = 0;
	tp->svt_oflag = 0;
	tp->svt_cflag = SSPEED|SV_CS8|SV_CREAD|SV_HUPCL;
	tp->svt_lflag = 0;
	bcopy(sv_ttcchar, tp->svt_cc, NCC);
}

sv_ttywait(tp)
register struct tty *tp;
{
	register int	oldpri;
	static	int	rate[] =
	{
#ifdef	TODO
		HZ+1 ,	/* avoid divide-by-zero, as well as unnecessary delay */
#else	TODO
		60+1 ,	/* avoid divide-by-zero, as well as unnecessary delay */
#endif	TODO
		50 ,
		75 ,
		110 ,
		134 ,
		150 ,
		200 ,
		300 ,
		600 ,
		1200 ,
		1800 ,
		2400 ,
		4800 ,
		9600 ,
		19200 ,
		38400 ,
	} ;

	oldpri = spltty();
	while ((tp->t_outq.c_cc || (tp->svt_state&(BUSY|TIMEOUT))) &&
	    			tp->svt_state&CARR_ON) {
		tp->svt_state |= OASLP;
		map_state(tp, TO43);
		sleep((caddr_t)&tp->t_outq, TTOPRI);
	}
	splx(oldpri);
				/* delay 11 bit times to allow uart to empty */
				/* add one to allow for truncation */
				/* add one to allow for partial clock tick */
	delay(1+1+11*hz/rate[tp->svt_cflag&SV_CBAUD]) ;
}

/*
 * flush TTY queues
 */
sv_ttyflush(tp, cmd)
register struct tty *tp;
{
	register int s;

	if (cmd&FWRITE) {
		while (getc(&tp->t_outq) >= 0)
			;
		(*tp->svt_proc)(tp, T_WFLUSH);
		if (tp->svt_state&OASLP) {
			tp->svt_state &= ~OASLP;
			map_state(tp, TO43);
			wakeup((caddr_t)&tp->t_outq);
		}
	}
	if (cmd&FREAD) {
		while (getc(&tp->t_canq) >= 0)
			;
		s = spltty();
		while (getc(&tp->t_rawq) >= 0)
			;
		tp->svt_delct = 0;
		splx(s);
		(*tp->svt_proc)(tp, T_RFLUSH);
		wakeup((caddr_t)&tp->t_rawq);
	}
}

/*
 * Transfer raw input list to canonical list,
 * doing erase-kill processing and handling escapes.
 */
sv_canon(tp)
register struct tty *tp;
{
	register char *bp;
	register c, esc;
	register int oldpri;

	oldpri = spltty();

	/*
	 * If the character count on the raw queue is 0, make
	 * the delimeter count 0.
	 */
	if (tp->t_rawq.c_cc == 0)
		tp->svt_delct = 0;

	/*
	 * If we don't have any delimeters in the raw queue (svt_delct==0),
	 * we can't do any canonical processing.
	 */
	while (tp->svt_delct == 0) {
		/*
		 * If we have no carrier just restore the
		 * execution priority and return
		 */
		if (!(tp->svt_state&CARR_ON) || (tp->svt_state&NBIO)) {
			splx(oldpri);
			return;
		}
		if (!(tp->svt_lflag&SV_ICANON) && tp->svt_cc[VMIN]==0) {
			if (tp->svt_cc[VTIME]==0)
				break;
			tp->svt_state &= ~RTO;
			if (!(tp->svt_state&TACT))
				sv_tttimeo(tp);
		}
		sleep((caddr_t)&tp->t_rawq, TTIPRI);
	}
	if (!(tp->svt_lflag&SV_ICANON)) {
		catq(&tp->t_rawq, &tp->t_canq);
		tp->svt_delct = 0;
		splx(oldpri);
		return;
	}
	splx(oldpri);
	bp = canonb;
	esc = 0;
	while ((c=getc(&tp->t_rawq)) >= 0) {
		if (!esc) {
			if (c == '\\') {
				esc++;
			} else if (c == tp->svt_cc[VERASE]) {
				if (bp > canonb)
					bp--;
				continue;
			} else if (c == tp->svt_cc[VKILL]) {
				bp = canonb;
				continue;
			} else if (c == tp->svt_cc[VEOF]) {
				break;
			}
		} else {
			esc = 0;
			if (c == tp->svt_cc[VERASE] ||
			    c == tp->svt_cc[VKILL] ||
			    c == tp->svt_cc[VEOF])
				bp--;
			else if (tp->svt_lflag&SV_XCASE) {
				if ((c < 0200) && maptab[c]) {
					bp--;
					c = maptab[c];
				} else if (c == '\\')
					continue;
			} else if (c == '\\')
				esc++;
		}
		*bp++ = c;
		if (c == '\n' || c == tp->svt_cc[VEOL] 
					|| c == tp->svt_cc[VEOL2])
			break;
		if (bp >= &canonb[CANBSIZ])
			bp--;
	}
	tp->svt_delct--;
	c = bp - canonb;
	bp = canonb;
/* faster copy ? */
	while (c--)
		putc(*bp++, &tp->t_canq);
	return;
}

/*
 * Restart typewriter output following a delay timeout.
 * The name of the routine is passed to the timeout
 * subroutine and it is called during a clock interrupt.
 */
sv_ttrstrt(tp)
register struct tty *tp;
{

	(*tp->svt_proc)(tp, T_TIME);
}

/*
 *	generic 'sv_proc' routine called by drivers, including pty driver 
 */
sv_proc(tp, cmd, dev_start, dev_param)
register struct tty *tp;
register cmd;
void (*dev_start)();	/* device specific start routine */
void (*dev_param)();	/* device specific param routine */
{
	int s;

	s = spltty();
	switch (cmd) {
	    case T_TIME:
		tp->svt_state &= ~TIMEOUT;
		goto output;

	    case T_WFLUSH:
	    case T_RESUME:
		tp->svt_state &= ~TTSTOP;
		goto output;

	    case T_OUTPUT:
output:
		map_state(tp, TO43);
		if ((tp->svt_state & (TIMEOUT|TTSTOP|BUSY)) == 0 &&
			   (*sv_linesw[tp->svt_line].l_output)(tp) && dev_start)
			(*dev_start)(tp);
		break;

	    case T_SUSPEND:
		tp->svt_state |= TTSTOP;
		map_state(tp, TO43);
		break;

	    case T_BLOCK:
		tp->svt_state |= TBLOCK;
		map_state(tp, TO43);
		break;

	    case T_RFLUSH:
		if (!(tp->svt_state & TBLOCK))
			break;

	    case T_UNBLOCK:
		tp->svt_state &= ~TBLOCK;
		goto output;
		break;

	    case T_BREAK:
		tp->svt_state |= TIMEOUT;
					/* should send BRK character here */
		map_state(tp, TO43);
		timeout(sv_ttrstrt, tp, hz/4);
		break;

	    case T_PARM:
		if (dev_param)
			(*dev_param)(minor(tp->t_dev));
		break ;
	}
	splx(s);
}
