#ifdef	SYSV

#include "stp.h"
#if	NSTP > 0
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/


/*
 * ST - Stream "pipe" device.  Any two minor devices may
 * be opened and connected to each other so that each user
 * is at the end of a single stream.  This provides a full
 * duplex communications path and allows for the passing
 * of file descriptors as well.  
 *
 * WARNING - an interprocess stream does not have the same
 * 	     semantics as a pipe, and this does not replace
 *	     pipes.
 */

#include "../h/types.h"
#include "../h/param.h"
#include "../h/errno.h"
#include "../sysv/sys/errno.h"
#include "../sysv/sys/stropts.h"
#include "../sysv/sys/stream.h"
#include "stp.h"

int stpopen(), stpclose(), stpput();

static struct module_info stpm_info = {1111, "stp", 0, INFPSZ, 5120, 1024 };

static struct qinit stprinit ={ NULL, NULL, stpopen, stpclose, NULL, &stpm_info, NULL };

static struct qinit stpwinit ={ stpput, NULL, NULL, NULL, NULL, &stpm_info, NULL};

struct streamtab stpinfo = { &stprinit, &stpwinit, NULL, NULL };

#define	MAXSTP 16			/* number of pipe devices */
int maxstp = MAXSTP;

struct stp {
	queue_t *st_rdq;		/* this stream's read queue */
	queue_t *st_ordq;		/* other stream's read queue */
	} stp_stp[MAXSTP];


stpopen(q, dev, flag, sflag)
register queue_t *q;
register int dev;
int flag;
int sflag;
{
	register struct stp *stp;

	dev = minor(dev);
	switch (sflag) {
	case MODOPEN:
		dev = (struct stp *)q->q_ptr - stp_stp;
		break;

	case CLONEOPEN:
		for (dev=0, stp = stp_stp; ((dev<maxstp) && stp->st_rdq); 
					dev++, stp++);
		break;
	}
	if ((dev < 0) || (dev >= maxstp)) 
		return(OPENFAIL);
	stp = &stp_stp[dev];
	if (!stp->st_rdq) {
		stp->st_rdq = q;
		q->q_ptr = WR(q)->q_ptr = (caddr_t)stp;
	}
	return(dev);
}

stpclose(q)
register queue_t *q;
{
	register struct stp *stp, *ostp;
	register queue_t *orq;
	register mblk_t *mp;

	stp = (struct stp *)q->q_ptr;
	stp->st_rdq = NULL;
	if (orq = stp->st_ordq) {
		ostp = (struct stp *)orq->q_ptr;
		ostp->st_ordq = NULL;
		stp->st_ordq = NULL;
		WR(orq)->q_next = NULL;
		WR(q)->q_next = NULL;
		if (mp = allocb(0)) { 
			mp->b_datap->db_type = M_HANGUP;
			putnext(orq, mp);
		} else
			printf("SP: WARNING - close could not allocate block\n");
	}
	q->q_ptr = WR(q)->q_ptr = NULL;
}

stpput(q, bp)
register queue_t *q;
register mblk_t *bp;
{
	register btype;

	switch (btype = bp->b_datap->db_type) {

	case M_IOCTL:
		bp->b_datap->db_type = M_IOCNAK;
		qreply(q, bp);
		return;

	case M_FLUSH:
		/*
		 * The meaning of read and write sides must be reversed
		 * for the destination stream head.
		 */
		if (!q->q_next) {
			*bp->b_rptr &= ~FLUSHW;
			if (*bp->b_rptr & FLUSHR) qreply(q, bp);
			return;
		}
		switch (*bp->b_rptr) {
		case FLUSHR: *bp->b_rptr = FLUSHW; break;
		case FLUSHW: *bp->b_rptr = FLUSHR; break;
		}
		putnext(q, bp);		
		return;

	default:
		if (q->q_next) {
			putnext(q, bp);
			return;
		} else if (btype == M_PROTO) {

			register queue_t *oq;
			register struct stp *stp, *ostp;
			register i;

			if (bp->b_cont) {
				goto errout;
			}
			if ((bp->b_wptr - bp->b_rptr) != sizeof(queue_t *)) {
				goto errout;
			}
			oq = *((queue_t **)bp->b_rptr);
			for (i=0, ostp=stp_stp; 
			     ((i<=maxstp) && (oq!=ostp->st_rdq)); i++, ostp++);
			if (i>maxstp) {
				goto errout;
			}
			if (ostp->st_ordq) {
				goto errout;
			}

			stp = (struct stp *)q->q_ptr;
			stp->st_ordq = oq;
			ostp->st_ordq = RD(q);
			WR(oq)->q_next = RD(q)->q_next;
			q->q_next = oq->q_next;
			freemsg(bp);
			return;
		}
		break;
	}
			
errout:
	/*
	 * The stream has not been connected yet.
	 */
	bp->b_datap->db_type = M_ERROR;
	bp->b_wptr = bp->b_rptr = bp->b_datap->db_base;
	*bp->b_wptr++ = EIO;
	qreply(q, bp);
	return;
}
#endif
#endif	SYSV
