/*
 * module to test stream modules
 * this does a case swap on all chars received in the service procedure
 */

#include "../h/types.h"
#include "../h/param.h"
#include "../h/errno.h"
#include "../sysv/sys/errno.h"
#include "../sysv/sys/stropts.h"
#include "../sysv/sys/stream.h"
#include "../sysv/sys/strlog.h"
#include <ctype.h>

int modopen(), modclose(), modput(), modsrv();

static struct module_info minfo = {0, "casemod", 0, INFPSZ, 5129, 1024 };

static struct qinit modinit = { modput, modsrv, modopen, modclose, NULL, &minfo, NULL };

struct streamtab modinfo = { &modinit, &modinit, NULL, NULL };


modopen(q, dev, flag, sflag)
register queue_t *q;
register int dev;
int flag;
int sflag;
{
	if (sflag != MODOPEN)
		return OPENFAIL;
	return 0;
}

modclose(q, flag)
register queue_t *q;
int flag;
{
	return 0;
}

modput(q, mp)
register queue_t *q;
mblk_t mp;
{
	putq(q,mp);
}

modsrv(q)
register queue_t *q;
{
	register mblk_t *mp;
	register u_char *p;

	while ((mp = getq(q)) != NULL) {

		switch (mp->b_datap->db_type) {

		    default:
			if (mp->b_datap->db_type>=QPCTL || canput(q->q_next))
				putnext(q, mp);
			else {
				putbq(q, mp);
				return;
			}
			break;

		    case M_FLUSH:
			if (*mp->b_rptr & FLUSHW)
				flushq(q, FLUSHDATA);
			putnext(q, mp);
			break;

		    case M_DATA:
			if (!canput(q->q_next)) {
				putbq(q, mp);
				return;
			} else {
				p = mp->b_rptr;
				while (p <= mp->b_wptr)
					*p++ = (char) toggle(*p);
				strlog(1, 1, 100, SL_TRACE,
					"writing %d bytes\n",
					mp->b_wptr - mp->b_rptr);
				putnext(q, mp);
			}
			break;
		}
	}
}

static
toggle(c)
char c;
{
	char foo;

	if (isalpha(c)) {
		if (isupper(c))
			foo = tolower(c);
		else if (islower(c))
			foo = toupper(c);
		else
			foo = c;
		return foo;
	}
	return c;
}
