/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)vm_swp.c	7.1 (Berkeley) 6/5/86
 */

#include "../machine/pte.h"

#include "param.h"
#include "systm.h"
#include "user.h"
#include "buf.h"
#include "conf.h"
#include "proc.h"
#include "seg.h"
#include "vm.h"
#include "trace.h"
#include "map.h"
#include "uio.h"
#include "vnode.h"

#ifdef	is68k
#include "cmap.h"
#include "../machine/board.h"
struct pte *bptopte();
#endif	is68k

#ifdef	SYSV
#include "../sysv/sys/sysmacros.h"
#endif	SYSV

/*
 * Swap IO headers -
 * They contain the necessary information for the swap I/O.
 * At any given time, a swap header can be in three
 * different lists. When free it is in the free list, 
 * when allocated and the I/O queued, it is on the swap 
 * device list, and finally, if the operation was a dirty 
 * page push, when the I/O completes, it is inserted 
 * in a list of cleaned pages to be processed by the pageout daemon.
 */
struct	buf *swbuf;

/*
 * swap I/O -
 *
 * If the flag indicates a dirty page push initiated
 * by the pageout daemon, we map the page into the i th
 * virtual page of process 2 (the daemon itself) where i is
 * the index of the swap header that has been allocated.
 * We simply initialize the header and queue the I/O but
 * do not wait for completion. When the I/O completes,
 * iodone() will link the header to a list of cleaned
 * pages to be processed by the pageout daemon.
 */
swap(p, dblkno, addr, nbytes, rdflg, flag, vp, pfcent)
	struct proc *p;
	swblk_t dblkno;
	caddr_t addr;
	int nbytes, rdflg, flag;
	register struct vnode *vp;
	u_int pfcent;
{
	register struct buf *bp;
	register u_int c;
	int p2dp;
	register struct pte *dpte, *vpte;
	int s;
	extern swdone();
	int error = 0;

	s = splbio();
	while (bswlist.av_forw == NULL) {
		bswlist.b_flags |= B_WANTED;
		sleep((caddr_t)&bswlist, PSWP+1);
	}
	bp = bswlist.av_forw;
	bswlist.av_forw = bp->av_forw;
	splx(s);

#ifdef vax
	bp->b_flags = B_BUSY | B_PHYS | rdflg | flag;
#endif vax
#ifdef is68k
	bp->b_flags &= B_QUALIFY;
	bp->b_flags |= B_BUSY | B_PHYS | rdflg | flag;
#endif is68k
	if ((bp->b_flags & (B_DIRTY|B_PGIN)) == 0)
		if (rdflg == B_READ)
			sum.v_pswpin += btoc(nbytes);
		else
			sum.v_pswpout += btoc(nbytes);
	bp->b_proc = p;
	if (flag & B_DIRTY) {
		p2dp = ((bp - swbuf) * CLSIZE) * KLMAX;
		dpte = dptopte(&proc[2], p2dp);
		vpte = vtopte(p, btop(addr));
		for (c = 0; c < nbytes; c += NBPG) {
			if (vpte->pg_pfnum == 0 || vpte->pg_fod)
				panic("swap bad pte");
			*dpte++ = *vpte++;
		}
		bp->b_un.b_addr = (caddr_t)ctob(dptov(&proc[2], p2dp));
		bp->b_flags |= B_CALL;
		bp->b_iodone = swdone;
		bp->b_pfcent = pfcent;
	} else
		bp->b_un.b_addr = addr;
	while (nbytes > 0) {
		bp->b_bcount = nbytes;
		bp->b_blkno = dblkno;
		bp->b_dev = vp->v_rdev;
		bsetvp(bp, vp);
		minphys(bp);
#ifdef	is68k
		maxphys(bp);
#endif	is68k
		c = bp->b_bcount;
#ifdef TRACE
		trace(TR_SWAPIO, dev, bp->b_blkno);
#endif
#ifdef	vax
		physstrat(bp, vp->v_op->vn_strategy, PSWP);
#endif	vax
#ifdef	is68k
		physstrat(bp, vp->v_op->vn_strategy, PSWP, 0);
#endif	is68k
		if (flag & B_DIRTY) {
			if (c < nbytes)
				panic("big push");
			return(error);
		}
		bp->b_un.b_addr += c;
		bp->b_flags &= ~B_DONE;
		if (bp->b_flags & B_ERROR) {
			if ((flag & (B_UAREA|B_PAGET)) || rdflg == B_WRITE)
				panic("hard IO err in swap");
			swkill(p, "swap: read error from swap device");
			error = EIO;
		}
		nbytes -= c;
		dblkno += btodb(c);
	}
	s = splbio();
	bp->b_flags &= ~(B_BUSY|B_WANTED|B_PHYS|B_PAGET|B_UAREA|B_DIRTY);
	bp->av_forw = bswlist.av_forw;
	bswlist.av_forw = bp;
	if (bswlist.b_flags & B_WANTED) {
		bswlist.b_flags &= ~B_WANTED;
		wakeup((caddr_t)&bswlist);
		wakeup((caddr_t)&proc[2]);
	}
	splx(s);
	return(error);
}

/*
 * Put a buffer on the clean list after I/O is done.
 * Called from biodone.
 */
swdone(bp)
	register struct buf *bp;
{
	register int s;

	if (bp->b_flags & B_ERROR)
		panic("IO err in push");
	s = splbio();
	bp->av_forw = bclnlist;
	cnt.v_pgout++;
	cnt.v_pgpgout += bp->b_bcount / NBPG;
	bclnlist = bp;
	if (bswlist.b_flags & B_WANTED)
		wakeup((caddr_t)&proc[2]);
	splx(s);
}

/*
 * If rout == 0 then killed on swap error, else
 * rout is the name of the routine where we ran out of
 * swap space.
 */
swkill(p, rout)
	struct proc *p;
	char *rout;
{

	printf("pid %d: %s\n", p->p_pid, rout);
	uprintf("sorry, pid %d was killed in %s", p->p_pid, rout);
	/*
	 * To be sure no looping (e.g. in vmsched trying to
	 * swap out) mark process locked in core (as though
	 * done by user) after killing it so noone will try
	 * to swap it out.
	 */
	psignal(p, SIGKILL);
	p->p_flag |= SULOCK;
}

/*
 * Raw I/O. The arguments are
 *	The strategy routine for the device
 *	A buffer, which will always be a special buffer
 *	  header owned exclusively by the device for this purpose
 *	The device number
 *	Read/write flag
 * Essentially all the work is computing physical addresses and
 * validating them.
 * If the user has the proper access privilidges, the process is
 * marked 'delayed unlock' and the pages involved in the I/O are
 * faulted and locked. After the completion of the I/O, the above pages
 * are unlocked.
 */
physio(strat, bp, dev, rw, mincnt, uio)
	int (*strat)(); 
	register struct buf *bp;
	dev_t dev;
	int rw;
	unsigned (*mincnt)();
	register struct uio *uio;
{
	register struct iovec *iov;
	register int c;
	char *a;
	int s, error = 0, locked;

nextiov:
	if (uio->uio_iovcnt == 0)
		return (0);
	iov = uio->uio_iov;
	if (useracc(iov->iov_base,
	    (u_int)iov->iov_len,rw==B_READ?B_WRITE:B_READ) == NULL)
		return (EFAULT);
	s = splbio();
	while (bp->b_flags&B_BUSY) {
		bp->b_flags |= B_WANTED;
		sleep((caddr_t)bp, PRIBIO+1);
	}
	splx(s);
	bp->b_error = 0;
	bp->b_proc = u.u_procp;
	bp->b_un.b_addr = iov->iov_base;
	while (iov->iov_len > 0) {
#ifdef vax
		bp->b_flags = B_BUSY | B_PHYS | rw;
#endif vax
#ifdef is68k
		bp->b_flags &= B_QUALIFY|B_WANTED;
		bp->b_flags |= B_BUSY | B_PHYS | rw;
#endif is68k
		bp->b_dev = dev;
		bp->b_blkno = btodb(uio->uio_offset);
		bp->b_bcount = iov->iov_len;
#ifdef vax
		(*mincnt)(bp);
#endif vax
#ifdef is68k
		(*mincnt)(bp, uio);
#endif is68k
		c = bp->b_bcount;
		u.u_procp->p_flag |= SPHYSIO;
#ifdef vax
		vslock(a = bp->b_un.b_addr, c);
		physstrat(bp, strat, PRIBIO);
		(void) splbio();
#endif vax
#ifdef is68k
#if	defined(SYSV) && defined(RFS)
	        if (!u.u_tclient && !server())
#else	defined(SYSV) && defined(RFS)
	        if (!u.u_tclient)
#endif	defined(SYSV) && defined(RFS)
		{					/* ISI: TRFS: */
			vslock(a = bp->b_un.b_addr, c);
			locked = 1;
			physcontig(bp);
		} else
			locked = 0;
		locked = physstrat(bp, strat, PRIBIO, locked);
		(void) splbio();
		if (locked
#if	defined(SYSV) && defined(RFS)
		        && !u.u_tclient && !server()
#else	defined(SYSV) && defined(RFS)
	        	&& !u.u_tclient			/* ISI: TRFS: */
#endif	defined(SYSV) && defined(RFS)
		    )
#endif is68k
		vsunlock(a, c, rw);
		u.u_procp->p_flag &= ~SPHYSIO;
		if (bp->b_flags&B_WANTED)
			wakeup((caddr_t)bp);
		splx(s);
		c -= bp->b_resid;
		bp->b_un.b_addr += c;
		iov->iov_len -= c;
		uio->uio_resid -= c;
		uio->uio_offset += c;
		/* temp kludge for tape drives */
		if (bp->b_resid || (bp->b_flags&B_ERROR))
			break;
	}
	bp->b_flags &= ~(B_BUSY|B_WANTED|B_PHYS);
	error = geterror(bp);
	/* temp kludge for tape drives */
	if (bp->b_resid || error)
		return (error);
	uio->uio_iov++;
	uio->uio_iovcnt--;
	goto nextiov;
}

#define	MAXPHYS	(63 * 1024)

unsigned
minphys(bp)
	struct buf *bp;
{

	if (bp->b_bcount > MAXPHYS)
		bp->b_bcount = MAXPHYS;
}

#ifdef	is68k
maxphys(bp)
	struct buf *bp;
{
	register int bcount = qbaddrcontig(bp);

	if (bcount > MAXPHYS)
		bcount = MAXPHYS;
	bp->b_bcount = bcount;
}

/*
 * Attempt to obtain physicaly contiguous pages for raw io speedup.
 * On machines which support VDMA this is a noop.
 */
physcontig(bp)
	register struct buf *bp;
{
#ifndef	M68025
	register struct pte *pte = bptopte(bp);
	register struct proc *p = bp->b_proc;
	register struct cmap *c;
	register int npg = btoc(bp->b_bcount + ((int)bp->b_un.b_addr&PGOFSET));
	register int i, j, pf;
	register int v, type;
	int s, prot;

	if (npg > freemem)
		return;
	for (i = 0, pf = pte->pg_pfnum; i < npg; i++)
		if (pte[i].pg_pfnum != pf+i)
			break;
	if (i == npg)				/* return already contiguous */
		return;

	/* find a free contiguous region that is big enough */
	s = splimp();
	for (i = 0 ; i < CM_SETSIZE; i++)
		if (CM_ISSET(i, &freememmap)) {
			for (j = 0; j < npg; j++)
				if (CM_ISSET(i+j, &freememmap) == 0)
					break;
			if (j == npg)
				break;
			i += j;
	    	}
	if (i >= CM_SETSIZE) {		/* return if no hole available */
		splx(s);
		return;
	}

	/* from pte, find virtual address and type (ala ptetov in vm_subr) */
	if (isatpte(p, pte)) {
		type = CTEXT;
		v = tptov(p, ptetotp(p, pte));
	} else if (isadpte(p, pte)) {
		type = CDATA;
		v = dptov(p, ptetodp(p, pte));
	} else if (isaspte(p, pte)) {
		type = CSTACK;
		v = sptov(p, ptetosp(p, pte));
	} else {
		splx(s);
		return;
	}

	/* remove new pages from free list */
	for (j = 0 ; j < npg; j++) {
		CM_CLR(i+j, &freememmap);
		c = cmtocmp(i+j);
		cmap[c->c_prev].c_next = c->c_next;
		cmap[c->c_next].c_prev = c->c_prev;
		freemem -= CLSIZE;
#ifdef	M68020
		if (cmptopg(c) < PTP_PG)
			freemempt -= CLSIZE;
#endif	M68020
		copyseg(ctob(v+j), cmtopg(i+j));
	}

	/* free the old pages */
	memfree(pte, npg, 1);

	/* initialize and map the new pages, memallx leaves them locked */
	for (j = 0 ; j < npg; j++) {
		prot = (*(int *)(pte+j))&(PG_V|PG_PROT|PG_M|PG_R|PG_FOD|PG_CACHE);
		memallx(cmtocmp(i+j), p, pte+j, type);
		*(int *)(pte+j) |= prot;
	}
	newptes(pte, v, npg);
	splx(s);
#endif	M68025
}
#endif	is68k
