/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)tty_conf.c	7.1 (Berkeley) 6/5/86
 */

#include "param.h"
#include "systm.h"
#include "buf.h"
#include "ioctl.h"
#include "tty.h"
#include "conf.h"

int	nodev();
int	nulldev();

int	ttyopen(),ttylclose(),ttread(),ttwrite(),nullioctl(),ttstart();
int	ttymodem(), nullmodem(), ttyinput();

#include "bk.h"
#if NBK > 0
int	bkopen(),bkclose(),bkread(),bkinput(),bkioctl();
#endif

#include "tb.h"
#if NTB > 0
int	tbopen(),tbclose(),tbread(),tbinput(),tbioctl();
#endif

#include "sl.h"
#if NSL > 0
int	slopen(),slclose(),slinput(),sltioctl(),slstart();
#endif

#ifdef GWS
int	vtcopen(), vtcclose(), vtcread(), vtcwrite(); vtcioctl();
int	vtmouse(),vtkeyboard();
#endif GWS

struct	linesw linesw[] =
{
	ttyopen, ttylclose, ttread, ttwrite, nullioctl,	/* 0- OTTYDISC */
	ttyinput, nodev, nulldev, ttstart, ttymodem,
#if NBK > 0
	bkopen, bkclose, bkread, ttwrite, bkioctl,	/* 1- NETLDISC */
	bkinput, nodev, nulldev, ttstart, nullmodem,
#else
	nodev, nodev, nodev, nodev, nodev,
	nodev, nodev, nodev, nodev, nodev,
#endif
	ttyopen, ttylclose, ttread, ttwrite, nullioctl,	/* 2- NTTYDISC */
	ttyinput, nodev, nulldev, ttstart, ttymodem,
#if NTB > 0
	tbopen, tbclose, tbread, nodev, tbioctl,	/* 3- TABLDISC */
	tbinput, nodev, nulldev, ttstart, nullmodem,
#else
	nodev, nodev, nodev, nodev, nodev,
	nodev, nodev, nodev, nodev, nodev,
#endif
#if NSL > 0
	slopen, slclose, nodev, nodev, sltioctl,	/* 4- SLIPDISC */
	slinput, nodev, nulldev, slstart, nulldev,
#else
	nodev, nodev, nodev, nodev, nodev,
	nodev, nodev, nodev, nodev, nodev,
#endif
#ifdef	GWS			/* ISI: GWS: */
	ttyopen, ttylclose, ttread, ttwrite, nullioctl,	/* 5- TWSDISC */
	ttyinput, nodev, nulldev, ttstart, nullmodem,
	vtcopen, vtcclose, vtcread, vtcwrite, vtcioctl, /* 6- KYBDDISC */
	vtkeyboard, nodev, nulldev, ttstart, nullmodem,
	nulldev, nulldev, nulldev, nulldev, nullioctl,	/* 7- MOUSDISC */
	vtmouse, nodev, nulldev, nulldev, nullmodem,
#else	GWS
	nodev, nodev, nodev, nodev, nodev,		/* 5 */
	nodev, nodev, nodev, nodev, nodev,
	nodev, nodev, nodev, nodev, nodev,		/* 6 */
	nodev, nodev, nodev, nodev, nodev,
	nodev, nodev, nodev, nodev, nodev,		/* 7 */
	nodev, nodev, nodev, nodev, nodev,
#endif	GWS
};

int	nldisp = sizeof (linesw) / sizeof (linesw[0]);

/*
 * Do nothing specific version of line
 * discipline specific ioctl command.
 */
/*ARGSUSED*/
nullioctl(tp, cmd, data, flags)
	struct tty *tp;
	char *data;
	int flags;
{

#ifdef lint
	tp = tp; data = data; flags = flags;
#endif
	return (-1);
}

#ifdef	SYSV

extern int sv_ttopen(), sv_ttlclose(), sv_ttread(), sv_ttwrite();
extern int sv_ttioctl(), sv_ttin(), sv_ttout(), sv_ttmodem();

extern int sxtopen(), sxtclose(), sxtread(), sxtwrite();
extern int sxtin(), sxtout();

struct	sv_linesw sv_linesw[] = 
{
	sv_ttopen, sv_ttlclose, sv_ttread, sv_ttwrite,	/* 0 - DEFAULT */
	sv_ttioctl, sv_ttin, sv_ttout, sv_ttmodem,
	nodev, nodev, nodev, nodev, 			/* 1 - XT */
	nodev, nodev, nodev, nodev, 	
	nulldev, nulldev, nulldev, nulldev,		/* 2 - SXT */
	nullioctl, sxtin, sxtout, nullmodem,
#ifdef	GWS
	sv_ttopen, sv_ttlclose, sv_ttread, sv_ttwrite,	/* 3 - SV_TWSDISC */
	nullioctl, sv_ttin, nulldev, nullmodem,
	vtcopen, vtcclose, vtcread, vtcwrite, 		/* 4 - SV_KYBDDISC */
	vtcioctl, vtkeyboard, sv_ttout, nullmodem,
	nulldev, nulldev, nulldev, nulldev, 		/* 5 - SV_MOUSDISC */
	nullioctl, vtmouse, nullmodem,
#endif	GWS
};

int	sv_linecnt = sizeof (sv_linesw) / sizeof (sv_linesw[0]);
#endif	SYSV
