/* Handle software interrupts through 'softcall' mechanism */

#include "types.h"
#include "softint.h"

/*
 * Call function func with argument arg 
 * at some later time at software interrupt priority
 */
softcall(func, arg)
	register func_t func;
	register caddr_t arg;
{
	register struct softcall *sc;
	static int first = 1;
	int s = splhigh();

	if (first) {
		for (sc = softcalls; sc < &softcalls[NSOFTCALLS]; sc++) {
			sc->sc_next = softfree;
			softfree = sc;
		}
		first = 0;
	}
	/* coalesce identical softcalls */
	for (sc = softhead; sc != 0; sc = sc->sc_next)
		if (sc->sc_func == func && sc->sc_arg == arg)
			goto out;
	if ((sc = softfree) == 0)
		panic("too many softcalls");
	softfree = sc->sc_next;
	sc->sc_func = func;
	sc->sc_arg = arg;
	sc->sc_next = 0;
	if (softhead) {
		softtail->sc_next = sc;
		softtail = sc;
	} else {
		softhead = softtail = sc;
		siron();
	}
    out:splx(s);
}

/*
 * Called to process software interrupts take one off queue, call it, repeat
 * Note queue may change during call
 */
softint()
{
	register func_t func;
	register caddr_t arg;
	register struct softcall *sc;
	int s;

	for (;;) {
		s = splhigh();
		if (sc = softhead) {
			func = sc->sc_func;
			arg = sc->sc_arg;
			softhead = sc->sc_next;
			sc->sc_next = softfree;
			softfree = sc;
		}
		splx(s);
		if (sc == 0)
			return;
		(*func)(arg);
	}
}
