/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)init_main.c	7.1 (Berkeley) 6/5/86
 */

#include "../machine/pte.h"

#include "param.h"
#include "user.h"
#include "kernel.h"
#include "vfs.h"
#include "vnode.h"
#include "map.h"
#include "proc.h"
#include "seg.h"
#include "conf.h"
#include "buf.h"
#include "vm.h"
#include "cmap.h"
#include "text.h"
#include "clist.h"
#include "protosw.h"
#include "quota.h"
#include "systm.h"
#include "../machine/reg.h"
#ifdef vax
#include "../machine/cpu.h"
#endif vax
#ifdef is68k
#include "../machine/board.h"
#endif is68k

int	cmask = CMASK;

/*
 * Initialization code.
 * Called from cold start routine as
 * soon as a stack and segmentation
 * have been established.
 * Functions:
 *	clear and free user core
 *	turn on clock
 *	hand craft 0th process
 *	call all initialization routines
 *	fork - process 0 to schedule
 *	     - process 1 execute bootstrap
 *	     - process 2 to page out
 */
main(firstaddr)
	int firstaddr;
{
	register int i;
	register struct proc *p;
	int s;

	rqinit();
	startup(firstaddr);

	/* set up system process 0 (swapper) */
	p = &proc[0];
	p->p_p0br = u.u_pcb.pcb_p0br;
	p->p_p1br = u.u_pcb.pcb_p1br;
	p->p_szpt = 1;
	p->p_addr = uaddr(p);
	p->p_stat = SRUN;
	p->p_flag |= SLOAD|SSYS;
	p->p_flag |= SPHIGH;
	p->p_nice = NZERO;
	p->p_context = CTX_SYS;
	setredzone(p->p_addr, (caddr_t)&u);
	u.u_procp = p;

	/*
	 * This assumes that the u. area is always mapped 
	 * to the same virtual address. Otherwise must be
	 * handled when copying the u. area in newproc().
	 */
	u.u_ap = u.u_arg;

	u.u_cmask = cmask;
	u.u_lastfile = -1;

	/* get vnodes for swapdev and argdev */
	swapdev_vp = bdevvp(swapdev);
	argdev_vp = bdevvp(argdev);
	rootvp = bdevvp(rootdev);

	/* Setup credentials */
	u.u_cred = crget();
	for (i = 1; i < NGROUPS; i++)
		u.u_groups[i] = NOGROUP;
	for (i = 0; i < sizeof(u.u_rlimit)/sizeof(u.u_rlimit[0]); i++)
		u.u_rlimit[i].rlim_cur = u.u_rlimit[i].rlim_max = RLIM_INFINITY;

	/* set virtual memory limits */
	vminit();
#ifdef 	QUOTA
	qtinit();
#ifndef	is68k
	p->p_quota = u.u_quota = getquota(0, 0, Q_NDQ);
#endif	is68k
#endif	QUOTA

	/* Initialize tables, and protocols.  */
	cinit();
#include "sl.h"
#if NSL > 0
	slattach();			/* XXX */
#endif
/*#include "loop.h" /**/
/*#if NLOOP > 0 /**/
	loattach();			/* XXX */
/*#endif /**/
	/* Block incoming packets until protocols have been initialized. */
	s = splimp();
	startrtclock();			/* ISI: must be before ifinit */
	InitPkBuf();			/* ISI: initialize packet buffers */
	ifinit();
	domaininit();
	splx(s);
	pqinit();
#ifdef vax
#include "kg.h"
#if NKG > 0
	startkgclock();
#endif
#endif vax
	xinit();
	ihinit();
	bhinit();
	dnlc_init();			/* NFS */
#ifdef	SYSV
	strinit();			/* streams initialization */
	msginit();			/* System V IPC - messages init. */
	seminit();			/* System V IPC - semaphores init. */
	reg_init();			/* Init region list */
	preg_init();			/* Init pregion list */
#endif	SYSV
	binit();
	bswinit();
	mbinit();
#ifdef GPROF
	kmstartup();
#endif

	/* set up the root file system */
#ifdef	TRFS
	TrfsInit();
	if (diskless) {
		extern unsigned long NameToRmid();
		extern struct timeval ConnectTime;

		if (gatewaynamelen && (NameToRmid(gatewayname) == 0))
			panic("gateway to server not responding");
		if (!(servermid = NameToRmid(servername)))
			panic("server not responding");
		u.u_trcdirmid = u.u_trrdirmid = servermid;
		rootdir = NULL;
		u.u_cdir = NULL;
		u.u_rdir = NULL;
		time = ConnectTime;
	} else
#endif	TRFS
	vfs_mountroot();	
	boottime = time;

	/* kick off timeout driven events by calling first time */
	roundrobin();
	schedcpu();
	schedpaging();

	u.u_dmap = zdmap;
	u.u_smap = zdmap;

	/* make init process */
	proc[0].p_szpt = CLSIZE;
	if (newproc(0)) {
#ifdef vax
		expand(clrnd((int)btoc(szicode)), 0);
		(void) swpexpand(u.u_dsize, (size_t)0, &u.u_dmap, &u.u_smap);
		(void) copyout((caddr_t)icode, (caddr_t)0, (unsigned)szicode);
#endif vax
#ifdef is68k
		extern char	*initi;		/* filename for init */
		extern caddr_t	icode;		/* code to exec init */
		extern int	szicode;

		u.u_procp->p_flag &= ~SSYS;
		strcpy(u.u_comm, initi);
		expand(clrnd((int)btoc(szicode)), 0);
		(void) swpexpand(u.u_dsize, 0, &u.u_dmap, &u.u_smap);
		setctx(u.u_procp->p_context = CTX_INVALID);
		(void) copyout((caddr_t)icode, (caddr_t)0, (unsigned)szicode);
		highpri();
#ifdef	TRFS
		if (u.u_trrdirmid)
#define	TRFS_ROOT	"/"
/*#define	TRFS_ROOT	"/.ROOT.$CPU"		/* multi machine */
		    if (SdChdir(RmidToRpid(u.u_trrdirmid), TRFS_ROOT, 1, 1)  ||
			SdChdir(RmidToRpid(u.u_trcdirmid), TRFS_ROOT, 0, 1))
			    panic("no remote root %s directory", TRFS_ROOT);
#endif	TRFS
#endif is68k
		/* Return goes to loc. 0 of user init code just copied out. */
		return;
	}
	/*
	 * make page-out daemon (process 2). the daemon has 
	 * ctopt(nswbuf*CLSIZE*KLMAX) pages of page table so that it can map 
	 * dirty pages into its address space during asychronous pushes.
	 */
	proc[0].p_szpt = clrnd(ctopt(nswbuf*CLSIZE*KLMAX + UPAGES));
	if (newproc(0)) {
		proc[2].p_flag |= SLOAD|SSYS;
		proc[2].p_dsize = u.u_dsize = nswbuf*CLSIZE*KLMAX; 
#ifdef is68k
		strcpy(u.u_comm, "pagedaemon");
		highpri();
		setctx(p->p_context = CTX_SYS);
#endif is68k
		pageout();
		/*NOTREACHED*/
	}
	proc[0].p_szpt = 1;

	GP_fork();		/* ISI: GWS: */
#ifdef	TRFS
	TrfsServer();		/* ISI: TRFS: */
#endif	TRFS
	strcpy(u.u_comm, "scheduler");
	sched();
}

/*
 * Initialize hash links for buffers.
 */
bhinit()
{
	register int i;
	register struct bufhd *bp;

	for (bp = bufhash, i = 0; i < BUFHSZ; i++, bp++)
		bp->b_forw = bp->b_back = (struct buf *)bp;
}

/*
 * Initialize the buffer I/O system by freeing
 * all buffers and setting all device buffer lists to empty.
 */
binit()
{
	register struct buf *bp, *dp;
	register int i;
	struct swdevt *swp;
	int base, residual;

	for (dp = bfreelist; dp < &bfreelist[BQUEUES]; dp++) {
		dp->b_forw = dp->b_back = dp->av_forw = dp->av_back = dp;
		dp->b_flags = B_HEAD;
	}
#ifdef	QBUS
	/*
	 * Add in 18 bit addressable buffers
	 */
	for (i = 0; i < NBUF18; i++) {
		bp = &buf18[i];
		bp->b_dev = NODEV;
		bp->b_bcount = 0;
		bp->b_un.b_addr = (char *)0;
		bp->b_bufsize = 0;
		binshash(bp, &bfreelist[BQ_EMPTY]);
		bp->b_flags = B_18BIT | B_BUSY|B_INVAL;
		brelse(bp);
	}
#endif  QBUS
	base = bufpages / nbuf;
	residual = bufpages % nbuf;
	for (i = 0; i < nbuf; i++) {
		bp = &buf[i];
		bp->b_dev = NODEV;
		bp->b_bcount = 0;
#ifdef vax
		bp->b_un.b_addr = buffers + i * MAXBSIZE;
		if (i < residual)
			bp->b_bufsize = (base + 1) * CLBYTES;
		else
			bp->b_bufsize = base * CLBYTES;
		binshash(bp, &bfreelist[BQ_AGE]);
		bp->b_flags = B_BUSY|B_INVAL;
#endif vax
#ifdef is68k
		bp->b_un.b_addr = (char *)0;
		bp->b_bufsize = 0;
		binshash(bp, &bfreelist[BQ_EMPTY]);
		bp->b_flags = B_EBLK|B_22BIT | B_BUSY|B_INVAL;
#endif is68k
		brelse(bp);
	}
	/*
	 * Count swap devices, and adjust total swap space available.
	 * Some of this space will not be available until a vswapon()
	 * system is issued, usually when the system goes multi-user.
	 */
	nswdev = 0;
	nswap = 0;
	for (swp = swdevt; swp->sw_dev; swp++) {
		nswdev++;
		if (swp->sw_nblks > nswap)
			nswap = swp->sw_nblks;
	}
	if (nswdev == 0)
		panic("binit");
	if (nswdev > 1)
		nswap = ((nswap + dmmax - 1) / dmmax) * dmmax;
	nswap *= nswdev;
	/*
	 * If there are multiple swap areas, 
	 * allow more paging operations per second.
	 */
	if (nswdev > 1)
		maxpgio = (maxpgio * (2 * nswdev - 1)) / 2;
	if (swfree(0))
		panic("binit: swfree");
}

/*
 * Initialize linked list of free swap
 * headers. These do not actually point
 * to buffers, but rather to pages that
 * are being swapped in and out.
 */
bswinit()
{
	register int i;
	register struct buf *sp = swbuf;

	bswlist.av_forw = sp;
	for (i=0; i<nswbuf-1; i++, sp++)
		sp->av_forw = sp+1;
	sp->av_forw = NULL;
}

/*
 * Initialize clist by freeing all character blocks, then count
 * number of character devices. (Once-only routine)
 */
cinit()
{
	register struct cblock *cp;

	/* round cfree to a cblock boundary */
	cfree = (struct cblock *)((((int)cfree)+CROUND) & ~CROUND);

	/* allocate VDMA resources for the all clists */
	cfree_vdma = svqballoc( cfree, nclist * sizeof(struct cblock));

	/* initialize free list */
	for(cp=cfree; cp < &cfree[nclist-1]; cp++) {
		cp->c_next = cfreelist;
		cfreelist = cp;
		cfreecount += CBSIZE;
	}
}
