/*
 * copyright (c) 1985, 1986. Kinetics, Inc.
 *
 * atalk.h :  AppleTalk/DDP protocol definitions.
 */

struct lap {		/* AppleTalk Link Access Protocol Header */
	u_char	dst;		/* destination node */
	u_char	src;		/* source node */
	u_char	type;		/* lap-type (short ddp, long ddp, etc. */
#define 	  LT_SHORTDDP	1	/* short ddp */
#define		  LT_DDP	2	/* regular ddp */
#define		  LT_IP		22	/* ip */
#define		  LT_ARP	23	/* arp */
	u_char	dummy;		/* long-allign lap */
};
#define	SIZEOFLAP	3

struct ddp {		/* Datagram Delivery Protocol Header */
	u_short	d_length;	/* length (+ hopcount) */
	u_short	d_cksum;	/* checksum */
	u_short	d_dnet;		/* dest net */
	u_short	d_snet;		/* source net */
	u_char	d_dnode;	/* dest node */
	u_char	d_snode;	/* source node */
	u_char	d_dsno;		/* destination socket */
#define		  WKS_RTMP	1	/* rtmp socket */
#define		  WKS_NBP	2	/* names information socket */
#define		  WKS_EP	4	/* echo protocol socket */
	u_char 	d_ssno;		/* source socket */
	u_char	d_type;		/* ddp protocol type */
#define		  ddpTypeRTMP	1	/* rtmp protocol */
#define		  ddpTypeNBP	2	/* nbp protocol */
#define		  ddpTypeATP	3	/* atp */
#define		  ddpTypeEP	4	/* echo protocol */
#define		  ddpTypeRTMPReq 5	/* rtmp request */
#define		  ddpTypeZIP	6	/* zip */
#define		  ddpTypeData	10	/* plain data */
	u_char	d_data[3];	/* long-allign */
};
#define	SIZEOFDDP	13
#define	DDPMAXSIZE	587	/* should this be 586 ?? */

struct ddpshort {	/* Short Datagram Delivery Protocol Header */
	u_short	d_length;	/* length */
	u_char	D_dsno;		/* destination socket */
	u_char	D_ssno;		/* source socket, see above */
	u_char	D_type;	       	/* ddp protocol type, see above */
	u_char	D_data[3];	/* long-allign */
};
#define	SIZEOFDDPSHORT	5

#define	ATMAXHOPS	15
#define atgetlength(x)		(ntohs(((struct ddp *)(x))->d_length) & 0x3FF)
#define atgethops(x)		((ntohs(((struct ddp *)(x))->d_length)>>10)&0xF)
/* this sets hop count to 0, too */
#define	atsetlength(x, l) 	(((struct ddp *)(x))->d_length) = htons(l)
#define	atbumphops(x)		(((struct ddp *)(x))->d_length) = \
				 (((atgethops(x) + 1) << 10) + atgetlength(x))

struct rtmp {		/* Routing Table Maintence Protocol */
	u_short	r_net;		/* sender's net */
	u_char	r_idlen;	/* length (bits) of sender's id */
	u_char	r_id;		/* start of id */
};
struct r_tuple {	/* RTMP routing tuple */
	u_short	rt_net;		/* net */
	u_char	rt_dist;	/* distance */
};
#define R_TUPLE_SIZE 3


struct nbp_header {	/* Name-Binding Protocol */
	u_char	nb_cntrl;	/* conrol and tuple count */
#define		  BrRq		1
#define		  LkUp		2
#define		  LkUp_Reply	3
	u_char	nb_id;		/* request id */
};
struct nbp_theader {	/* NBP tuple header */
	u_short	nb_netnum;
	u_char	nb_node;
	u_char	nb_socket;
	u_char	nb_enum;
};
#define nbpTupleHdrSize		5	/* sizeof nbp_tuple - sizeof nbp_name */
struct nbp_field {	/* NBP tuple field */
	u_char	nb_nlength;
	char	nb_string[32];
};
struct nbp_name {	/* NBP tuple entity name */
	struct nbp_field	nb_object;
	struct nbp_field	nb_type;
	struct nbp_field	nb_zone;
};
struct nbp_tuple {	/* NBP tuple */
	char	tuple[nbpTupleHdrSize + sizeof(struct nbp_name)];
};

/* find start of nbp_name given start of nbp_tuple */
#define nbpNameLoc(x)	((struct nbp_name *)(((char *)(x))+nbpTupleHdrSize))
#define nbpnxtfield(p)	{(p) = (struct nbp_field *)(((char *)(p)) + \
			(p)->nb_nlength +1);}

/* NBP error codes */
#define	nbpBuffOvr	-1024	/* buffer overflow in LookupName */
#define	nbpNoConfirm	-1025	/* name not confirmed on ConfirmName */
#define	nbpConfDiff	-1026	/* name confirmed at different socket */
#define	nbpDuplicate	-1027	/* duplicate name already exists */
#define	nbpNotFound	-1028	/* name not found on remove */
#define	nbpNISErr	-1029	/* error trying to open the NIS */
/* added... */
#define nbpNoBufs	-5	/* could not find local buffer space for nbp */

#define NBP_PID		"/usr/appletalk/nbp_pid"
#define	NBP_LOCK	"/usr/appletalk/nbp_lock"
#define	NBPD_PATH	"/usr/appletalk/nbpd"
#define	NAMES_TABLE	"/usr/spool/appletalk/names_table"
#define AT_LOG		"/usr/spool/appletalk/at_log"

/* pap: printer protocol */

/* the part of pap header in the user-bytes part of atp */
struct pap_ubytes {
	u_char	ConnID;
	u_char	PAPType;
#define		  OpenConn		1
#define		  OpenConnReply		2
#define		  SendData		3
#define		  Data			4
#define		  Tickle		5
#define		  CloseConn		6
#define		  CloseConnReply	7
#define		  SendStatus		8
#define		  StatusReply		9
#define		  papBusy		10
	u_char	  eofField;
	u_char	dummy;
};

/* the part of the pap header in the atp data part of atp */
struct pap_xhdr {
	u_char	papSock;	/* responding socket in OpenConn() rqst/rply */
	u_char	papFlowQuant;	/* flow quantum in OpenConn() rqst/rply */
	u_short papWR;		/* wait time (open rqst) or result (open rply)*/
#define	papWaittime papWR
#define	papResult papWR
};

/* pap state in an atpsoc or atpcb */
#define	papConnid	user1
#define	papQuantum	user2
#define papEOFflag	user3
#define papSentEOF	1
#define	papGotEOF	2
#define papTime		user4
#define papStart	user1cb

/* misc */
#define papTimedOut	-2
#define papBufTooBig	-7
#define papUnexpected	-8
#define papNotSupport	-9
#define PAPREAD_TIMO	15
#define PAPMAXTIME	20 /* time wherein pap should get something from peer */

/* echo protocol */
#define	EchoReq		1
#define	EchoRep		2

/* "sizeof" yields incorrect results on some machines */
#define	NFPDEVS		16

/*
 * Someday in the distant future when there might possibly be > 50 appletalk
 * servers available to a UNIX host, someone could increase N_NAMES or
 * make the nbp_remove() process disk-based.
 */
#define N_NAMES	50	/* number of appletalk names known to this host */

#define ELOCKED 500	/* a file was locked */

#ifndef	_IOCTL_
#include <sys/ioctl.h>
#endif	_IOCTL_
#define	SIOIGNADDR	_IO(a, 1)	/* for AppleTalk connect() call */

/*
 * Following definitions from (c) Stanford Univ. SUMEX project. C-language
 * version of atalk.h
 */
/* atalk error codes */
#define	noErr		0
#define	ddpSktErr	-91	/* error in socket number */
#define	ddpLenErr	-92	/* data length too big */
#define	noBridgeErr	-93	/* no net bridge for non-local send */
#define	lapProtErr	-94	/* error in attach/detach */
#define	excessCollsns	-95	/* excessive collisions on write */
#define	portInUse	-97	/* driver Open error */
#define	portNotCf	-98	/* driver Open error */

/* misc structures */
typedef struct {		/* BDS, buffer data structure */
	short	buffSize;
	char	*buffPtr;
	short	dataSize;
	long	userData;
} BDS;

/* UDP-ish stuff */
#define	ddpMaxWKS	0x7F
#define	ddpWKS		128	/* boundary of DDP well known sockets */
#define	ddpWKSUnix	768	/* start of WKS range on UNIX */
#define	ddpNWKSUnix	16384	/* start of non-WKS .. */
#define	userBytes	userData
