#include "saio.h"
#include "sais68k.h"
#include "saboot.h"
#include "../is68kif/if_ring.h"
#include "../is68kif/if_nwreg.h"

extern int ignore_intr;

#define	NNW	1
#define	NWVADDR	0x600000		/* KLUDGE !!! kernel virtual address */
struct nwdevice *nwp = (struct nwdevice *)NWVADDR;

#define splhigh(x)	0	/* dummy */
#define splx(x)		0	/* dummy */

extern u_char		broaddr[6];	/* Ethernet broadcast address */
#define myaddr (nwp->nw_etheraddr)	/* Ethernet address of this machine */
u_char			nwhost[6];	/* Ethernet address of host machine */
struct boot_packet	nw_rcv;
struct boot_packet	nw_xmt;
int			nwsend();
int			nwpkid;
struct st		nwst = {512, -1, -1, -1, -1, NULL};

#define	NWDELAY	1000
#define	NWWAIT(y, z, t)		{ register int i = NWDELAY; 		\
				    if (t)				\
					*(int *)t = 0;			\
				    else				\
					i *= 20;			\
				    while (y) {			\
				    	if (getlocal() == 'x')		\
						return(nwabort(z));	\
				    	else if (--i == 0)		\
					    if (t) { 			\
						*(int *)t = 1;		\
						break;			\
					    } else			\
						return(nwtimeout(z));\
					DELAY(250);			\
				    }					\
				}

nwopen(io)
	register struct iob *io;
{
	register int i;
	short s;
	int vec_save;

	if (io->i_unit >= NNW) {
		printf("nw: not present\n");
		return -1;
	}
	mapin(nwp, (struct nwdevice *)NWPHYS0, NWSIZE);
	if (!probe(nwp, &s)) {
		printf("nw: not present\n");
		return -1;
	}
	nwpkid = 0;
	io->i_st = nwst;

	/* reset card, wait for self test completion, and start card */
	RESET_NW(nwp);
	nwp->nw_ctl_stat = CTL_STAT_RESET;
	UNRESET_NW(nwp);
	NWWAIT(nwp->nw_ctl_stat != CTL_STAT_READY, -1, 0);

	/*
	 * There is no way to initialize the board without causing an 
	 * interrupt! Catch and ignore the interrupt so we dont get strays.
	 */
	ignore_intr = 1;		/* ignore the interrupt */
	nwp->nw_ipend_tohost = 0;
	GO_NW(nwp);

	/* wait for the enet fw to initialize itself */
	NWWAIT(!nwp->nw_ipend_tohost, -2, 0);

	/* catch the interrupt! */
	_splx(0x2000);
	_splx(0x2700);

	if (nwp->nw_base_addr != (int)nwp) {
		printf("nw: failed long access, rejumper CPU\n");
		return -1;
	}
	return netopen(nwsend, io, &nw_xmt, &nw_rcv, &nwpkid, myaddr, nwhost);
}

nwclose(io)
	register struct iob *io;
{
	int err;

	err = netclose(nwsend, io, &nw_xmt, &nw_rcv, &nwpkid, myaddr, nwhost);
	RESET_NW(nwp);
	nwp->nw_ctl_stat = CTL_STAT_RESET;
	UNRESET_NW(nwp);
	return err;
}

nwstrategy(io, func)
	register struct iob *io;
{
	return netstrategy(nwsend, io, func, &nw_xmt, &nw_rcv, &nwpkid, 
		myaddr, nwhost);
}

nwsend(io, bpx, bpr, pkidp)
	struct iob *io;
	register struct boot_packet *bpx, *bpr;
	int *pkidp;
{
	register struct bcb *bcbp;
	register int retry = 0, rcv = 21;	
	int timeout;

	do {
		if (rcv++ > 20) {
			rcv = 0;
			if ((nwxmit(io, bpx) == 0) || (retry++ > 40))
				goto lost;
		}
		do {
		    NWWAIT((bcbp=(struct bcb *)nwringget(nwp->nw_tohost)) == 0,
			0, &timeout);
		    if (timeout && ((retry++ > 40) || (nwxmit(io, bpx) == 0)))
			goto lost;
		} while (timeout);
		bzero(bpr, sizeof(struct boot_packet));
		bcopy(bcbp->b_addr, bpr, bcbp->b_msglen);
		NWWAIT(nwringput(nwp->nw_nwfree, bcbp) == 0, 1, 0);
	} while (bcmp(bpr->bp_eh.ether_dhost, broaddr, 6) == 0 || 
		 bpr->bp_eh.ether_type != ETHERTYPE_ISIBOOT ||
		 bpr->bp_pkid != *pkidp );
	bpx->bp_cmd = bpr->bp_cmd;
	*pkidp = (*pkidp) + 1;
	return 1;
lost:	printf("nw: connection lost\n");
	return 0;
}

nwxmit(io, bpx)
	struct iob *io;
	register struct boot_packet *bpx;
{
	register struct bcb *bcbp;

	NWWAIT((bcbp = (struct bcb *)nwringget(nwp->nw_hostfree)) == 0,
		2, 0);
	bcopy(bpx, bcbp->b_addr, sizeof(struct boot_packet));
	bcbp->b_len = sizeof(struct boot_packet);
	NWWAIT(nwringput(nwp->nw_tonw, bcbp) == 0, 3, 0);
	INTR_NW(nwp);
	return (1);
}

nwtimeout(x)
{
	printf("nw: timeout %d\n", x);
	return(x >= 0 ? 0 : -1);
}

nwabort(x)
{
	printf("nw: abort %d\n", x);
	return(x >= 0 ? 0 : -1);
}

#include "../is68kif/if_nwring.c"
