#include <stdio.h>
#include <nlist.h>

struct nlist nl[] = {
	{ "_directory" },
	{ "" },
};

char *mach[] = { "V20", "V25", "Q10", "V10", 0};
char buf[8192];
int directory[3 * 100];

main(argc, argv)
	int argc;
	char *argv[];
{
	register int recno = 0;
	register int i, n;
	register int f;
	register int testfile = 0;
	register char **mp;
	char fname[30];

	for (i = 1; i < argc; i++) {
	    for (mp = mach; *mp; mp++) {
		directory[testfile++] = recno;
		sprintf(fname, "%s/%s", *mp, argv[i]);
		if ((f = open(fname, 0)) < 0)
			continue;
fprintf(stderr, "%s/%s @ %d\n",*mp, argv[i], recno);
		n = 0;
		while (read(f, buf, 8192) > 0) {
			write(1, buf,8192);
			recno++;
			n++;
		}
		close(f);
		/*
		 * the sadie files must all be of the same length
		 */
		if (i == 1) {
			if (n > 10) {
				fprintf(stderr,"autoboot failure\n");
				exit(0);
			}
			bzero(buf, sizeof(buf));
			while (n < 10) {
				write(1, buf, 8192);
				recno++;
				n++;
			}
		}
	    }
	}

	/*
	 * go back and patch the directory to reflect the tape in all versions
	 * of sadie.
	 */
	for (testfile = 0, mp = mach; *mp; testfile++, mp++) {
		lseek(1, (testfile*10)*8192, 0);
		sprintf(fname, "%s/%s", *mp, argv[1]);
		if ((f = open(fname, 0)) < 0) {
			fprintf(stderr, "%s not found??\n",fname);
			exit(2);
		}
		nlist(fname, nl);
		if (nl[0].n_type == 0) {
			fprintf(stderr,"%s not found in namelist\n",nl[0].n_name);
			exit(0);
		}
		lseek(1, nl[0].n_value + 32 -0x80000, 1);
fprintf(stderr,"%s directory at %x -> %x\n", fname, nl[0].n_value, ftell(1));
		write(1, directory, (3*50)*4);

		lseek(f, nl[0].n_value + 32 -0x80000, 1);
		write(f, directory, (3*50)*4);
	}
}
