#include 	"saio.h"
#include 	"sais68k.h"
#include	<setjmp.h>
#include	"../machine/trap.h"

extern int autoboot;
extern int hadint;
extern int dorte;
extern int ignore_intr;

#define 	MEMTRAP		*(int *)(0x08)
#define 	ADRTRAP		*(int *)(0x0C)

static jmp_buf	env;
static int	interrupt_on;

static 
probetrp()
{
	longjmp(env,1);
}

probe(addr,val)
	register short *addr, *val;
{
	register int 	ret = 1;
	register int	savmtrap = MEMTRAP;
	register int	savatrap = ADRTRAP;

	MEMTRAP = (int)probetrp;
	ADRTRAP = (int)probetrp;

	if ( !setjmp(env) ) {
		register int zzz = *addr;

		if (*val)
			;
		*val = zzz;
	} else
		ret = 0;
		
	MEMTRAP = savmtrap;
	ADRTRAP = savatrap;
	return (ret);
}

probeb(addr,val)
	register char *addr, *val;
{
	register int 	ret = 1;
	register int	savtrap = MEMTRAP;

	MEMTRAP = (int)probetrp;

	if ( !setjmp(env) )
		*val = *addr;
	else
		ret = 0;
		
	MEMTRAP = savtrap;
	return (ret);
}

probel(addr,val)
	register int *addr, *val;
{
	register int 	ret = 1;
	register int	savtrap = MEMTRAP;

	MEMTRAP = (int)probetrp;

	if ( !setjmp(env) )
		*val = *addr;
	else
		ret = 0;
		
	MEMTRAP = savtrap;
	return (ret);
}

probelw(addr,val)
	register int *addr, val;
{
	register int 	ret = 1;
	register int	savtrap = MEMTRAP;

	MEMTRAP = (int)probetrp;

	if ( !setjmp(env) )
		*addr = val;
	else
		ret = 0;
		
	MEMTRAP = savtrap;
	return (ret);
}

traperr(x)
	int x;
{
	register union esf *esf = (union esf *)(((int *)&x)+4);

#ifdef	VBUS
#ifdef	M68010
	if (interrupt_on  &&  esf->f0.esf_vec == 96) {
		turnoffint();			/* take away interrupt req */
		return;
	}
#endif	M68010
#endif	VBUS
	if (ignore_intr) {
		ignore_intr = 0;
		dorte = 1;
		return;
	}
	autoboot = 0;
	hadint = 1;
	printf("Trap: pc=%x,%x sr=%x vec=%x format=%x\n", 
		esf->f0.esf_pc, paddr(esf->f0.esf_pc), esf->f0.esf_sw,
		(esf->f0.esf_vec&ESF_VECMSK) >> ESF_VECSHIFT,
		(esf->f0.esf_vec&ESF_FMTMSK) >> ESF_FMTSHIFT );
	if ((esf->f0.esf_vec&ESF_FMTMSK) == ESF_FMT8 ||
	    (esf->f0.esf_vec&ESF_FMTMSK) == ESF_FMTA ||
	    (esf->f0.esf_vec&ESF_FMTMSK) == ESF_FMTB   ) {
#ifdef	M68020
		printf("  adr=%x,%x ssw=%x esr=%b\n", esf->fa.esf_faddr_20, 
			paddr(esf->fa.esf_faddr_20), esf->fa.esf_ssw_20,
			*ESR, ESR_BERBITS);
#else	M68020
		printf("  adr=%x,%x ssw=%x\n", esf->f8.esf_faddr_10, 
			paddr(esf->f8.esf_faddr_10), esf->f8.esf_ssw_10);
#endif	M68020
	}
}

#ifdef	QBUS
addr18(x)
long x;
{
	return( (x&0xFFC00000) ? 0 : 1);
}
#endif	QBUS

paddr(x)
	register long x;
{
	register long ret;
#ifdef	QBUS
	ret=((((long)((*(short *)((x&0x3FF000)|0x800000))&0xFFC))<<10)|
		(x&0xFFF));
#else	QBUS
#ifdef	M68020
	ret = x & NONT_MASK;
#else	M68020
	ret=((((long)((*(short *)(((x&0x7FF000)>>11)|PAGREGBASE))&0xFFF))<<12)
		|(x&0xFFF));
#endif	M68020
#endif	QBUS
	return (ret);
}

#ifdef	M68020
onetoone(cache)
{
	register int i, *p;
	
#ifdef	M68025
	if (cache)
		cache = PG_CACHE;
#endif	M68025
	p = (int *)TBUF_BASE_SYS;
	for (i = 0; i < NTBUFS ; i++) {
		*p = TBUF_VALID|PG_V|PG_R|PG_M|cache|i; /* system valid 1:1 */
		p += (TBUF_INCR/sizeof( int));
	}
	p = (int *)TBUF_BASE_USR;
	for (i = 0; i < NTBUFS ; i++) {
		*p = TBUF_VALID|PG_V|PG_R|PG_M|cache|i; /* user valid 1:1 */
		p += (TBUF_INCR/sizeof( int));
	}
#ifdef	M68025
	if (cache && ((bsr & BSR_W_CACHE) == 0)) {
			bsr |= BSR_W_CACHE;
		p = (int *)CTAG_A_BASE;
		for (i = 0; i < NCTAGS ; i++) {
			*p = CTAG_INVALID;
			p += (CTAG_INCR/sizeof( int));
		}
		p = (int *)CTAG_B_BASE;
		for (i = 0; i < NCTAGS ; i++) {
			*p = CTAG_INVALID;
			p += (CTAG_INCR/sizeof( int));
		}
		bsr |= BSR_W_CACHE;
		*BSR = bsr;
	}
	p = (int *)VDMA_BASE;
	for (i = 0; i < NVDMAS ; i++) {
		*p = VDMA_VALID | i;		/* valid 1:1 */
		p += (VDMA_INCR/sizeof( int));
	}
#endif	M68025
}

cpux()
{
	register int n = (~(*BSR))&BSR_CNODE;

	if (n == BSR_CNODE)
		n = 0;
	return n;	/* return cluster node number */
}
#endif	M68020

#ifdef	VBUS
#ifdef	M68010
mapin(vaddr, paddr, len)
	register unsigned long vaddr, paddr;
	register int len;
{
	do {
		*(short *)(((vaddr >> 11) | PAGREGBASE) & ~1) = paddr >> 12;
		vaddr += NBPG;
		paddr += NBPG;
	} while ((len -= NBPG) > 0);
}

turnonint()
{
	short s = *(short *)0xC1E000;

	interrupt_on = 1;
	return s;
}

turnoffint()
{
	short s = *(short *)0xC1A000;

	interrupt_on = 0;
	return s;
}

cpux()
{
	register int i;
	int savedorte = dorte;

	dorte = 1;
	turnonint();
	for (i = 7;  i >= 0;  i -= 1) {
		_splx(0x2000 + (i << 8));
		DELAY(1000);
		_splx(0x2700);
		if (!interrupt_on) {
			dorte = savedorte;
			return i + 1;
		}
	}
	turnoffint();
	dorte = savedorte;
	return 0;
}
#endif	M68010
#endif	VBUS
