#include "saio.h"
#include "sais68k.h"
#include "../is68kdev/scsi.h"
#include "../is68kdev/gsreg.h"

/*        _________________________________
 * ctlr:  | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
 *        ---------------------------------
 *                 \_cont____/ \__device_/
 */
#define	GS_CONT(ctlr)	(ctlr >> 3)
#define	GS_DEVICE(ctlr)	(ctlr & 0x7)

#define NGS		4
struct gsdevice *GSstd[NGS] = {
		(struct gsdevice *)&vme_stdio[0xFFFFc0],
		(struct gsdevice *)&vme_stdio[0xFFFFd0],
		(struct gsdevice *)&vme_stdio[0xFFFFe0],
		(struct gsdevice *)&vme_stdio[0xFFFFf0]
};

struct gs_hacb	gs_hacb[NGS];	/* host adaptor control blocks */
struct buf	*gsmembhp;

gsopen(ctlr)
	register int ctlr;
{
	register int cont = GS_CONT(ctlr);
	register struct gsdevice *gsaddr = GSstd[cont];
	int i;

	if (cont >= NGS) {
		printf("gs%d: bad controller\n", cont);
		return (-1);
	}
	if (!probe(&gsaddr->gs_loc, &i) ||
	    (gswait(gsaddr) & GS_LOC_ID_MASK) != GS_LOC_ID ) {
		printf("gs%d: not present\n", cont);
		return (-1);
	}
	if ((gsinit(gsaddr, &gs_hacb[cont]) & GS_LOC_ID_MASK) != GS_LOC_ID) {
		printf("gs%d: init failed\n", cont);
		return (-1);
	}
	return (0);
}

gspoll(ctlr, time)
{
	register int			cont  = GS_CONT(ctlr);
	register int			device  = GS_DEVICE(ctlr);
	register struct gsdevice	*gsaddr = GSstd[cont];
	register struct gs_hacb		*hacb = &gs_hacb[cont];
	long				i;

	i = 80000;
	do {
		hacb->hacb_semhost = 0;
		hacb->hacb_semhost = 1;
		if (i-- == 0) {
			printf("gs%d: semaphore timeout\n", cont);
			return (-1);
		}
	} while (hacb->hacb_semhadpt);

	hacb->hacb_dcr |= (DCR_GO << device);
	hacb->hacb_semhost = 0;
	gsaddr->gs_loc = GS_LOC_GO;
	for (; hacb->hacb_dcr & (DCR_GO << device); time--) {
		if (time == 0) {
			printf("gs%d: controller timed out\n", cont);
			return (-1);
		}
		DELAY(400);
	}

	i = 80000;
	do {
		hacb->hacb_semhost = 0;
		hacb->hacb_semhost = 1;
		if (i-- == 0) {
			printf("gs%d: semaphore timeout\n", cont);
			return (-1);
		}
	} while (hacb->hacb_semhadpt);
	hacb->hacb_dcr &= ~(DCR_BUSY << device);
	hacb->hacb_semhost = 0;
	return (0);
}

gsinit(gsaddr, hacb)
	register struct gsdevice	*gsaddr;
	register struct gs_hacb		*hacb;
{
	register int	i = 80000;

	bzero((char *)hacb, sizeof(struct gs_hacb));
	do {
        	gsaddr->gs_loc = GS_LOC_INIT;
		if (i-- == 0)
			return 0;
	} while (gsaddr->gs_loc != GS_LOC_INIT_OK);

	/* addr modifier/interrupt vector, addr of host adaptor control block */
	gsaddr->gs_loc = 0;
	gsaddr->gs_loc = paddr(hacb) >> 16;
	gsaddr->gs_loc = paddr(hacb);
	return gswait(gsaddr);
}

gswait(gsaddr)
	struct gsdevice	*gsaddr;
{
	register int	i;

	for(i = 80000; gsaddr->gs_loc == 0xFFFF && i; i--)
		DELAY(200);
	return (gsaddr->gs_loc);
}

struct hacb_dcb *gsgetdcb(ctlr)
	register int ctlr;
{
	return (&gs_hacb[GS_CONT(ctlr)].hacb_dcb[GS_DEVICE(ctlr)]);
}

gsprint(p, s, l)
	register u_char *p, *s;
{
	register int i;

	printf("  %s: %d bytes @ %x\n", p, l, s);
	for (i = 0 ; i < l; i++)
		printf("    %2d: %2x\n", i, *s++);
}
